/* Generated from posixunix.scm by the CHICKEN compiler
   http://www.call-with-current-continuation.org
   2007-04-10 09:26
   Version 2.610 - linux-unix-gnu-x86 - [ libffi dload ptables applyhook ]
   command line: posixunix.scm -output-file posixunix.c -quiet -no-trace -optimize-level 2 -include-path . -explicit-use
   unit: posix
*/

#include "chicken.h"

#include <signal.h>
#include <errno.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

static C_TLS int C_wait_status;

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <sys/utsname.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>

#ifdef ECOS
#include <cyg/posix/signal.h>
#endif

#ifdef HAVE_GRP_H
#include <grp.h>
#endif

#include <sys/mman.h>
#include <time.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef ARG_MAX
# define ARG_MAX 256
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#if defined(HAVE_CRT_EXTERNS_H)
# include <crt_externs.h>
# define C_getenventry(i)       ((*_NSGetEnviron())[ i ])
#elif defined(C_MACOSX)
# define C_getenventry(i)       NULL
#else
extern char **environ;
# define C_getenventry(i)       (environ[ i ])
#endif

#ifndef ENV_MAX
# define ENV_MAX        1024
#endif

static C_TLS char *C_exec_args[ ARG_MAX ];
static C_TLS char *C_exec_env[ ENV_MAX ];
static C_TLS struct utsname C_utsname;
static C_TLS struct flock C_flock;
static C_TLS DIR *temphandle;
#ifndef ECOS
static C_TLS struct passwd *C_user;
#ifdef HAVE_GRP_H
static C_TLS struct group *C_group;
#else
struct C_fake_group {
  int gr_gid;
  int gr_mem[ 1 ];
  char *gr_name;
  char *gr_passwd;
};
static C_TLS struct C_fake_group *C_group;
#endif
static C_TLS int C_pipefds[ 2 ];
#endif
static C_TLS time_t C_secs;
static C_TLS struct tm C_tm;
static C_TLS fd_set C_fd_sets[ 2 ];
static C_TLS struct timeval C_timeval;
static C_TLS char C_hostbuf[ 256 ];
static C_TLS struct stat C_statbuf;

#define C_mkdir(str)        C_fix(mkdir(C_c_string(str), S_IRWXU | S_IRWXG | S_IRWXO))
#define C_chdir(str)        C_fix(chdir(C_c_string(str)))
#define C_rmdir(str)        C_fix(rmdir(C_c_string(str)))

#define C_opendir(x,h)          C_set_block_item(h, 0, (C_word) opendir(C_c_string(x)))
#define C_closedir(h)           (closedir((DIR *)C_block_item(h, 0)), C_SCHEME_UNDEFINED)
#define C_readdir(h,e)          C_set_block_item(e, 0, (C_word) readdir((DIR *)C_block_item(h, 0)))
#define C_foundfile(e,b)        (strcpy(C_c_string(b), ((struct dirent *) C_block_item(e, 0))->d_name), C_fix(strlen(((struct dirent *) C_block_item(e, 0))->d_name)))

#define C_curdir(buf)       (getcwd(C_c_string(buf), 256) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

#ifndef ECOS
#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getpid            getpid
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_data_pointer(fn), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_data_pointer(fn), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_data_pointer(o), C_data_pointer(n)))
#define C_readlink(f, b)    C_fix(readlink(C_data_pointer(f), C_data_pointer(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam((char *)C_data_pointer(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#ifdef HAVE_GRP_H
#define C_getgrnam(n)       C_mk_bool((C_group = getgrnam((char *)C_data_pointer(n))) != NULL)
#define C_getgrgid(u)       C_mk_bool((C_group = getgrgid(C_unfix(u))) != NULL)
#else
#define C_getgrnam(n)       C_SCHEME_FALSE
#define C_getgrgid(n)       C_SCHEME_FALSE
#endif
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate((char *)C_data_pointer(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#endif
#define C_uname             C_fix(uname(&C_utsname))
#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_C_fileno(p)       C_fix(fileno(C_port_file(p)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))
#define C_alarm             alarm
#define C_setvbuf(p, m, s)  C_fix(setvbuf(C_port_file(p), NULL, C_unfix(m), C_unfix(s)))
#define C_access(fn, m)     C_fix(access((char *)C_data_pointer(fn), C_unfix(m)))
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_sleep             sleep

#define C_putenv(s)         C_fix(putenv((char *)C_data_pointer(s)))
#define C_stat(fn)          C_fix(stat((char *)C_data_pointer(fn), &C_statbuf))
#define C_lstat(fn)         C_fix(lstat((char *)C_data_pointer(fn), &C_statbuf))
#define C_fstat(f)          C_fix(fstat(C_unfix(f), &C_statbuf))

#define C_islink            ((C_statbuf.st_mode & S_IFMT) == S_IFLNK)
#define C_isreg             ((C_statbuf.st_mode & S_IFMT) == S_IFREG)

#ifdef C_GNU_ENV
# define C_setenv(x, y)     C_fix(setenv((char *)C_data_pointer(x), (char *)C_data_pointer(y), 1))
#else
static C_word C_fcall C_setenv(C_word x, C_word y);
C_word C_fcall C_setenv(C_word x, C_word y) {
  char *sx = C_data_pointer(x),
       *sy = C_data_pointer(y);
  int n1 = C_strlen(sx), n2 = C_strlen(sy);
  char *buf = (char *)C_malloc(n1 + n2 + 2);
  if(buf == NULL) return(C_fix(0));
  else {
    C_strcpy(buf, sx);
    buf[ n1 ] = '=';
    C_strcpy(buf + n1 + 1, sy);
    return(C_fix(putenv(buf)));
  }
}
#endif

static void C_fcall C_set_arg_string(char **where, int i, char *a, int len) {
  char *ptr;
  if(a != NULL) {
    ptr = (char *)C_malloc(len + 1);
    C_memcpy(ptr, a, len);
    ptr[ len ] = '\0';
  }
  else ptr = NULL;
  where[ i ] = ptr;
}

static void C_fcall C_free_exec_args() {
  char **a = C_exec_args;
  while((*a) != NULL) C_free(*(a++));
}

static void C_fcall C_free_exec_env() {
  char **a = C_exec_env;
  while((*a) != NULL) C_free(*(a++));
}

#define C_set_exec_arg(i, a, len)      C_set_arg_string(C_exec_args, i, a, len)
#define C_set_exec_env(i, a, len)      C_set_arg_string(C_exec_env, i, a, len)

#define C_execvp(f)         C_fix(execvp(C_data_pointer(f), C_exec_args))
#define C_execve(f)         C_fix(execve(C_data_pointer(f), C_exec_args, C_exec_env))

#if defined(__FreeBSD__) || defined(C_MACOSX) || defined(__NetBSD__) || defined(__OpenBSD__) || defined(__sgi__) || defined(sgi) || defined(__DragonFly__) || defined(__SUNPRO_C)
static C_TLS int C_uw;
# define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
# define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
# define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
# define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
# define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
# define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))
#else
# define C_WIFEXITED(n)      C_mk_bool(WIFEXITED(C_unfix(n)))
# define C_WIFSIGNALED(n)    C_mk_bool(WIFSIGNALED(C_unfix(n)))
# define C_WIFSTOPPED(n)     C_mk_bool(WIFSTOPPED(C_unfix(n)))
# define C_WEXITSTATUS(n)    C_fix(WEXITSTATUS(C_unfix(n)))
# define C_WTERMSIG(n)       C_fix(WTERMSIG(C_unfix(n)))
# define C_WSTOPSIG(n)       C_fix(WSTOPSIG(C_unfix(n)))
#endif

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1);
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo((char *)C_data_pointer(fn), C_unfix(m)))
#endif

#define C_flock_setup(t, s, n) (C_flock.l_type = C_unfix(t), C_flock.l_start = C_num_to_int(s), C_flock.l_whence = SEEK_SET, C_flock.l_len = C_num_to_int(n), C_SCHEME_UNDEFINED)
#define C_flock_test(p)     (fcntl(fileno(C_port_file(p)), F_GETLK, &C_flock) >= 0 ? (C_flock.l_type == F_UNLCK ? C_fix(0) : C_fix(C_flock.l_pid)) : C_SCHEME_FALSE)
#define C_flock_lock(p)     C_fix(fcntl(fileno(C_port_file(p)), F_SETLK, &C_flock))
#define C_flock_lockw(p)    C_fix(fcntl(fileno(C_port_file(p)), F_SETLKW, &C_flock))

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static C_TLS sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_write(fd, b, n)   C_fix(write(C_unfix(fd), C_data_pointer(b), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ftell(p)            C_fix(ftell(C_port_file(p)))
#define C_fseek(p, n, w)      C_mk_nbool(fseek(C_port_file(p), C_unfix(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_unfix(o), C_unfix(w)))

#define C_zero_fd_set(i)      FD_ZERO(&C_fd_sets[ i ])
#define C_set_fd_set(i, fd)   FD_SET(fd, &C_fd_sets[ i ])
#define C_test_fd_set(i, fd)  FD_ISSET(fd, &C_fd_sets[ i ])
#define C_C_select(m)         C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, NULL))
#define C_C_select_t(m, t)    (C_timeval.tv_sec = C_unfix(t), C_timeval.tv_usec = 0, C_fix(select(C_unfix(m), &C_fd_sets[ 0 ], &C_fd_sets[ 1 ], NULL, &C_timeval)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__CYGWIN__) || defined(__SVR4)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

time_t timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#endif

#if !defined(C_GNU_ENV) || defined(__CYGWIN__) || defined(__uClinux__)
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), (C_temporary_flonum = timegm(&C_tm)) != -1)
#else
# define C_asctime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), asctime(&C_tm) )
# define C_mktime(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = mktime(&C_tm)) != -1)
# define C_timegm(v)        (memset(&C_tm, 0, sizeof(struct tm)), C_tm.tm_sec = C_unfix(C_block_item(v, 0)), C_tm.tm_min = C_unfix(C_block_item(v, 1)), C_tm.tm_hour = C_unfix(C_block_item(v, 2)), C_tm.tm_mday = C_unfix(C_block_item(v, 3)), C_tm.tm_mon = C_unfix(C_block_item(v, 4)), C_tm.tm_year = C_unfix(C_block_item(v, 5)), C_tm.tm_wday = C_unfix(C_block_item(v, 6)), C_tm.tm_yday = C_unfix(C_block_item(v, 7)), C_tm.tm_isdst = (C_block_item(v, 8) != C_SCHEME_FALSE), C_tm.tm_gmtoff = C_unfix(C_block_item(v, 9)), (C_temporary_flonum = timegm(&C_tm)) != -1)
#endif

#ifndef ECOS
static gid_t *C_groups = NULL;

#define C_get_gid(n)      C_fix(C_groups[ C_unfix(n) ])
#define C_set_gid(n, id)  (C_groups[ C_unfix(n) ] = C_unfix(id), C_SCHEME_UNDEFINED)
#define C_set_groups(n)   C_fix(setgroups(C_unfix(n), C_groups))
#endif

static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_externimport void C_ccall C_scheduler_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_regex_toplevel)
C_externimport void C_ccall C_regex_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_extras_toplevel)
C_externimport void C_ccall C_extras_toplevel(C_word c,C_word d,C_word k) C_noret;
C_noret_decl(C_utils_toplevel)
C_externimport void C_ccall C_utils_toplevel(C_word c,C_word d,C_word k) C_noret;

static C_TLS C_word lf[639];


/* from k6177 in set-root-directory! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub1215(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub1215(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from k5431 */
static C_word C_fcall stub976(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub976(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_sleep(t0));
return C_r;}

/* from parent-process-id in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub973(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub973(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from current-process-id in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub971(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub971(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from freeenv */
static C_word C_fcall stub903(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub903(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_env();
return C_r;}

/* from k5140 */
static C_word C_fcall stub896(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub896(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_env(t0,t1,t2);
return C_r;}

/* from freeargs */
static C_word C_fcall stub891(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub891(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_free_exec_args();
return C_r;}

/* from k5121 */
static C_word C_fcall stub884(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub884(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_set_exec_arg(t0,t1,t2);
return C_r;}

/* from k5097 */
static C_word C_fcall stub872(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub872(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from fork */
static C_word C_fcall stub867(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub867(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

/* from getit */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub830(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub830(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
if(gethostname(C_hostbuf, 256) == -1) return(NULL);
              else return(C_hostbuf);
C_return:
#undef return

return C_r;}

/* from k4917 */
static C_word C_fcall stub822(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub822(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)ttyname(t0));
return C_r;}

/* from k4828 */
static C_word C_fcall stub805(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub805(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

/* from k4803 */
static C_word C_fcall stub799(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub799(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
_exit(t0);
return C_r;}

/* from local-timezone-abbreviation in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub794(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub794(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__)
time_t clock = (time_t)0;struct tm *ltm = C_localtime(&clock);char *z = ltm ? (char *)ltm->tm_zone : 0;
#else
char *z = (daylight ? tzname[1] : tzname[0]);
#endif
return(z);
C_return:
#undef return

return C_r;}

/* from asctime */
static C_word C_fcall stub779(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub779(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0));
return C_r;}

/* from k4690 */
static C_word C_fcall stub770(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub770(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from k4609 */
static C_word C_fcall stub739(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub739(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
C_r=C_fix((C_word)munmap(t0,t1));
return C_r;}

/* from k4547 */
static C_word C_fcall stub714(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5) C_regparm;
C_regparm static C_word C_fcall stub714(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4,C_word C_a5){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_num_to_int(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
int t4=(int )C_unfix(C_a4);
int t5=(int )C_num_to_int(C_a5);
C_r=C_mpointer_or_false(&C_a,(void*)mmap(t0,t1,t2,t3,t4,t5));
return C_r;}

/* from k4447 */
static C_word C_fcall stub692(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub692(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from k3428 in k3424 in file-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub463(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub463(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
char * t1=(char * )C_string_or_null(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from a6227 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub422(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub422(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a6230 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub418(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub418(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

/* from a6233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub412(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub412(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a6251 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall stub408(C_word C_buf) C_regparm;
C_regparm static C_word C_fcall stub408(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from k3098 */
static C_word C_fcall stub379(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub379(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_string_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)initgroups(t0,t1));
return C_r;}

/* from k2967 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub352(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub352(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
if(C_groups != NULL) C_free(C_groups);C_groups = (gid_t *)C_malloc(sizeof(gid_t) * n);if(C_groups == NULL) return(0);else return(1);
C_return:
#undef return

return C_r;}

/* from k2960 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub348(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub348(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int n=(int )C_unfix(C_a0);
return(getgroups(n, C_groups));
C_return:
#undef return

return C_r;}

/* from k2899 */
#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_return; C_cblockend
static C_word C_fcall stub336(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub336(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
return(C_group->gr_mem[ i ]);
C_return:
#undef return

return C_r;}

/* from k1746 */
static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub92(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mk_bool(C_test_fd_set(t0,t1));
return C_r;}

/* from k1736 */
static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1) C_regparm;
C_regparm static C_word C_fcall stub86(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_set_fd_set(t0,t1);
return C_r;}

/* from k1726 */
static C_word C_fcall stub81(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub81(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_zero_fd_set(t0);
return C_r;}

/* from k1508 */
static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2) C_regparm;
C_regparm static C_word C_fcall stub24(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k1457 */
#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_return; C_cblockend
static C_word C_fcall stub17(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub17(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
fd_set in;struct timeval tm;FD_ZERO(&in);FD_SET(fd, &in);tm.tv_sec = tm.tv_usec = 0;if(select(fd + 1, &in, NULL, NULL, &tm) == -1) return(-1);else return(FD_ISSET(fd, &in) ? 1 : 0);
C_return:
#undef return

return C_r;}

/* from k1450 */
#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_return; C_cblockend
static C_word C_fcall stub13(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub13(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);if(val == -1) return(0);return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_return:
#undef return

return C_r;}

/* from k1426 */
static C_word C_fcall stub3(C_word C_buf,C_word C_a0) C_regparm;
C_regparm static C_word C_fcall stub3(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(C_posix_toplevel)
C_externexport void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1405)
static void C_ccall f_1405(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1408)
static void C_ccall f_1408(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1411)
static void C_ccall f_1411(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1414)
static void C_ccall f_1414(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1417)
static void C_ccall f_1417(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6276)
static void C_ccall f_6276(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6292)
static void C_ccall f_6292(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6280)
static void C_ccall f_6280(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6283)
static void C_ccall f_6283(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2124)
static void C_ccall f_2124(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2675)
static void C_ccall f_2675(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6270)
static void C_ccall f_6270(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2810)
static void C_ccall f_2810(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6255)
static void C_ccall f_6255(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6265)
static void C_ccall f_6265(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6252)
static void C_ccall f_6252(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3231)
static void C_ccall f_3231(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6237)
static void C_ccall f_6237(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6247)
static void C_ccall f_6247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6234)
static void C_ccall f_6234(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3235)
static void C_ccall f_3235(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6231)
static void C_ccall f_6231(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3254)
static void C_ccall f_3254(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6228)
static void C_ccall f_6228(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3273)
static void C_ccall f_3273(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6210)
static void C_ccall f_6210(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6223)
static void C_ccall f_6223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6217)
static void C_ccall f_6217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3355)
static void C_ccall f_3355(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3394)
static void C_ccall f_3394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6187)
static void C_ccall f_6187(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6179)
static void C_ccall f_6179(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5948)
static void C_ccall f_5948(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_5948)
static void C_ccall f_5948r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_6105)
static void C_fcall f_6105(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6111)
static void C_ccall f_6111(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6100)
static void C_fcall f_6100(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_6095)
static void C_fcall f_6095(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5950)
static void C_fcall f_5950(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6082)
static void C_ccall f_6082(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_6090)
static void C_ccall f_6090(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5957)
static void C_fcall f_5957(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6070)
static void C_ccall f_6070(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5967)
static void C_ccall f_5967(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5969)
static void C_fcall f_5969(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5988)
static void C_ccall f_5988(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6056)
static void C_ccall f_6056(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6063)
static void C_ccall f_6063(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6050)
static void C_ccall f_6050(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6003)
static void C_ccall f_6003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6037)
static void C_ccall f_6037(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6023)
static void C_ccall f_6023(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6035)
static void C_ccall f_6035(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6031)
static void C_ccall f_6031(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6015)
static void C_ccall f_6015(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6013)
static void C_ccall f_6013(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_6074)
static void C_ccall f_6074(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5888)
static void C_ccall f_5888(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5888)
static void C_ccall f_5888r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5900)
static void C_fcall f_5900(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5895)
static void C_fcall f_5895(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5890)
static void C_fcall f_5890(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5828)
static void C_ccall f_5828(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5828)
static void C_ccall f_5828r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5840)
static void C_fcall f_5840(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5835)
static void C_fcall f_5835(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5830)
static void C_fcall f_5830(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5763)
static void C_fcall f_5763(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5822)
static void C_ccall f_5822(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5826)
static void C_ccall f_5826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5814)
static void C_ccall f_5814(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5770)
static void C_ccall f_5770(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5802)
static void C_ccall f_5802(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5773)
static void C_ccall f_5773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5784)
static void C_ccall f_5784(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5778)
static void C_ccall f_5778(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5707)
static void C_ccall f_5707(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8) C_noret;
C_noret_decl(f_5719)
static void C_ccall f_5719(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_5750)
static void C_ccall f_5750(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5730)
static void C_ccall f_5730(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5746)
static void C_ccall f_5746(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5734)
static void C_ccall f_5734(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5742)
static void C_ccall f_5742(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5738)
static void C_ccall f_5738(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5713)
static void C_ccall f_5713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5696)
static void C_fcall f_5696(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5700)
static void C_ccall f_5700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5685)
static void C_fcall f_5685(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_5689)
static void C_ccall f_5689(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5624)
static void C_fcall f_5624(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_5628)
static void C_ccall f_5628(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5631)
static void C_ccall f_5631(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5634)
static void C_ccall f_5634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5663)
static void C_ccall f_5663(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5667)
static void C_ccall f_5667(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5670)
static void C_ccall f_5670(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5673)
static void C_ccall f_5673(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5661)
static void C_ccall f_5661(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5635)
static C_word C_fcall f_5635(C_word *a,C_word t0);
C_noret_decl(f_5607)
static void C_fcall f_5607(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5620)
static void C_ccall f_5620(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5529)
static void C_ccall f_5529(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5590)
static void C_fcall f_5590(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5603)
static void C_ccall f_5603(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5606)
static void C_ccall f_5606(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5570)
static void C_fcall f_5570(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5585)
static void C_ccall f_5585(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5579)
static void C_ccall f_5579(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5533)
static void C_fcall f_5533(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_5535)
static void C_ccall f_5535(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5556)
static void C_ccall f_5556(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5550)
static void C_ccall f_5550(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5477)
static void C_ccall f_5477(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5477)
static void C_ccall f_5477r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5484)
static void C_ccall f_5484(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5503)
static void C_ccall f_5503(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5507)
static void C_ccall f_5507(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5471)
static void C_ccall f_5471(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5462)
static void C_ccall f_5462(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5466)
static void C_ccall f_5466(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5435)
static void C_ccall f_5435(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5435)
static void C_ccall f_5435r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5428)
static void C_ccall f_5428(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5425)
static void C_ccall f_5425(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5422)
static void C_ccall f_5422(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5344)
static void C_ccall f_5344(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5344)
static void C_ccall f_5344r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5380)
static void C_ccall f_5380(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5374)
static void C_ccall f_5374(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5327)
static void C_ccall f_5327(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5148)
static void C_ccall f_5148(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_5148)
static void C_ccall f_5148r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_5279)
static void C_fcall f_5279(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5274)
static void C_fcall f_5274(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5150)
static void C_fcall f_5150(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5160)
static void C_ccall f_5160(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5168)
static void C_fcall f_5168(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_5211)
static C_word C_fcall f_5211(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_5181)
static void C_fcall f_5181(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5206)
static void C_ccall f_5206(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5184)
static void C_ccall f_5184(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5129)
static C_word C_fcall f_5129(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_5110)
static C_word C_fcall f_5110(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_5068)
static void C_ccall f_5068(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_5068)
static void C_ccall f_5068r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_5090)
static void C_ccall f_5090(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5094)
static void C_ccall f_5094(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4968)
static void C_fcall f_4968(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4989)
static void C_ccall f_4989(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5060)
static void C_ccall f_5060(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4993)
static void C_ccall f_4993(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5000)
static void C_ccall f_5000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5002)
static void C_fcall f_5002(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_5019)
static void C_ccall f_5019(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5029)
static void C_ccall f_5029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_5033)
static void C_ccall f_5033(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4983)
static void C_ccall f_4983(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4950)
static void C_ccall f_4950(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4954)
static void C_ccall f_4954(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4957)
static void C_ccall f_4957(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4920)
static void C_ccall f_4920(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4924)
static void C_ccall f_4924(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4927)
static void C_ccall f_4927(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4891)
static void C_ccall f_4891(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4895)
static void C_ccall f_4895(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4898)
static void C_ccall f_4898(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4832)
static void C_ccall f_4832(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_4832)
static void C_ccall f_4832r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_4836)
static void C_ccall f_4836(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4842)
static void C_ccall f_4842(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4825)
static void C_ccall f_4825(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4806)
static void C_ccall f_4806(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_4806)
static void C_ccall f_4806r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_4810)
static void C_ccall f_4810(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4794)
static void C_ccall f_4794(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4766)
static void C_ccall f_4766(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4773)
static void C_ccall f_4773(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4738)
static void C_ccall f_4738(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4745)
static void C_ccall f_4745(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4710)
static void C_ccall f_4710(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4717)
static void C_ccall f_4717(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4720)
static void C_ccall f_4720(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4723)
static void C_ccall f_4723(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4693)
static void C_ccall f_4693(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4697)
static void C_ccall f_4697(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4700)
static void C_ccall f_4700(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4674)
static void C_ccall f_4674(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4665)
static void C_ccall f_4665(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4659)
static void C_ccall f_4659(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4650)
static void C_ccall f_4650(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4615)
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4615)
static void C_ccall f_4615r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4553)
static void C_ccall f_4553(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...) C_noret;
C_noret_decl(f_4553)
static void C_ccall f_4553r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t8) C_noret;
C_noret_decl(f_4557)
static void C_ccall f_4557(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4563)
static void C_ccall f_4563(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4582)
static void C_ccall f_4582(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4569)
static void C_ccall f_4569(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4450)
static void C_ccall f_4450(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4456)
static void C_fcall f_4456(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4460)
static void C_ccall f_4460(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4468)
static void C_fcall f_4468(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4494)
static void C_ccall f_4494(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4498)
static void C_ccall f_4498(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4486)
static void C_ccall f_4486(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4430)
static void C_ccall f_4430(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4438)
static void C_ccall f_4438(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4413)
static void C_ccall f_4413(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4424)
static void C_ccall f_4424(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4428)
static void C_ccall f_4428(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4387)
static void C_ccall f_4387(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4411)
static void C_ccall f_4411(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4394)
static void C_ccall f_4394(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4344)
static void C_ccall f_4344(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4344)
static void C_ccall f_4344r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4351)
static void C_fcall f_4351(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4372)
static void C_ccall f_4372(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4368)
static void C_ccall f_4368(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4316)
static void C_ccall f_4316(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4294)
static void C_ccall f_4294(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4294)
static void C_ccall f_4294r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4298)
static void C_ccall f_4298(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4279)
static void C_ccall f_4279(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4279)
static void C_ccall f_4279r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4283)
static void C_ccall f_4283(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4264)
static void C_ccall f_4264(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_4264)
static void C_ccall f_4264r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_4268)
static void C_ccall f_4268(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4246)
static void C_fcall f_4246(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4172)
static void C_fcall f_4172(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4194)
static void C_ccall f_4194(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4200)
static void C_fcall f_4200(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4133)
static void C_ccall f_4133(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4161)
static void C_ccall f_4161(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4157)
static void C_ccall f_4157(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4150)
static void C_ccall f_4150(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3894)
static void C_ccall f_3894(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_3894)
static void C_ccall f_3894r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_4085)
static void C_fcall f_4085(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4074)
static void C_fcall f_4074(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4080)
static void C_ccall f_4080(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3896)
static void C_fcall f_3896(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4003)
static void C_ccall f_4003(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_4004)
static void C_ccall f_4004(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4021)
static void C_fcall f_4021(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_4031)
static void C_ccall f_4031(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3989)
static void C_ccall f_3989(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3945)
static void C_fcall f_3945(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3981)
static void C_ccall f_3981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3960)
static void C_ccall f_3960(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3970)
static void C_ccall f_3970(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3954)
static void C_ccall f_3954(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3949)
static void C_ccall f_3949(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3952)
static void C_ccall f_3952(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3899)
static void C_fcall f_3899(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3934)
static void C_ccall f_3934(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3915)
static void C_ccall f_3915(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3622)
static void C_ccall f_3622(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_3622)
static void C_ccall f_3622r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_3831)
static void C_fcall f_3831(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3820)
static void C_fcall f_3820(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3826)
static void C_ccall f_3826(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3815)
static void C_fcall f_3815(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3624)
static void C_fcall f_3624(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3631)
static void C_ccall f_3631(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3788)
static void C_ccall f_3788(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3792)
static void C_ccall f_3792(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3767)
static void C_ccall f_3767(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3777)
static void C_ccall f_3777(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3755)
static void C_ccall f_3755(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3742)
static void C_ccall f_3742(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3746)
static void C_ccall f_3746(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3737)
static void C_ccall f_3737(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3740)
static void C_ccall f_3740(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3655)
static void C_fcall f_3655(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3667)
static void C_fcall f_3667(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3704)
static void C_ccall f_3704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3713)
static void C_ccall f_3713(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3707)
static void C_ccall f_3707(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3683)
static void C_ccall f_3683(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3686)
static void C_ccall f_3686(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3647)
static C_word C_fcall f_3647(C_word t0);
C_noret_decl(f_3632)
static void C_fcall f_3632(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3646)
static void C_ccall f_3646(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3595)
static void C_ccall f_3595(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3595)
static void C_ccall f_3595r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3602)
static void C_fcall f_3602(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3605)
static void C_ccall f_3605(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3550)
static void C_ccall f_3550(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3554)
static void C_ccall f_3554(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3589)
static void C_ccall f_3589(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3572)
static void C_ccall f_3572(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3536)
static void C_ccall f_3536(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3536)
static void C_ccall f_3536r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3548)
static void C_ccall f_3548(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3522)
static void C_ccall f_3522(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_3522)
static void C_ccall f_3522r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_3534)
static void C_ccall f_3534(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3507)
static void C_fcall f_3507(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3520)
static void C_ccall f_3520(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3470)
static void C_fcall f_3470(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3478)
static void C_ccall f_3478(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3445)
static void C_ccall f_3445(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3426)
static void C_ccall f_3426(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3430)
static void C_ccall f_3430(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3395)
static void C_ccall f_3395(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3419)
static void C_ccall f_3419(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3403)
static void C_ccall f_3403(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3406)
static void C_ccall f_3406(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3357)
static void C_ccall f_3357(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3390)
static void C_ccall f_3390(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3378)
static void C_ccall f_3378(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3386)
static void C_ccall f_3386(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3382)
static void C_ccall f_3382(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3332)
static void C_ccall f_3332(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3348)
static void C_ccall f_3348(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3317)
static void C_ccall f_3317(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3327)
static void C_ccall f_3327(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3321)
static void C_ccall f_3321(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3311)
static void C_ccall f_3311(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3305)
static void C_ccall f_3305(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3299)
static void C_ccall f_3299(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3275)
static void C_fcall f_3275(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3297)
static void C_ccall f_3297(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3293)
static void C_ccall f_3293(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3285)
static void C_ccall f_3285(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3256)
static void C_ccall f_3256(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3266)
static void C_ccall f_3266(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3237)
static void C_ccall f_3237(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3247)
static void C_ccall f_3247(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3199)
static void C_ccall f_3199(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3227)
static void C_ccall f_3227(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3223)
static void C_ccall f_3223(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3172)
static void C_ccall f_3172(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3197)
static void C_ccall f_3197(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3193)
static void C_ccall f_3193(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3108)
static void C_ccall f_3108(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3096)
static void C_ccall f_3096(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3124)
static void C_ccall f_3124(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3034)
static void C_ccall f_3034(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3038)
static void C_ccall f_3038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3043)
static void C_fcall f_3043(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3059)
static void C_ccall f_3059(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2971)
static void C_ccall f_2971(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3029)
static void C_ccall f_3029(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2975)
static void C_ccall f_2975(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2978)
static void C_ccall f_2978(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_3010)
static void C_ccall f_3010(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2981)
static void C_ccall f_2981(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2986)
static void C_fcall f_2986(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2964)
static C_word C_fcall f_2964(C_word t0);
C_noret_decl(f_2903)
static void C_ccall f_2903(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2955)
static void C_ccall f_2955(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2907)
static void C_fcall f_2907(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2917)
static void C_ccall f_2917(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2921)
static void C_ccall f_2921(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2927)
static void C_fcall f_2927(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2931)
static void C_ccall f_2931(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2941)
static void C_ccall f_2941(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2925)
static void C_ccall f_2925(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2850)
static void C_ccall f_2850(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2890)
static void C_ccall f_2890(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2854)
static void C_fcall f_2854(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2864)
static void C_ccall f_2864(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2868)
static void C_ccall f_2868(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2872)
static void C_ccall f_2872(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2876)
static void C_ccall f_2876(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2880)
static void C_ccall f_2880(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2812)
static void C_ccall f_2812(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2845)
static void C_ccall f_2845(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2823)
static void C_ccall f_2823(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2827)
static void C_ccall f_2827(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2831)
static void C_ccall f_2831(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2835)
static void C_ccall f_2835(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2839)
static void C_ccall f_2839(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2794)
static void C_ccall f_2794(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2779)
static void C_ccall f_2779(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2773)
static void C_ccall f_2773(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2741)
static void C_ccall f_2741(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2747)
static void C_fcall f_2747(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2717)
static void C_ccall f_2717(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2735)
static void C_ccall f_2735(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2724)
static void C_ccall f_2724(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2699)
static void C_ccall f_2699(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2709)
static void C_ccall f_2709(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2686)
static void C_ccall f_2686(C_word c,C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2677)
static void C_ccall f_2677(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2630)
static void C_ccall f_2630(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2634)
static void C_ccall f_2634(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2610)
static void C_ccall f_2610(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2610)
static void C_ccall f_2610r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2614)
static void C_ccall f_2614(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2620)
static void C_ccall f_2620(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2620)
static void C_ccall f_2620r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2624)
static void C_ccall f_2624(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2590)
static void C_ccall f_2590(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2590)
static void C_ccall f_2590r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2594)
static void C_ccall f_2594(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2600)
static void C_ccall f_2600(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2600)
static void C_ccall f_2600r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2604)
static void C_ccall f_2604(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2566)
static void C_ccall f_2566(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2566)
static void C_ccall f_2566r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2570)
static void C_ccall f_2570(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2581)
static void C_ccall f_2581(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2581)
static void C_ccall f_2581r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2585)
static void C_ccall f_2585(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2575)
static void C_ccall f_2575(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2542)
static void C_ccall f_2542(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2542)
static void C_ccall f_2542r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2546)
static void C_ccall f_2546(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2557)
static void C_ccall f_2557r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2561)
static void C_ccall f_2561(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2551)
static void C_ccall f_2551(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2526)
static void C_ccall f_2526(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2530)
static void C_ccall f_2530(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2533)
static void C_ccall f_2533(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2490)
static void C_ccall f_2490(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2490)
static void C_ccall f_2490r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2521)
static void C_ccall f_2521(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2511)
static void C_ccall f_2511(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2504)
static void C_ccall f_2504(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2454)
static void C_ccall f_2454(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_2454)
static void C_ccall f_2454r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_2485)
static void C_ccall f_2485(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2475)
static void C_ccall f_2475(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2468)
static void C_ccall f_2468(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2439)
static void C_fcall f_2439(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2452)
static void C_ccall f_2452(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2433)
static void C_fcall f_2433(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2421)
static C_word C_fcall f_2421(C_word t0);
C_noret_decl(f_2378)
static void C_ccall f_2378(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2378)
static void C_ccall f_2378r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2382)
static void C_ccall f_2382(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2391)
static void C_ccall f_2391(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2355)
static void C_ccall f_2355(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2376)
static void C_ccall f_2376(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2362)
static void C_ccall f_2362(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2198)
static void C_ccall f_2198(C_word c,C_word t0,C_word t1,...) C_noret;
C_noret_decl(f_2198)
static void C_ccall f_2198r(C_word t0,C_word t1,C_word t3) C_noret;
C_noret_decl(f_2303)
static void C_fcall f_2303(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2311)
static void C_ccall f_2311(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2298)
static void C_fcall f_2298(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2200)
static void C_fcall f_2200(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2207)
static void C_ccall f_2207(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2210)
static void C_ccall f_2210(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2213)
static void C_ccall f_2213(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2297)
static void C_ccall f_2297(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2217)
static void C_ccall f_2217(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2231)
static void C_fcall f_2231(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2241)
static void C_ccall f_2241(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2253)
static void C_fcall f_2253(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2263)
static void C_ccall f_2263(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2174)
static void C_ccall f_2174(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2196)
static void C_ccall f_2196(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2192)
static void C_ccall f_2192(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2150)
static void C_ccall f_2150(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2172)
static void C_ccall f_2172(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2168)
static void C_ccall f_2168(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2126)
static void C_ccall f_2126(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2148)
static void C_ccall f_2148(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2144)
static void C_ccall f_2144(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2064)
static void C_ccall f_2064(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_2064)
static void C_ccall f_2064r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_2077)
static void C_ccall f_2077(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2089)
static void C_ccall f_2089(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2083)
static void C_ccall f_2083(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2055)
static void C_ccall f_2055(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2062)
static void C_ccall f_2062(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2046)
static void C_ccall f_2046(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2053)
static void C_ccall f_2053(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2040)
static void C_ccall f_2040(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2044)
static void C_ccall f_2044(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2034)
static void C_ccall f_2034(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2038)
static void C_ccall f_2038(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2028)
static void C_ccall f_2028(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2032)
static void C_ccall f_2032(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2022)
static void C_ccall f_2022(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2026)
static void C_ccall f_2026(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2016)
static void C_ccall f_2016(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2020)
static void C_ccall f_2020(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_2010)
static void C_ccall f_2010(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_2014)
static void C_ccall f_2014(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1978)
static void C_ccall f_1978(C_word c,C_word t0,C_word t1,C_word t2,...) C_noret;
C_noret_decl(f_1978)
static void C_ccall f_1978r(C_word t0,C_word t1,C_word t2,C_word t4) C_noret;
C_noret_decl(f_1989)
static void C_ccall f_1989(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1982)
static void C_ccall f_1982(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1941)
static void C_fcall f_1941(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1973)
static void C_ccall f_1973(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1966)
static void C_ccall f_1966(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1945)
static void C_ccall f_1945(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1749)
static void C_ccall f_1749(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1749)
static void C_ccall f_1749r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1922)
static void C_ccall f_1922(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1765)
static void C_ccall f_1765(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1896)
static void C_ccall f_1896(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1771)
static void C_ccall f_1771(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1774)
static void C_fcall f_1774(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1856)
static void C_ccall f_1856(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1854)
static void C_ccall f_1854(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1813)
static void C_fcall f_1813(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1831)
static void C_ccall f_1831(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1829)
static void C_ccall f_1829(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1817)
static void C_fcall f_1817(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1739)
static C_word C_fcall f_1739(C_word t0,C_word t1);
C_noret_decl(f_1729)
static C_word C_fcall f_1729(C_word t0,C_word t1);
C_noret_decl(f_1723)
static C_word C_fcall f_1723(C_word t0);
C_noret_decl(f_1691)
static void C_ccall f_1691(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1698)
static void C_ccall f_1698(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1704)
static void C_ccall f_1704(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1711)
static void C_ccall f_1711(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1652)
static void C_ccall f_1652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1652)
static void C_ccall f_1652r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1659)
static void C_ccall f_1659(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1668)
static void C_ccall f_1668(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1610)
static void C_ccall f_1610(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1610)
static void C_ccall f_1610r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1620)
static void C_ccall f_1620(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1623)
static void C_ccall f_1623(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1626)
static void C_ccall f_1626(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1595)
static void C_ccall f_1595(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1557)
static void C_ccall f_1557(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1557)
static void C_ccall f_1557r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1587)
static void C_ccall f_1587(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1574)
static void C_ccall f_1574(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1577)
static void C_ccall f_1577(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1511)
static void C_ccall f_1511(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...) C_noret;
C_noret_decl(f_1511)
static void C_ccall f_1511r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t5) C_noret;
C_noret_decl(f_1515)
static void C_ccall f_1515(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1454)
static void C_ccall f_1454(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1447)
static void C_ccall f_1447(C_word c,C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1429)
static void C_ccall f_1429(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...) C_noret;
C_noret_decl(f_1429)
static void C_ccall f_1429r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t6) C_noret;
C_noret_decl(f_1433)
static void C_ccall f_1433(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1444)
static void C_ccall f_1444(C_word c,C_word t0,C_word t1) C_noret;
C_noret_decl(f_1440)
static void C_ccall f_1440(C_word c,C_word t0,C_word t1) C_noret;

C_noret_decl(trf_6105)
static void C_fcall trf_6105(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6105(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_6105(t0,t1);}

C_noret_decl(trf_6100)
static void C_fcall trf_6100(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6100(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_6100(t0,t1,t2);}

C_noret_decl(trf_6095)
static void C_fcall trf_6095(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_6095(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_6095(t0,t1,t2,t3);}

C_noret_decl(trf_5950)
static void C_fcall trf_5950(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5950(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5950(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5957)
static void C_fcall trf_5957(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5957(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5957(t0,t1);}

C_noret_decl(trf_5969)
static void C_fcall trf_5969(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5969(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5969(t0,t1,t2,t3);}

C_noret_decl(trf_5900)
static void C_fcall trf_5900(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5900(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5900(t0,t1);}

C_noret_decl(trf_5895)
static void C_fcall trf_5895(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5895(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5895(t0,t1,t2);}

C_noret_decl(trf_5890)
static void C_fcall trf_5890(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5890(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5890(t0,t1,t2,t3);}

C_noret_decl(trf_5840)
static void C_fcall trf_5840(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5840(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5840(t0,t1);}

C_noret_decl(trf_5835)
static void C_fcall trf_5835(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5835(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5835(t0,t1,t2);}

C_noret_decl(trf_5830)
static void C_fcall trf_5830(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5830(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5830(t0,t1,t2,t3);}

C_noret_decl(trf_5763)
static void C_fcall trf_5763(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5763(void *dummy){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
f_5763(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_5696)
static void C_fcall trf_5696(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5696(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5696(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5685)
static void C_fcall trf_5685(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5685(void *dummy){
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
f_5685(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_5624)
static void C_fcall trf_5624(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5624(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_5624(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_5607)
static void C_fcall trf_5607(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5607(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_5607(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5590)
static void C_fcall trf_5590(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5590(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5590(t0,t1,t2,t3);}

C_noret_decl(trf_5570)
static void C_fcall trf_5570(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5570(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5570(t0,t1,t2);}

C_noret_decl(trf_5533)
static void C_fcall trf_5533(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5533(void *dummy){
C_word t7=C_pick(0);
C_word t6=C_pick(1);
C_word t5=C_pick(2);
C_word t4=C_pick(3);
C_word t3=C_pick(4);
C_word t2=C_pick(5);
C_word t1=C_pick(6);
C_word t0=C_pick(7);
C_adjust_stack(-8);
f_5533(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_5279)
static void C_fcall trf_5279(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5279(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5279(t0,t1);}

C_noret_decl(trf_5274)
static void C_fcall trf_5274(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5274(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5274(t0,t1,t2);}

C_noret_decl(trf_5150)
static void C_fcall trf_5150(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5150(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5150(t0,t1,t2,t3);}

C_noret_decl(trf_5168)
static void C_fcall trf_5168(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5168(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_5168(t0,t1,t2,t3);}

C_noret_decl(trf_5181)
static void C_fcall trf_5181(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5181(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_5181(t0,t1);}

C_noret_decl(trf_4968)
static void C_fcall trf_4968(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4968(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4968(t0,t1,t2);}

C_noret_decl(trf_5002)
static void C_fcall trf_5002(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_5002(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_5002(t0,t1,t2);}

C_noret_decl(trf_4456)
static void C_fcall trf_4456(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4456(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4456(t0,t1,t2);}

C_noret_decl(trf_4468)
static void C_fcall trf_4468(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4468(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4468(t0,t1,t2);}

C_noret_decl(trf_4351)
static void C_fcall trf_4351(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4351(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4351(t0,t1);}

C_noret_decl(trf_4246)
static void C_fcall trf_4246(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4246(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4246(t0,t1,t2,t3);}

C_noret_decl(trf_4172)
static void C_fcall trf_4172(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4172(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_4172(t0,t1,t2,t3);}

C_noret_decl(trf_4200)
static void C_fcall trf_4200(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4200(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4200(t0,t1);}

C_noret_decl(trf_4085)
static void C_fcall trf_4085(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4085(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_4085(t0,t1);}

C_noret_decl(trf_4074)
static void C_fcall trf_4074(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4074(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_4074(t0,t1,t2);}

C_noret_decl(trf_3896)
static void C_fcall trf_3896(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3896(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3896(t0,t1,t2,t3);}

C_noret_decl(trf_4021)
static void C_fcall trf_4021(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_4021(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_4021(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3945)
static void C_fcall trf_3945(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3945(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3945(t0,t1);}

C_noret_decl(trf_3899)
static void C_fcall trf_3899(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3899(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3899(t0,t1,t2,t3);}

C_noret_decl(trf_3831)
static void C_fcall trf_3831(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3831(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3831(t0,t1);}

C_noret_decl(trf_3820)
static void C_fcall trf_3820(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3820(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3820(t0,t1,t2);}

C_noret_decl(trf_3815)
static void C_fcall trf_3815(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3815(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3815(t0,t1,t2,t3);}

C_noret_decl(trf_3624)
static void C_fcall trf_3624(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3624(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3624(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3655)
static void C_fcall trf_3655(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3655(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3655(t0,t1);}

C_noret_decl(trf_3667)
static void C_fcall trf_3667(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3667(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3667(t0,t1);}

C_noret_decl(trf_3632)
static void C_fcall trf_3632(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3632(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3632(t0,t1);}

C_noret_decl(trf_3602)
static void C_fcall trf_3602(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3602(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_3602(t0,t1);}

C_noret_decl(trf_3507)
static void C_fcall trf_3507(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3507(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_3507(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3470)
static void C_fcall trf_3470(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3470(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_3470(t0,t1,t2);}

C_noret_decl(trf_3275)
static void C_fcall trf_3275(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3275(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3275(t0,t1,t2,t3);}

C_noret_decl(trf_3043)
static void C_fcall trf_3043(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_3043(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_3043(t0,t1,t2,t3);}

C_noret_decl(trf_2986)
static void C_fcall trf_2986(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2986(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2986(t0,t1,t2);}

C_noret_decl(trf_2907)
static void C_fcall trf_2907(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2907(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2907(t0,t1);}

C_noret_decl(trf_2927)
static void C_fcall trf_2927(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2927(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2927(t0,t1,t2);}

C_noret_decl(trf_2854)
static void C_fcall trf_2854(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2854(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2854(t0,t1);}

C_noret_decl(trf_2747)
static void C_fcall trf_2747(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2747(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2747(t0,t1,t2,t3);}

C_noret_decl(trf_2439)
static void C_fcall trf_2439(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2439(void *dummy){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
f_2439(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2433)
static void C_fcall trf_2433(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2433(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2433(t0,t1);}

C_noret_decl(trf_2303)
static void C_fcall trf_2303(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2303(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2303(t0,t1);}

C_noret_decl(trf_2298)
static void C_fcall trf_2298(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2298(void *dummy){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
f_2298(t0,t1,t2);}

C_noret_decl(trf_2200)
static void C_fcall trf_2200(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2200(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_2200(t0,t1,t2,t3);}

C_noret_decl(trf_2231)
static void C_fcall trf_2231(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2231(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2231(t0,t1);}

C_noret_decl(trf_2253)
static void C_fcall trf_2253(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_2253(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_2253(t0,t1);}

C_noret_decl(trf_1941)
static void C_fcall trf_1941(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1941(void *dummy){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
f_1941(t0,t1,t2,t3);}

C_noret_decl(trf_1774)
static void C_fcall trf_1774(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1774(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1774(t0,t1);}

C_noret_decl(trf_1813)
static void C_fcall trf_1813(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1813(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1813(t0,t1);}

C_noret_decl(trf_1817)
static void C_fcall trf_1817(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall trf_1817(void *dummy){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
f_1817(t0,t1);}

C_noret_decl(tr5)
static void C_fcall tr5(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5(C_proc5 k){
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
(k)(5,t0,t1,t2,t3,t4);}

C_noret_decl(tr9)
static void C_fcall tr9(C_proc9 k) C_regparm C_noret;
C_regparm static void C_fcall tr9(C_proc9 k){
C_word t8=C_pick(0);
C_word t7=C_pick(1);
C_word t6=C_pick(2);
C_word t5=C_pick(3);
C_word t4=C_pick(4);
C_word t3=C_pick(5);
C_word t2=C_pick(6);
C_word t1=C_pick(7);
C_word t0=C_pick(8);
C_adjust_stack(-9);
(k)(9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}

C_noret_decl(tr6)
static void C_fcall tr6(C_proc6 k) C_regparm C_noret;
C_regparm static void C_fcall tr6(C_proc6 k){
C_word t5=C_pick(0);
C_word t4=C_pick(1);
C_word t3=C_pick(2);
C_word t2=C_pick(3);
C_word t1=C_pick(4);
C_word t0=C_pick(5);
C_adjust_stack(-6);
(k)(6,t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr4)
static void C_fcall tr4(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4(C_proc4 k){
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
(k)(4,t0,t1,t2,t3);}

C_noret_decl(tr3)
static void C_fcall tr3(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3(C_proc3 k){
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
(k)(3,t0,t1,t2);}

C_noret_decl(tr2)
static void C_fcall tr2(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2(C_proc2 k){
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
(k)(2,t0,t1);}

C_noret_decl(tr5r)
static void C_fcall tr5r(C_proc5 k) C_regparm C_noret;
C_regparm static void C_fcall tr5r(C_proc5 k){
int n;
C_word *a,t5;
C_word t4=C_pick(0);
C_word t3=C_pick(1);
C_word t2=C_pick(2);
C_word t1=C_pick(3);
C_word t0=C_pick(4);
C_adjust_stack(-5);
n=C_rest_count(0);
a=C_alloc(n*3);
t5=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4,t5);}

C_noret_decl(tr2r)
static void C_fcall tr2r(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2r(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n*3);
t2=C_restore_rest(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3r)
static void C_fcall tr3r(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3r(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n*3);
t3=C_restore_rest(a,n);
(k)(t0,t1,t2,t3);}

C_noret_decl(tr4r)
static void C_fcall tr4r(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4r(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n*3);
t4=C_restore_rest(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr7rv)
static void C_fcall tr7rv(C_proc7 k) C_regparm C_noret;
C_regparm static void C_fcall tr7rv(C_proc7 k){
int n;
C_word *a,t7;
C_word t6=C_pick(0);
C_word t5=C_pick(1);
C_word t4=C_pick(2);
C_word t3=C_pick(3);
C_word t2=C_pick(4);
C_word t1=C_pick(5);
C_word t0=C_pick(6);
C_adjust_stack(-7);
n=C_rest_count(0);
a=C_alloc(n+1);
t7=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(tr4rv)
static void C_fcall tr4rv(C_proc4 k) C_regparm C_noret;
C_regparm static void C_fcall tr4rv(C_proc4 k){
int n;
C_word *a,t4;
C_word t3=C_pick(0);
C_word t2=C_pick(1);
C_word t1=C_pick(2);
C_word t0=C_pick(3);
C_adjust_stack(-4);
n=C_rest_count(0);
a=C_alloc(n+1);
t4=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3,t4);}

C_noret_decl(tr2rv)
static void C_fcall tr2rv(C_proc2 k) C_regparm C_noret;
C_regparm static void C_fcall tr2rv(C_proc2 k){
int n;
C_word *a,t2;
C_word t1=C_pick(0);
C_word t0=C_pick(1);
C_adjust_stack(-2);
n=C_rest_count(0);
a=C_alloc(n+1);
t2=C_restore_rest_vector(a,n);
(k)(t0,t1,t2);}

C_noret_decl(tr3rv)
static void C_fcall tr3rv(C_proc3 k) C_regparm C_noret;
C_regparm static void C_fcall tr3rv(C_proc3 k){
int n;
C_word *a,t3;
C_word t2=C_pick(0);
C_word t1=C_pick(1);
C_word t0=C_pick(2);
C_adjust_stack(-3);
n=C_rest_count(0);
a=C_alloc(n+1);
t3=C_restore_rest_vector(a,n);
(k)(t0,t1,t2,t3);}

/* toplevel */
static C_TLS int toplevel_initialized=0;
C_noret_decl(toplevel_trampoline)
static void C_fcall toplevel_trampoline(void *dummy) C_regparm C_noret;
C_regparm static void C_fcall toplevel_trampoline(void *dummy){
C_posix_toplevel(2,C_SCHEME_UNDEFINED,C_restore);}

void C_ccall C_posix_toplevel(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(toplevel_initialized) C_kontinue(t1,C_SCHEME_UNDEFINED);
else C_toplevel_entry(C_text("posix_toplevel"));
C_check_nursery_minimum(3);
if(!C_demand(3)){
C_save(t1);
C_reclaim((void*)toplevel_trampoline,NULL);}
toplevel_initialized=1;
if(!C_demand_2(3020)){
C_save(t1);
C_rereclaim2(3020*sizeof(C_word), 1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,639);
lf[1]=C_static_string(C_heaptop,27,"too many optional arguments");
lf[2]=C_h_intern(&lf[2],13,"string-append");
lf[4]=C_h_intern(&lf[4],15,"\003syssignal-hook");
lf[5]=C_static_string(C_heaptop,3," - ");
lf[6]=C_h_intern(&lf[6],17,"\003syspeek-c-string");
lf[7]=C_h_intern(&lf[7],16,"\003sysupdate-errno");
lf[8]=C_static_lambda_info(C_heaptop,38,"(posix-error type7 loc8 msg9 . args10)");
lf[9]=C_h_intern(&lf[9],15,"\003sysposix-error");
lf[10]=C_h_intern(&lf[10],21,"\003sysfile-nonblocking!");
lf[11]=C_static_lambda_info(C_heaptop,31,"(##sys#file-nonblocking! a1215)");
lf[12]=C_h_intern(&lf[12],19,"\003sysfile-select-one");
lf[13]=C_static_lambda_info(C_heaptop,29,"(##sys#file-select-one a1619)");
lf[14]=C_h_intern(&lf[14],8,"pipe/buf");
lf[15]=C_h_intern(&lf[15],11,"fcntl/dupfd");
lf[16]=C_h_intern(&lf[16],11,"fcntl/getfd");
lf[17]=C_h_intern(&lf[17],11,"fcntl/setfd");
lf[18]=C_h_intern(&lf[18],11,"fcntl/getfl");
lf[19]=C_h_intern(&lf[19],11,"fcntl/setfl");
lf[20]=C_h_intern(&lf[20],11,"open/rdonly");
lf[21]=C_h_intern(&lf[21],11,"open/wronly");
lf[22]=C_h_intern(&lf[22],9,"open/rdwr");
lf[23]=C_h_intern(&lf[23],9,"open/read");
lf[24]=C_h_intern(&lf[24],10,"open/write");
lf[25]=C_h_intern(&lf[25],10,"open/creat");
lf[26]=C_h_intern(&lf[26],11,"open/append");
lf[27]=C_h_intern(&lf[27],9,"open/excl");
lf[28]=C_h_intern(&lf[28],11,"open/noctty");
lf[29]=C_h_intern(&lf[29],13,"open/nonblock");
lf[30]=C_h_intern(&lf[30],10,"open/trunc");
lf[31]=C_h_intern(&lf[31],9,"open/sync");
lf[32]=C_h_intern(&lf[32],10,"open/fsync");
lf[33]=C_h_intern(&lf[33],11,"open/binary");
lf[34]=C_h_intern(&lf[34],9,"open/text");
lf[35]=C_h_intern(&lf[35],10,"perm/irusr");
lf[36]=C_h_intern(&lf[36],10,"perm/iwusr");
lf[37]=C_h_intern(&lf[37],10,"perm/ixusr");
lf[38]=C_h_intern(&lf[38],10,"perm/irgrp");
lf[39]=C_h_intern(&lf[39],10,"perm/iwgrp");
lf[40]=C_h_intern(&lf[40],10,"perm/ixgrp");
lf[41]=C_h_intern(&lf[41],10,"perm/iroth");
lf[42]=C_h_intern(&lf[42],10,"perm/iwoth");
lf[43]=C_h_intern(&lf[43],10,"perm/ixoth");
lf[44]=C_h_intern(&lf[44],10,"perm/irwxu");
lf[45]=C_h_intern(&lf[45],10,"perm/irwxg");
lf[46]=C_h_intern(&lf[46],10,"perm/irwxo");
lf[47]=C_h_intern(&lf[47],10,"perm/isvtx");
lf[48]=C_h_intern(&lf[48],10,"perm/isuid");
lf[49]=C_h_intern(&lf[49],10,"perm/isgid");
lf[50]=C_h_intern(&lf[50],12,"file-control");
lf[51]=C_h_intern(&lf[51],11,"\000file-error");
lf[52]=C_static_string(C_heaptop,19,"cannot control file");
lf[53]=C_h_intern(&lf[53],9,"\003syserror");
lf[54]=C_static_lambda_info(C_heaptop,33,"(file-control fd30 cmd31 . g2932)");
lf[55]=C_h_intern(&lf[55],9,"file-open");
lf[56]=C_static_string(C_heaptop,16,"cannot open file");
lf[57]=C_h_intern(&lf[57],17,"\003sysmake-c-string");
lf[58]=C_h_intern(&lf[58],20,"\003sysexpand-home-path");
lf[59]=C_static_lambda_info(C_heaptop,39,"(file-open filename41 flags42 . mode43)");
lf[60]=C_h_intern(&lf[60],10,"file-close");
lf[61]=C_static_string(C_heaptop,17,"cannot close file");
lf[62]=C_static_lambda_info(C_heaptop,17,"(file-close fd50)");
lf[63]=C_h_intern(&lf[63],11,"make-string");
lf[64]=C_h_intern(&lf[64],9,"file-read");
lf[65]=C_static_string(C_heaptop,21,"cannot read from file");
lf[66]=C_h_intern(&lf[66],11,"\000type-error");
lf[67]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[68]=C_static_lambda_info(C_heaptop,34,"(file-read fd53 size54 . buffer55)");
lf[69]=C_h_intern(&lf[69],10,"file-write");
lf[70]=C_static_string(C_heaptop,20,"cannot write to file");
lf[71]=C_static_string(C_heaptop,47,"bad argument type - not a string or byte-vector");
lf[72]=C_static_lambda_info(C_heaptop,35,"(file-write fd62 buffer63 . size64)");
lf[73]=C_h_intern(&lf[73],12,"file-mkstemp");
lf[74]=C_h_intern(&lf[74],13,"\003syssubstring");
lf[75]=C_static_string(C_heaptop,28,"cannot create temporary file");
lf[76]=C_static_lambda_info(C_heaptop,25,"(file-mkstemp template71)");
lf[77]=C_static_lambda_info(C_heaptop,9,"(fd_zero)");
lf[78]=C_static_lambda_info(C_heaptop,14,"(fd_set a8489)");
lf[79]=C_static_lambda_info(C_heaptop,15,"(fd_test a9095)");
lf[80]=C_h_intern(&lf[80],11,"file-select");
lf[81]=C_static_string(C_heaptop,6,"failed");
lf[82]=C_static_lambda_info(C_heaptop,13,"(a1830 fd121)");
lf[83]=C_h_intern(&lf[83],12,"\003sysfor-each");
lf[84]=C_static_lambda_info(C_heaptop,13,"(a1855 fd118)");
lf[85]=C_static_lambda_info(C_heaptop,13,"(a1895 fd111)");
lf[86]=C_static_lambda_info(C_heaptop,13,"(a1921 fd104)");
lf[87]=C_static_lambda_info(C_heaptop,39,"(file-select fdsr96 fdsw97 . timeout98)");
lf[88]=C_h_intern(&lf[88],8,"seek/set");
lf[89]=C_h_intern(&lf[89],8,"seek/end");
lf[90]=C_h_intern(&lf[90],8,"seek/cur");
lf[92]=C_static_string(C_heaptop,18,"cannot access file");
lf[93]=C_static_string(C_heaptop,42,"bad argument type - not a fixnum or string");
lf[94]=C_static_lambda_info(C_heaptop,35,"(##sys#stat file127 link128 loc129)");
lf[95]=C_h_intern(&lf[95],9,"file-stat");
lf[96]=C_static_lambda_info(C_heaptop,26,"(file-stat f132 . link133)");
lf[97]=C_h_intern(&lf[97],9,"file-size");
lf[98]=C_static_lambda_info(C_heaptop,16,"(file-size f137)");
lf[99]=C_h_intern(&lf[99],22,"file-modification-time");
lf[100]=C_static_lambda_info(C_heaptop,29,"(file-modification-time f139)");
lf[101]=C_h_intern(&lf[101],16,"file-access-time");
lf[102]=C_static_lambda_info(C_heaptop,23,"(file-access-time f141)");
lf[103]=C_h_intern(&lf[103],16,"file-change-time");
lf[104]=C_static_lambda_info(C_heaptop,23,"(file-change-time f143)");
lf[105]=C_h_intern(&lf[105],10,"file-owner");
lf[106]=C_static_lambda_info(C_heaptop,17,"(file-owner f145)");
lf[107]=C_h_intern(&lf[107],16,"file-permissions");
lf[108]=C_static_lambda_info(C_heaptop,23,"(file-permissions f147)");
lf[109]=C_h_intern(&lf[109],13,"regular-file\077");
lf[110]=C_static_lambda_info(C_heaptop,24,"(regular-file\077 fname149)");
lf[111]=C_h_intern(&lf[111],14,"symbolic-link\077");
lf[112]=C_static_lambda_info(C_heaptop,25,"(symbolic-link\077 fname153)");
lf[113]=C_h_intern(&lf[113],18,"set-file-position!");
lf[114]=C_static_string(C_heaptop,24,"cannot set file position");
lf[115]=C_h_intern(&lf[115],6,"stream");
lf[116]=C_static_string(C_heaptop,12,"invalid file");
lf[117]=C_h_intern(&lf[117],5,"port\077");
lf[118]=C_h_intern(&lf[118],13,"\000bounds-error");
lf[119]=C_static_string(C_heaptop,30,"invalid negative port position");
lf[120]=C_static_lambda_info(C_heaptop,47,"(set-file-position! port157 pos158 . whence159)");
lf[121]=C_h_intern(&lf[121],13,"file-position");
lf[122]=C_h_intern(&lf[122],16,"create-directory");
lf[123]=C_static_string(C_heaptop,23,"cannot create directory");
lf[124]=C_static_lambda_info(C_heaptop,26,"(create-directory name167)");
lf[125]=C_h_intern(&lf[125],16,"change-directory");
lf[126]=C_static_string(C_heaptop,31,"cannot change current directory");
lf[127]=C_static_lambda_info(C_heaptop,26,"(change-directory name169)");
lf[128]=C_h_intern(&lf[128],16,"delete-directory");
lf[129]=C_static_string(C_heaptop,23,"cannot delete directory");
lf[130]=C_static_lambda_info(C_heaptop,26,"(delete-directory name171)");
lf[131]=C_h_intern(&lf[131],6,"string");
lf[132]=C_h_intern(&lf[132],9,"directory");
lf[133]=C_static_string(C_heaptop,21,"cannot open directory");
lf[134]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[135]=C_h_intern(&lf[135],16,"\003sysmake-pointer");
lf[136]=C_static_lambda_info(C_heaptop,35,"(body180 spec186 show-dotfiles\077187)");
lf[137]=C_static_lambda_info(C_heaptop,35,"(def-show-dotfiles\077183 %spec178206)");
lf[138]=C_h_intern(&lf[138],17,"current-directory");
lf[139]=C_static_lambda_info(C_heaptop,13,"(def-spec182)");
lf[140]=C_static_lambda_info(C_heaptop,21,"(directory . g176177)");
lf[141]=C_h_intern(&lf[141],10,"directory\077");
lf[142]=C_h_intern(&lf[142],13,"\003sysfile-info");
lf[143]=C_static_lambda_info(C_heaptop,21,"(directory\077 fname212)");
lf[144]=C_static_string(C_heaptop,33,"cannot retrieve current directory");
lf[145]=C_static_lambda_info(C_heaptop,29,"(current-directory . g216217)");
lf[146]=C_h_intern(&lf[146],5,"\000text");
lf[147]=C_static_lambda_info(C_heaptop,6,"(mode)");
lf[148]=C_static_string(C_heaptop,35,"illegal input/output mode specifier");
lf[149]=C_static_lambda_info(C_heaptop,14,"(badmode m227)");
lf[150]=C_static_string(C_heaptop,16,"cannot open pipe");
lf[151]=C_h_intern(&lf[151],13,"\003sysmake-port");
lf[152]=C_h_intern(&lf[152],21,"\003sysstream-port-class");
lf[153]=C_static_string(C_heaptop,6,"(pipe)");
lf[154]=C_static_lambda_info(C_heaptop,33,"(check loc228 cmd229 inp230 r231)");
lf[155]=C_h_intern(&lf[155],15,"open-input-pipe");
lf[156]=C_h_intern(&lf[156],7,"\000binary");
lf[157]=C_static_lambda_info(C_heaptop,31,"(open-input-pipe cmd234 . m235)");
lf[158]=C_h_intern(&lf[158],16,"open-output-pipe");
lf[159]=C_static_lambda_info(C_heaptop,32,"(open-output-pipe cmd240 . m241)");
lf[160]=C_h_intern(&lf[160],16,"close-input-pipe");
lf[161]=C_h_intern(&lf[161],23,"close-input/output-pipe");
lf[162]=C_static_string(C_heaptop,24,"error while closing pipe");
lf[163]=C_h_intern(&lf[163],14,"\003syscheck-port");
lf[164]=C_static_lambda_info(C_heaptop,26,"(close-input-pipe port246)");
lf[165]=C_h_intern(&lf[165],17,"close-output-pipe");
lf[166]=C_h_intern(&lf[166],20,"call-with-input-pipe");
lf[167]=C_static_lambda_info(C_heaptop,7,"(a2550)");
lf[168]=C_static_lambda_info(C_heaptop,20,"(a2556 . results264)");
lf[169]=C_static_lambda_info(C_heaptop,47,"(call-with-input-pipe cmd260 proc261 . mode262)");
lf[170]=C_h_intern(&lf[170],21,"call-with-output-pipe");
lf[171]=C_static_lambda_info(C_heaptop,7,"(a2574)");
lf[172]=C_static_lambda_info(C_heaptop,20,"(a2580 . results270)");
lf[173]=C_static_lambda_info(C_heaptop,48,"(call-with-output-pipe cmd266 proc267 . mode268)");
lf[174]=C_h_intern(&lf[174],20,"with-input-from-pipe");
lf[175]=C_h_intern(&lf[175],18,"\003sysstandard-input");
lf[176]=C_static_lambda_info(C_heaptop,20,"(a2599 . results277)");
lf[177]=C_static_lambda_info(C_heaptop,48,"(with-input-from-pipe cmd272 thunk273 . mode274)");
lf[178]=C_h_intern(&lf[178],19,"with-output-to-pipe");
lf[179]=C_h_intern(&lf[179],19,"\003sysstandard-output");
lf[180]=C_static_lambda_info(C_heaptop,20,"(a2619 . results286)");
lf[181]=C_static_lambda_info(C_heaptop,47,"(with-output-to-pipe cmd281 thunk282 . mode283)");
lf[182]=C_h_intern(&lf[182],11,"create-pipe");
lf[183]=C_static_string(C_heaptop,18,"cannot create pipe");
lf[184]=C_static_lambda_info(C_heaptop,13,"(create-pipe)");
lf[185]=C_h_intern(&lf[185],11,"signal/term");
lf[186]=C_h_intern(&lf[186],11,"signal/kill");
lf[187]=C_h_intern(&lf[187],10,"signal/int");
lf[188]=C_h_intern(&lf[188],10,"signal/hup");
lf[189]=C_h_intern(&lf[189],10,"signal/fpe");
lf[190]=C_h_intern(&lf[190],10,"signal/ill");
lf[191]=C_h_intern(&lf[191],11,"signal/segv");
lf[192]=C_h_intern(&lf[192],11,"signal/abrt");
lf[193]=C_h_intern(&lf[193],11,"signal/trap");
lf[194]=C_h_intern(&lf[194],11,"signal/quit");
lf[195]=C_h_intern(&lf[195],11,"signal/alrm");
lf[196]=C_h_intern(&lf[196],13,"signal/vtalrm");
lf[197]=C_h_intern(&lf[197],11,"signal/prof");
lf[198]=C_h_intern(&lf[198],9,"signal/io");
lf[199]=C_h_intern(&lf[199],10,"signal/urg");
lf[200]=C_h_intern(&lf[200],11,"signal/chld");
lf[201]=C_h_intern(&lf[201],11,"signal/cont");
lf[202]=C_h_intern(&lf[202],11,"signal/stop");
lf[203]=C_h_intern(&lf[203],11,"signal/tstp");
lf[204]=C_h_intern(&lf[204],11,"signal/pipe");
lf[205]=C_h_intern(&lf[205],11,"signal/xcpu");
lf[206]=C_h_intern(&lf[206],11,"signal/xfsz");
lf[207]=C_h_intern(&lf[207],11,"signal/usr1");
lf[208]=C_h_intern(&lf[208],11,"signal/usr2");
lf[209]=C_h_intern(&lf[209],12,"signal/winch");
lf[210]=C_h_intern(&lf[210],12,"signals-list");
lf[211]=C_h_intern(&lf[211],18,"\003sysinterrupt-hook");
lf[212]=C_h_intern(&lf[212],14,"signal-handler");
lf[213]=C_static_lambda_info(C_heaptop,23,"(signal-handler sig298)");
lf[214]=C_h_intern(&lf[214],19,"set-signal-handler!");
lf[215]=C_static_lambda_info(C_heaptop,36,"(set-signal-handler! sig300 proc301)");
lf[216]=C_static_lambda_info(C_heaptop,41,"(##sys#interrupt-hook reason304 state305)");
lf[217]=C_h_intern(&lf[217],16,"set-signal-mask!");
lf[218]=C_h_intern(&lf[218],14,"\000process-error");
lf[219]=C_static_string(C_heaptop,22,"cannot set signal mask");
lf[220]=C_static_lambda_info(C_heaptop,12,"(a2734 s311)");
lf[221]=C_static_lambda_info(C_heaptop,26,"(set-signal-mask! sigs310)");
lf[222]=C_h_intern(&lf[222],11,"signal-mask");
lf[223]=C_static_lambda_info(C_heaptop,22,"(loop sigs317 mask318)");
lf[224]=C_static_lambda_info(C_heaptop,13,"(signal-mask)");
lf[225]=C_h_intern(&lf[225],14,"signal-masked\077");
lf[226]=C_static_lambda_info(C_heaptop,23,"(signal-masked\077 sig321)");
lf[227]=C_h_intern(&lf[227],12,"signal-mask!");
lf[228]=C_static_string(C_heaptop,19,"cannot block signal");
lf[229]=C_static_lambda_info(C_heaptop,21,"(signal-mask! sig323)");
lf[230]=C_h_intern(&lf[230],14,"signal-unmask!");
lf[231]=C_static_string(C_heaptop,21,"cannot unblock signal");
lf[232]=C_static_lambda_info(C_heaptop,23,"(signal-unmask! sig326)");
lf[233]=C_h_intern(&lf[233],18,"system-information");
lf[234]=C_h_intern(&lf[234],25,"\003syspeek-nonnull-c-string");
lf[235]=C_static_string(C_heaptop,34,"cannot retrieve system information");
lf[236]=C_static_lambda_info(C_heaptop,20,"(system-information)");
lf[237]=C_h_intern(&lf[237],16,"user-information");
lf[238]=C_static_lambda_info(C_heaptop,26,"(user-information user332)");
lf[239]=C_h_intern(&lf[239],17,"group-information");
lf[240]=C_static_lambda_info(C_heaptop,10,"(rec i344)");
lf[241]=C_static_lambda_info(C_heaptop,28,"(group-information group340)");
lf[243]=C_static_lambda_info(C_heaptop,16,"(_ensure-groups)");
lf[244]=C_h_intern(&lf[244],10,"get-groups");
lf[245]=C_static_lambda_info(C_heaptop,11,"(loop i360)");
lf[246]=C_static_string(C_heaptop,39,"cannot retrieve supplementary group ids");
lf[247]=C_static_string(C_heaptop,13,"out of memory");
lf[248]=C_static_string(C_heaptop,39,"cannot retrieve supplementary group ids");
lf[249]=C_static_lambda_info(C_heaptop,12,"(get-groups)");
lf[250]=C_h_intern(&lf[250],11,"set-groups!");
lf[251]=C_static_string(C_heaptop,34,"cannot set supplementary group ids");
lf[252]=C_static_lambda_info(C_heaptop,19,"(do366 lst368 i369)");
lf[253]=C_static_string(C_heaptop,13,"out of memory");
lf[254]=C_static_lambda_info(C_heaptop,21,"(set-groups! lst0365)");
lf[255]=C_h_intern(&lf[255],17,"initialize-groups");
lf[256]=C_static_string(C_heaptop,41,"cannot initialize supplementary group ids");
lf[257]=C_static_lambda_info(C_heaptop,33,"(initialize-groups user385 id386)");
lf[258]=C_h_intern(&lf[258],10,"errno/perm");
lf[259]=C_h_intern(&lf[259],11,"errno/noent");
lf[260]=C_h_intern(&lf[260],10,"errno/srch");
lf[261]=C_h_intern(&lf[261],10,"errno/intr");
lf[262]=C_h_intern(&lf[262],8,"errno/io");
lf[263]=C_h_intern(&lf[263],12,"errno/noexec");
lf[264]=C_h_intern(&lf[264],10,"errno/badf");
lf[265]=C_h_intern(&lf[265],11,"errno/child");
lf[266]=C_h_intern(&lf[266],11,"errno/nomem");
lf[267]=C_h_intern(&lf[267],11,"errno/acces");
lf[268]=C_h_intern(&lf[268],11,"errno/fault");
lf[269]=C_h_intern(&lf[269],10,"errno/busy");
lf[270]=C_h_intern(&lf[270],12,"errno/notdir");
lf[271]=C_h_intern(&lf[271],11,"errno/isdir");
lf[272]=C_h_intern(&lf[272],11,"errno/inval");
lf[273]=C_h_intern(&lf[273],11,"errno/mfile");
lf[274]=C_h_intern(&lf[274],11,"errno/nospc");
lf[275]=C_h_intern(&lf[275],11,"errno/spipe");
lf[276]=C_h_intern(&lf[276],10,"errno/pipe");
lf[277]=C_h_intern(&lf[277],11,"errno/again");
lf[278]=C_h_intern(&lf[278],10,"errno/rofs");
lf[279]=C_h_intern(&lf[279],11,"errno/exist");
lf[280]=C_h_intern(&lf[280],16,"errno/wouldblock");
lf[281]=C_h_intern(&lf[281],10,"errno/2big");
lf[282]=C_h_intern(&lf[282],12,"errno/deadlk");
lf[283]=C_h_intern(&lf[283],9,"errno/dom");
lf[284]=C_h_intern(&lf[284],10,"errno/fbig");
lf[285]=C_h_intern(&lf[285],11,"errno/ilseq");
lf[286]=C_h_intern(&lf[286],11,"errno/mlink");
lf[287]=C_h_intern(&lf[287],17,"errno/nametoolong");
lf[288]=C_h_intern(&lf[288],11,"errno/nfile");
lf[289]=C_h_intern(&lf[289],11,"errno/nodev");
lf[290]=C_h_intern(&lf[290],11,"errno/nolck");
lf[291]=C_h_intern(&lf[291],11,"errno/nosys");
lf[292]=C_h_intern(&lf[292],14,"errno/notempty");
lf[293]=C_h_intern(&lf[293],11,"errno/notty");
lf[294]=C_h_intern(&lf[294],10,"errno/nxio");
lf[295]=C_h_intern(&lf[295],11,"errno/range");
lf[296]=C_h_intern(&lf[296],10,"errno/xdev");
lf[297]=C_h_intern(&lf[297],16,"change-file-mode");
lf[298]=C_static_string(C_heaptop,23,"cannot change file mode");
lf[299]=C_static_lambda_info(C_heaptop,32,"(change-file-mode fname398 m399)");
lf[300]=C_h_intern(&lf[300],17,"change-file-owner");
lf[301]=C_static_string(C_heaptop,24,"cannot change file owner");
lf[302]=C_static_lambda_info(C_heaptop,39,"(change-file-owner fn402 uid403 gid404)");
lf[303]=C_h_intern(&lf[303],25,"current-effective-user-id");
lf[304]=C_h_intern(&lf[304],26,"current-effective-group-id");
lf[305]=C_h_intern(&lf[305],12,"set-user-id!");
lf[306]=C_static_string(C_heaptop,18,"cannot set user ID");
lf[307]=C_static_lambda_info(C_heaptop,20,"(set-user-id! id416)");
lf[308]=C_h_intern(&lf[308],15,"current-user-id");
lf[309]=C_h_intern(&lf[309],13,"set-group-id!");
lf[310]=C_static_string(C_heaptop,19,"cannot set group ID");
lf[311]=C_static_lambda_info(C_heaptop,21,"(set-group-id! id420)");
lf[312]=C_h_intern(&lf[312],16,"current-group-id");
lf[313]=C_static_lambda_info(C_heaptop,33,"(check filename425 acc426 loc427)");
lf[314]=C_h_intern(&lf[314],17,"file-read-access\077");
lf[315]=C_static_lambda_info(C_heaptop,31,"(file-read-access\077 filename431)");
lf[316]=C_h_intern(&lf[316],18,"file-write-access\077");
lf[317]=C_static_lambda_info(C_heaptop,32,"(file-write-access\077 filename432)");
lf[318]=C_h_intern(&lf[318],20,"file-execute-access\077");
lf[319]=C_static_lambda_info(C_heaptop,34,"(file-execute-access\077 filename433)");
lf[320]=C_h_intern(&lf[320],14,"create-session");
lf[321]=C_static_string(C_heaptop,21,"cannot create session");
lf[322]=C_static_lambda_info(C_heaptop,16,"(create-session)");
lf[323]=C_h_intern(&lf[323],21,"set-process-group-id!");
lf[324]=C_static_string(C_heaptop,27,"cannot set process group ID");
lf[325]=C_static_lambda_info(C_heaptop,38,"(set-process-group-id! pid440 pgid441)");
lf[326]=C_h_intern(&lf[326],16,"process-group-id");
lf[327]=C_h_intern(&lf[327],20,"create-symbolic-link");
lf[328]=C_h_intern(&lf[328],18,"create-symbol-link");
lf[329]=C_static_string(C_heaptop,27,"cannot create symbolic link");
lf[330]=C_static_lambda_info(C_heaptop,36,"(create-symbolic-link old450 new451)");
lf[331]=C_h_intern(&lf[331],9,"substring");
lf[332]=C_h_intern(&lf[332],18,"read-symbolic-link");
lf[333]=C_static_string(C_heaptop,25,"cannot read symbolic link");
lf[334]=C_static_lambda_info(C_heaptop,29,"(read-symbolic-link fname456)");
lf[335]=C_h_intern(&lf[335],9,"file-link");
lf[336]=C_h_intern(&lf[336],9,"hard-link");
lf[337]=C_static_string(C_heaptop,26,"could not create hard link");
lf[338]=C_static_lambda_info(C_heaptop,25,"(file-link old471 new472)");
lf[339]=C_h_intern(&lf[339],12,"fileno/stdin");
lf[340]=C_h_intern(&lf[340],13,"fileno/stdout");
lf[341]=C_h_intern(&lf[341],13,"fileno/stderr");
lf[342]=C_h_intern(&lf[342],7,"\000append");
lf[343]=C_static_string(C_heaptop,27,"invalid mode for input file");
lf[344]=C_static_string(C_heaptop,1,"a");
lf[345]=C_static_string(C_heaptop,21,"invalid mode argument");
lf[346]=C_static_string(C_heaptop,1,"r");
lf[347]=C_static_string(C_heaptop,1,"w");
lf[348]=C_static_lambda_info(C_heaptop,18,"(mode inp491 m492)");
lf[349]=C_static_string(C_heaptop,16,"cannot open file");
lf[350]=C_static_string(C_heaptop,8,"(fdport)");
lf[351]=C_static_lambda_info(C_heaptop,32,"(check loc496 fd497 inp498 r499)");
lf[352]=C_h_intern(&lf[352],16,"open-input-file*");
lf[353]=C_static_lambda_info(C_heaptop,31,"(open-input-file* fd502 . m503)");
lf[354]=C_h_intern(&lf[354],17,"open-output-file*");
lf[355]=C_static_lambda_info(C_heaptop,32,"(open-output-file* fd505 . m506)");
lf[356]=C_h_intern(&lf[356],12,"port->fileno");
lf[357]=C_h_intern(&lf[357],6,"socket");
lf[358]=C_h_intern(&lf[358],20,"\003systcp-port->fileno");
lf[359]=C_static_string(C_heaptop,25,"port has no attached file");
lf[360]=C_static_string(C_heaptop,37,"cannot access file-descriptor of port");
lf[361]=C_h_intern(&lf[361],25,"\003syspeek-unsigned-integer");
lf[362]=C_static_lambda_info(C_heaptop,22,"(port->fileno port511)");
lf[363]=C_h_intern(&lf[363],16,"duplicate-fileno");
lf[364]=C_static_string(C_heaptop,32,"cannot duplicate file-descriptor");
lf[365]=C_static_lambda_info(C_heaptop,34,"(duplicate-fileno old515 . new516)");
lf[366]=C_h_intern(&lf[366],15,"make-input-port");
lf[367]=C_h_intern(&lf[367],14,"set-port-name!");
lf[368]=C_h_intern(&lf[368],21,"\003syscustom-input-port");
lf[369]=C_static_string(C_heaptop,13,"cannot select");
lf[370]=C_static_lambda_info(C_heaptop,8,"(ready\077)");
lf[371]=C_h_intern(&lf[371],17,"\003systhread-yield!");
lf[372]=C_h_intern(&lf[372],25,"\003systhread-block-for-i/o!");
lf[373]=C_h_intern(&lf[373],18,"\003syscurrent-thread");
lf[374]=C_static_string(C_heaptop,11,"cannot read");
lf[375]=C_static_string(C_heaptop,11,"cannot read");
lf[376]=C_static_lambda_info(C_heaptop,6,"(loop)");
lf[377]=C_static_lambda_info(C_heaptop,7,"(fetch)");
lf[378]=C_static_lambda_info(C_heaptop,7,"(a3741)");
lf[379]=C_static_lambda_info(C_heaptop,7,"(a3754)");
lf[380]=C_static_string(C_heaptop,12,"cannot close");
lf[381]=C_static_lambda_info(C_heaptop,7,"(a3766)");
lf[382]=C_static_lambda_info(C_heaptop,7,"(a3787)");
lf[383]=C_h_intern(&lf[383],15,"\003sysmake-string");
lf[384]=C_static_lambda_info(C_heaptop,38,"(body532 bufi539 on-close540 more\077541)");
lf[385]=C_static_lambda_info(C_heaptop,42,"(def-more\077536 %bufi529570 %on-close530571)");
lf[386]=C_h_intern(&lf[386],19,"\003sysundefined-value");
lf[387]=C_static_lambda_info(C_heaptop,7,"(a3825)");
lf[388]=C_static_lambda_info(C_heaptop,29,"(def-on-close535 %bufi529573)");
lf[389]=C_static_lambda_info(C_heaptop,13,"(def-bufi534)");
lf[390]=C_static_lambda_info(C_heaptop,55,"(##sys#custom-input-port loc525 nam526 fd527 . g524528)");
lf[391]=C_h_intern(&lf[391],16,"make-output-port");
lf[392]=C_h_intern(&lf[392],22,"\003syscustom-output-port");
lf[393]=C_static_string(C_heaptop,12,"cannot write");
lf[394]=C_static_lambda_info(C_heaptop,18,"(poke s600 len601)");
lf[395]=C_static_lambda_info(C_heaptop,12,"(a3953 s619)");
lf[396]=C_static_string(C_heaptop,12,"cannot close");
lf[397]=C_static_lambda_info(C_heaptop,7,"(a3959)");
lf[398]=C_static_lambda_info(C_heaptop,7,"(a3980)");
lf[399]=C_static_lambda_info(C_heaptop,13,"(f_3989 s605)");
lf[400]=C_static_lambda_info(C_heaptop,29,"(loop rem610 start611 len612)");
lf[401]=C_static_lambda_info(C_heaptop,13,"(f_4004 s608)");
lf[402]=C_static_lambda_info(C_heaptop,29,"(body590 bufi596 on-close597)");
lf[403]=C_static_lambda_info(C_heaptop,7,"(a4079)");
lf[404]=C_static_lambda_info(C_heaptop,29,"(def-on-close593 %bufi588626)");
lf[405]=C_static_lambda_info(C_heaptop,13,"(def-bufi592)");
lf[406]=C_static_lambda_info(C_heaptop,56,"(##sys#custom-output-port loc584 nam585 fd586 . g583587)");
lf[407]=C_h_intern(&lf[407],13,"file-truncate");
lf[408]=C_static_string(C_heaptop,20,"cannot truncate file");
lf[409]=C_static_string(C_heaptop,12,"invalid file");
lf[410]=C_static_lambda_info(C_heaptop,31,"(file-truncate fname632 off633)");
lf[411]=C_h_intern(&lf[411],4,"lock");
lf[412]=C_static_lambda_info(C_heaptop,30,"(setup port637 args638 loc639)");
lf[413]=C_static_lambda_info(C_heaptop,27,"(err msg652 lock653 loc654)");
lf[414]=C_h_intern(&lf[414],9,"file-lock");
lf[415]=C_static_string(C_heaptop,16,"cannot lock file");
lf[416]=C_static_lambda_info(C_heaptop,29,"(file-lock port655 . args656)");
lf[417]=C_h_intern(&lf[417],18,"file-lock/blocking");
lf[418]=C_static_string(C_heaptop,16,"cannot lock file");
lf[419]=C_static_lambda_info(C_heaptop,38,"(file-lock/blocking port658 . args659)");
lf[420]=C_h_intern(&lf[420],14,"file-test-lock");
lf[421]=C_static_string(C_heaptop,18,"cannot unlock file");
lf[422]=C_static_lambda_info(C_heaptop,34,"(file-test-lock port661 . args662)");
lf[423]=C_h_intern(&lf[423],11,"file-unlock");
lf[424]=C_static_string(C_heaptop,18,"cannot unlock file");
lf[425]=C_static_lambda_info(C_heaptop,21,"(file-unlock lock671)");
lf[426]=C_h_intern(&lf[426],11,"create-fifo");
lf[427]=C_static_string(C_heaptop,18,"cannot create FIFO");
lf[428]=C_static_lambda_info(C_heaptop,32,"(create-fifo fname674 . mode675)");
lf[429]=C_h_intern(&lf[429],5,"fifo\077");
lf[430]=C_static_string(C_heaptop,19,"file does not exist");
lf[431]=C_static_lambda_info(C_heaptop,19,"(fifo\077 filename679)");
lf[432]=C_h_intern(&lf[432],6,"setenv");
lf[433]=C_static_lambda_info(C_heaptop,22,"(setenv var682 val683)");
lf[434]=C_h_intern(&lf[434],8,"unsetenv");
lf[435]=C_static_lambda_info(C_heaptop,17,"(unsetenv var687)");
lf[436]=C_h_intern(&lf[436],19,"current-environment");
lf[437]=C_static_lambda_info(C_heaptop,11,"(scan j700)");
lf[438]=C_static_lambda_info(C_heaptop,11,"(loop i697)");
lf[439]=C_static_lambda_info(C_heaptop,21,"(current-environment)");
lf[440]=C_h_intern(&lf[440],9,"prot/read");
lf[441]=C_h_intern(&lf[441],10,"prot/write");
lf[442]=C_h_intern(&lf[442],9,"prot/exec");
lf[443]=C_h_intern(&lf[443],9,"prot/none");
lf[444]=C_h_intern(&lf[444],9,"map/fixed");
lf[445]=C_h_intern(&lf[445],10,"map/shared");
lf[446]=C_h_intern(&lf[446],11,"map/private");
lf[447]=C_h_intern(&lf[447],13,"map/anonymous");
lf[448]=C_h_intern(&lf[448],8,"map/file");
lf[449]=C_h_intern(&lf[449],18,"map-file-to-memory");
lf[450]=C_h_intern(&lf[450],4,"mmap");
lf[451]=C_static_string(C_heaptop,25,"cannot map file to memory");
lf[452]=C_h_intern(&lf[452],20,"\003syspointer->address");
lf[453]=C_static_string(C_heaptop,41,"bad argument type - not a foreign pointer");
lf[454]=C_h_intern(&lf[454],16,"\003sysnull-pointer");
lf[455]=C_static_lambda_info(C_heaptop,66,"(map-file-to-memory addr725 len726 prot727 flag728 fd729 . off730)");
lf[456]=C_h_intern(&lf[456],22,"unmap-file-from-memory");
lf[457]=C_static_string(C_heaptop,29,"cannot unmap file from memory");
lf[458]=C_static_lambda_info(C_heaptop,41,"(unmap-file-from-memory mmap745 . len746)");
lf[459]=C_h_intern(&lf[459],26,"memory-mapped-file-pointer");
lf[460]=C_static_lambda_info(C_heaptop,36,"(memory-mapped-file-pointer mmap749)");
lf[461]=C_h_intern(&lf[461],19,"memory-mapped-file\077");
lf[462]=C_static_lambda_info(C_heaptop,26,"(memory-mapped-file\077 x751)");
lf[463]=C_h_intern(&lf[463],19,"seconds->local-time");
lf[464]=C_h_intern(&lf[464],18,"\003sysdecode-seconds");
lf[465]=C_static_lambda_info(C_heaptop,29,"(seconds->local-time secs764)");
lf[466]=C_h_intern(&lf[466],17,"seconds->utc-time");
lf[467]=C_static_lambda_info(C_heaptop,27,"(seconds->utc-time secs766)");
lf[468]=C_h_intern(&lf[468],15,"seconds->string");
lf[469]=C_static_string(C_heaptop,32,"cannot convert seconds to string");
lf[470]=C_static_lambda_info(C_heaptop,25,"(seconds->string secs774)");
lf[471]=C_h_intern(&lf[471],12,"time->string");
lf[472]=C_static_string(C_heaptop,36,"cannot convert time vector to string");
lf[473]=C_static_string(C_heaptop,21,"time vector too short");
lf[474]=C_static_lambda_info(C_heaptop,20,"(time->string tm783)");
lf[475]=C_h_intern(&lf[475],19,"local-time->seconds");
lf[476]=C_h_intern(&lf[476],15,"\003syscons-flonum");
lf[477]=C_static_string(C_heaptop,37,"cannot convert time vector to seconds");
lf[478]=C_static_string(C_heaptop,21,"time vector too short");
lf[479]=C_static_lambda_info(C_heaptop,27,"(local-time->seconds tm788)");
lf[480]=C_h_intern(&lf[480],17,"utc-time->seconds");
lf[481]=C_static_string(C_heaptop,37,"cannot convert time vector to seconds");
lf[482]=C_static_string(C_heaptop,21,"time vector too short");
lf[483]=C_static_lambda_info(C_heaptop,25,"(utc-time->seconds tm791)");
lf[484]=C_h_intern(&lf[484],27,"local-timezone-abbreviation");
lf[485]=C_static_lambda_info(C_heaptop,29,"(local-timezone-abbreviation)");
lf[486]=C_h_intern(&lf[486],5,"_exit");
lf[487]=C_h_intern(&lf[487],23,"\003syscleanup-before-exit");
lf[488]=C_static_lambda_info(C_heaptop,17,"(_exit . code802)");
lf[489]=C_h_intern(&lf[489],10,"set-alarm!");
lf[490]=C_static_lambda_info(C_heaptop,20,"(set-alarm! a804807)");
lf[491]=C_h_intern(&lf[491],19,"set-buffering-mode!");
lf[492]=C_static_string(C_heaptop,25,"cannot set buffering mode");
lf[493]=C_h_intern(&lf[493],5,"\000full");
lf[494]=C_h_intern(&lf[494],5,"\000line");
lf[495]=C_h_intern(&lf[495],5,"\000none");
lf[496]=C_static_string(C_heaptop,22,"invalid buffering-mode");
lf[497]=C_static_lambda_info(C_heaptop,47,"(set-buffering-mode! port808 mode809 . size810)");
lf[498]=C_h_intern(&lf[498],14,"terminal-port\077");
lf[499]=C_static_lambda_info(C_heaptop,24,"(terminal-port\077 port817)");
lf[500]=C_h_intern(&lf[500],13,"terminal-name");
lf[501]=C_static_string(C_heaptop,35,"port is not connected to a terminal");
lf[502]=C_static_lambda_info(C_heaptop,23,"(terminal-name port826)");
lf[503]=C_h_intern(&lf[503],13,"get-host-name");
lf[504]=C_h_intern(&lf[504],6,"\000error");
lf[505]=C_static_string(C_heaptop,25,"cannot retrieve host-name");
lf[506]=C_static_lambda_info(C_heaptop,15,"(get-host-name)");
lf[507]=C_h_intern(&lf[507],12,"glob->regexp");
lf[508]=C_h_intern(&lf[508],13,"make-pathname");
lf[509]=C_h_intern(&lf[509],18,"decompose-pathname");
lf[510]=C_h_intern(&lf[510],4,"glob");
lf[511]=C_static_lambda_info(C_heaptop,7,"(a4982)");
lf[512]=C_h_intern(&lf[512],12,"string-match");
lf[513]=C_static_lambda_info(C_heaptop,11,"(loop f858)");
lf[514]=C_static_string(C_heaptop,1,".");
lf[515]=C_static_string(C_heaptop,1,"*");
lf[516]=C_static_lambda_info(C_heaptop,38,"(a4988 dir845848 file846849 ext847850)");
lf[517]=C_static_lambda_info(C_heaptop,15,"(conc paths843)");
lf[518]=C_static_lambda_info(C_heaptop,17,"(glob . paths841)");
lf[519]=C_h_intern(&lf[519],12,"process-fork");
lf[520]=C_static_string(C_heaptop,27,"cannot create child process");
lf[521]=C_static_lambda_info(C_heaptop,16,"(f_5094 a871874)");
lf[522]=C_static_lambda_info(C_heaptop,25,"(process-fork . thunk869)");
lf[523]=C_static_lambda_info(C_heaptop,24,"(setarg a882888 a881889)");
lf[524]=C_static_lambda_info(C_heaptop,24,"(setenv a894900 a893901)");
lf[525]=C_h_intern(&lf[525],24,"pathname-strip-directory");
lf[526]=C_h_intern(&lf[526],15,"process-execute");
lf[527]=C_static_string(C_heaptop,22,"cannot execute process");
lf[528]=C_static_lambda_info(C_heaptop,12,"(do923 i926)");
lf[529]=C_static_lambda_info(C_heaptop,18,"(do919 al921 i922)");
lf[530]=C_static_lambda_info(C_heaptop,31,"(body910 arglist916 envlist917)");
lf[531]=C_static_lambda_info(C_heaptop,31,"(def-envlist913 %arglist908945)");
lf[532]=C_static_lambda_info(C_heaptop,16,"(def-arglist912)");
lf[533]=C_static_lambda_info(C_heaptop,39,"(process-execute filename906 . g905907)");
lf[534]=C_h_intern(&lf[534],16,"\003sysprocess-wait");
lf[535]=C_static_lambda_info(C_heaptop,37,"(##sys#process-wait pid951 nohang952)");
lf[536]=C_h_intern(&lf[536],12,"process-wait");
lf[537]=C_static_lambda_info(C_heaptop,7,"(a5373)");
lf[538]=C_static_string(C_heaptop,32,"waiting for child process failed");
lf[539]=C_static_lambda_info(C_heaptop,33,"(a5379 epid967 enorm968 ecode969)");
lf[540]=C_static_lambda_info(C_heaptop,24,"(process-wait . args955)");
lf[541]=C_h_intern(&lf[541],18,"current-process-id");
lf[542]=C_static_lambda_info(C_heaptop,20,"(current-process-id)");
lf[543]=C_h_intern(&lf[543],17,"parent-process-id");
lf[544]=C_static_lambda_info(C_heaptop,19,"(parent-process-id)");
lf[545]=C_h_intern(&lf[545],5,"sleep");
lf[546]=C_static_lambda_info(C_heaptop,15,"(sleep a975978)");
lf[547]=C_h_intern(&lf[547],14,"process-signal");
lf[548]=C_static_string(C_heaptop,32,"could not send signal to process");
lf[549]=C_static_lambda_info(C_heaptop,31,"(process-signal id979 . sig980)");
lf[550]=C_h_intern(&lf[550],17,"\003sysshell-command");
lf[551]=C_static_string(C_heaptop,7,"/bin/sh");
lf[552]=C_h_intern(&lf[552],6,"getenv");
lf[553]=C_static_string(C_heaptop,5,"SHELL");
lf[554]=C_static_lambda_info(C_heaptop,21,"(##sys#shell-command)");
lf[555]=C_h_intern(&lf[555],27,"\003sysshell-command-arguments");
lf[556]=C_static_string(C_heaptop,2,"-c");
lf[557]=C_static_lambda_info(C_heaptop,41,"(##sys#shell-command-arguments cmdlin987)");
lf[558]=C_h_intern(&lf[558],11,"process-run");
lf[559]=C_static_lambda_info(C_heaptop,28,"(process-run f991 . args992)");
lf[560]=C_static_lambda_info(C_heaptop,7,"(a5549)");
lf[561]=C_static_string(C_heaptop,21,"abnormal process exit");
lf[562]=C_static_lambda_info(C_heaptop,29,"(a5555 _1016 flg1017 cod1018)");
lf[563]=C_static_lambda_info(C_heaptop,8,"(f_5535)");
lf[564]=C_static_lambda_info(C_heaptop,68,"(make-on-close loc1010 pid1011 clsvec1012 idx1013 idxa1014 idxb1015)");
lf[565]=C_static_lambda_info(C_heaptop,7,"(a5578)");
lf[566]=C_static_lambda_info(C_heaptop,19,"(a5584 i1022 o1023)");
lf[567]=C_static_lambda_info(C_heaptop,22,"(needed-pipe port1021)");
lf[568]=C_static_lambda_info(C_heaptop,34,"(connect-parent pipe1025 port1026)");
lf[569]=C_static_lambda_info(C_heaptop,43,"(connect-child pipe1033 port1034 stdfd1035)");
lf[570]=C_static_lambda_info(C_heaptop,11,"(swap-ends)");
lf[571]=C_static_lambda_info(C_heaptop,7,"(a5662)");
lf[572]=C_static_lambda_info(C_heaptop,67,"(child cmd1043 args1044 env1045 stdoutf1046 stdinf1047 stderrf1048)");
lf[573]=C_static_lambda_info(C_heaptop,59,"(input-port loc1057 cmd1059 pipe1060 stdf1061 on-close1063)");
lf[574]=C_static_lambda_info(C_heaptop,60,"(output-port loc1065 cmd1067 pipe1068 stdf1069 on-close1071)");
lf[575]=C_h_intern(&lf[575],11,"\003sysprocess");
lf[576]=C_static_lambda_info(C_heaptop,7,"(a5712)");
lf[577]=C_static_lambda_info(C_heaptop,50,"(a5718 inpipe1080 outpipe1081 errpipe1082 pid1083)");
lf[578]=C_static_lambda_info(C_heaptop,83,"(##sys#process loc1073 cmd1074 args1075 env1076 stdoutf1077 stdinf1078 stderrf10"
"79)");
lf[579]=C_static_lambda_info(C_heaptop,7,"(a5777)");
lf[580]=C_static_lambda_info(C_heaptop,38,"(a5783 in1098 out1099 pid1100 err1101)");
lf[581]=C_static_lambda_info(C_heaptop,17,"(a5801 g10951096)");
lf[582]=C_static_lambda_info(C_heaptop,17,"(a5813 g10911092)");
lf[583]=C_static_lambda_info(C_heaptop,52,"(%process loc1086 err\0771087 cmd1088 args1089 env1090)");
lf[584]=C_h_intern(&lf[584],7,"process");
lf[585]=C_static_lambda_info(C_heaptop,27,"(body1110 args1116 env1117)");
lf[586]=C_static_lambda_info(C_heaptop,27,"(def-env1113 %args11081119)");
lf[587]=C_static_lambda_info(C_heaptop,14,"(def-args1112)");
lf[588]=C_static_lambda_info(C_heaptop,29,"(process cmd1106 . g11051107)");
lf[589]=C_h_intern(&lf[589],8,"process*");
lf[590]=C_static_lambda_info(C_heaptop,27,"(body1130 args1136 env1137)");
lf[591]=C_static_lambda_info(C_heaptop,27,"(def-env1133 %args11281139)");
lf[592]=C_static_lambda_info(C_heaptop,14,"(def-args1132)");
lf[593]=C_static_lambda_info(C_heaptop,30,"(process* cmd1126 . g11251127)");
lf[594]=C_h_intern(&lf[594],10,"find-files");
lf[595]=C_static_lambda_info(C_heaptop,14,"(f_6074 x1183)");
lf[596]=C_static_string(C_heaptop,1,".");
lf[597]=C_static_string(C_heaptop,2,"..");
lf[598]=C_static_lambda_info(C_heaptop,7,"(a6014)");
lf[599]=C_static_string(C_heaptop,1,"*");
lf[600]=C_static_lambda_info(C_heaptop,7,"(a6022)");
lf[601]=C_static_lambda_info(C_heaptop,7,"(a6036)");
lf[602]=C_h_intern(&lf[602],16,"\003sysdynamic-wind");
lf[603]=C_h_intern(&lf[603],13,"pathname-file");
lf[604]=C_static_lambda_info(C_heaptop,19,"(loop fs1185 r1186)");
lf[605]=C_static_string(C_heaptop,1,"*");
lf[606]=C_static_lambda_info(C_heaptop,16,"(f_6090 . _1181)");
lf[607]=C_static_lambda_info(C_heaptop,16,"(f_6082 . _1180)");
lf[608]=C_static_lambda_info(C_heaptop,38,"(body1168 action1175 id1176 limit1177)");
lf[609]=C_static_lambda_info(C_heaptop,43,"(def-limit1172 %action11651200 %id11661201)");
lf[610]=C_static_lambda_info(C_heaptop,28,"(def-id1171 %action11651203)");
lf[611]=C_static_lambda_info(C_heaptop,19,"(a6110 x1205 y1206)");
lf[612]=C_static_lambda_info(C_heaptop,16,"(def-action1170)");
lf[613]=C_static_lambda_info(C_heaptop,51,"(find-files dir1162 pred1163 . action-id-limit1164)");
lf[614]=C_h_intern(&lf[614],19,"set-root-directory!");
lf[615]=C_static_string(C_heaptop,31,"unable to change root directory");
lf[616]=C_static_lambda_info(C_heaptop,29,"(set-root-directory! dir1220)");
lf[617]=C_static_string(C_heaptop,32,"cannot retrieve process group ID");
lf[618]=C_static_lambda_info(C_heaptop,14,"(a6209 pid445)");
lf[619]=C_h_intern(&lf[619],18,"getter-with-setter");
lf[620]=C_static_lambda_info(C_heaptop,7,"(a6227)");
lf[621]=C_static_lambda_info(C_heaptop,7,"(a6230)");
lf[622]=C_static_lambda_info(C_heaptop,7,"(a6233)");
lf[623]=C_h_intern(&lf[623],26,"effective-group-id!-setter");
lf[624]=C_static_string(C_heaptop,29,"cannot set effective group ID");
lf[625]=C_static_lambda_info(C_heaptop,13,"(a6236 id414)");
lf[626]=C_static_lambda_info(C_heaptop,7,"(a6251)");
lf[627]=C_h_intern(&lf[627],25,"effective-user-id!-setter");
lf[628]=C_static_string(C_heaptop,28,"cannot set effective user ID");
lf[629]=C_static_lambda_info(C_heaptop,13,"(a6254 id410)");
lf[630]=C_h_intern(&lf[630],23,"\003sysuser-interrupt-hook");
lf[631]=C_static_lambda_info(C_heaptop,12,"(a6269 n329)");
lf[632]=C_h_intern(&lf[632],11,"make-vector");
lf[633]=C_static_string(C_heaptop,37,"cannot retrieve file position of port");
lf[634]=C_static_string(C_heaptop,12,"invalid file");
lf[635]=C_static_lambda_info(C_heaptop,15,"(a6275 port164)");
lf[636]=C_h_intern(&lf[636],17,"register-feature!");
lf[637]=C_h_intern(&lf[637],5,"posix");
lf[638]=C_static_lambda_info(C_heaptop,10,"(toplevel)");
C_register_lf2(lf,639,create_ptable());
t2=C_mutate(&lf[0],lf[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1405,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
C_scheduler_toplevel(2,C_SCHEME_UNDEFINED,t3);}

/* k1403 */
static void C_ccall f_1405(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1405,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1408,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_regex_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1406 in k1403 */
static void C_ccall f_1408(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1408,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1411,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_extras_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1409 in k1406 in k1403 */
static void C_ccall f_1411(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1411,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1414,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
C_utils_toplevel(2,C_SCHEME_UNDEFINED,t2);}

/* k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1414(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1414,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1417,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 407  register-feature! */
t3=*((C_word*)lf[636]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,lf[637]);}

/* k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1417(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word ab[92],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1417,2,t0,t1);}
t2=*((C_word*)lf[2]+1);
t3=C_mutate(&lf[3],(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1429,a[2]=t2,a[3]=lf[8],tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[9]+1,lf[3]);
t5=C_mutate((C_word*)lf[10]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1447,a[2]=lf[11],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[12]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1454,a[2]=lf[13],tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[14]+1,C_fix((C_word)PIPE_BUF));
t8=C_mutate((C_word*)lf[15]+1,C_fix((C_word)F_DUPFD));
t9=C_mutate((C_word*)lf[16]+1,C_fix((C_word)F_GETFD));
t10=C_mutate((C_word*)lf[17]+1,C_fix((C_word)F_SETFD));
t11=C_mutate((C_word*)lf[18]+1,C_fix((C_word)F_GETFL));
t12=C_mutate((C_word*)lf[19]+1,C_fix((C_word)F_SETFL));
t13=C_mutate((C_word*)lf[20]+1,C_fix((C_word)O_RDONLY));
t14=C_mutate((C_word*)lf[21]+1,C_fix((C_word)O_WRONLY));
t15=C_mutate((C_word*)lf[22]+1,C_fix((C_word)O_RDWR));
t16=C_mutate((C_word*)lf[23]+1,C_fix((C_word)O_RDONLY));
t17=C_mutate((C_word*)lf[24]+1,C_fix((C_word)O_WRONLY));
t18=C_mutate((C_word*)lf[25]+1,C_fix((C_word)O_CREAT));
t19=C_mutate((C_word*)lf[26]+1,C_fix((C_word)O_APPEND));
t20=C_mutate((C_word*)lf[27]+1,C_fix((C_word)O_EXCL));
t21=C_mutate((C_word*)lf[28]+1,C_fix((C_word)O_NOCTTY));
t22=C_mutate((C_word*)lf[29]+1,C_fix((C_word)O_NONBLOCK));
t23=C_mutate((C_word*)lf[30]+1,C_fix((C_word)O_TRUNC));
t24=C_mutate((C_word*)lf[31]+1,C_fix((C_word)O_FSYNC));
t25=C_mutate((C_word*)lf[32]+1,C_fix((C_word)O_FSYNC));
t26=C_mutate((C_word*)lf[33]+1,C_fix((C_word)O_BINARY));
t27=C_mutate((C_word*)lf[34]+1,C_fix((C_word)O_TEXT));
t28=C_mutate((C_word*)lf[35]+1,C_fix((C_word)S_IRUSR));
t29=C_mutate((C_word*)lf[36]+1,C_fix((C_word)S_IWUSR));
t30=C_mutate((C_word*)lf[37]+1,C_fix((C_word)S_IXUSR));
t31=C_mutate((C_word*)lf[38]+1,C_fix((C_word)S_IRGRP));
t32=C_mutate((C_word*)lf[39]+1,C_fix((C_word)S_IWGRP));
t33=C_mutate((C_word*)lf[40]+1,C_fix((C_word)S_IXGRP));
t34=C_mutate((C_word*)lf[41]+1,C_fix((C_word)S_IROTH));
t35=C_mutate((C_word*)lf[42]+1,C_fix((C_word)S_IWOTH));
t36=C_mutate((C_word*)lf[43]+1,C_fix((C_word)S_IXOTH));
t37=C_mutate((C_word*)lf[44]+1,C_fix((C_word)S_IRWXU));
t38=C_mutate((C_word*)lf[45]+1,C_fix((C_word)S_IRWXG));
t39=C_mutate((C_word*)lf[46]+1,C_fix((C_word)S_IRWXO));
t40=C_mutate((C_word*)lf[47]+1,C_fix((C_word)S_ISVTX));
t41=C_mutate((C_word*)lf[48]+1,C_fix((C_word)S_ISUID));
t42=C_mutate((C_word*)lf[49]+1,C_fix((C_word)S_ISGID));
t43=C_mutate((C_word*)lf[50]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1511,a[2]=lf[54],tmp=(C_word)a,a+=3,tmp));
t44=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRGRP),C_fix((C_word)S_IROTH));
t45=(C_word)C_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRWXU),t44);
t46=C_mutate((C_word*)lf[55]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1557,a[2]=t45,a[3]=lf[59],tmp=(C_word)a,a+=4,tmp));
t47=C_mutate((C_word*)lf[60]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1595,a[2]=lf[62],tmp=(C_word)a,a+=3,tmp));
t48=*((C_word*)lf[63]+1);
t49=C_mutate((C_word*)lf[64]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1610,a[2]=t48,a[3]=lf[68],tmp=(C_word)a,a+=4,tmp));
t50=C_mutate((C_word*)lf[69]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1652,a[2]=lf[72],tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[73]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1691,a[2]=lf[76],tmp=(C_word)a,a+=3,tmp));
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1723,a[2]=lf[77],tmp=(C_word)a,a+=3,tmp);
t53=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1729,a[2]=lf[78],tmp=(C_word)a,a+=3,tmp);
t54=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1739,a[2]=lf[79],tmp=(C_word)a,a+=3,tmp);
t55=C_mutate((C_word*)lf[80]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1749,a[2]=t53,a[3]=t54,a[4]=t52,a[5]=lf[87],tmp=(C_word)a,a+=6,tmp));
t56=C_mutate((C_word*)lf[88]+1,C_fix((C_word)SEEK_SET));
t57=C_mutate((C_word*)lf[89]+1,C_fix((C_word)SEEK_END));
t58=C_mutate((C_word*)lf[90]+1,C_fix((C_word)SEEK_CUR));
t59=C_mutate(&lf[91],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1941,a[2]=lf[94],tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[95]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1978,a[2]=lf[96],tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[97]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2010,a[2]=lf[98],tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[99]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2016,a[2]=lf[100],tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[101]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2022,a[2]=lf[102],tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[103]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2028,a[2]=lf[104],tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[105]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2034,a[2]=lf[106],tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[107]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2040,a[2]=lf[108],tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[109]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2046,a[2]=lf[110],tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[111]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2055,a[2]=lf[112],tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[113]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2064,a[2]=lf[120],tmp=(C_word)a,a+=3,tmp));
t70=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2124,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t71=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6276,a[2]=lf[635],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 722  getter-with-setter */
t72=*((C_word*)lf[619]+1);
((C_proc4)C_retrieve_proc(t72))(4,t72,t70,t71,*((C_word*)lf[113]+1));}

/* a6275 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6276(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6276,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6280,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6292,a[2]=t3,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 724  port? */
t5=*((C_word*)lf[117]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k6290 in a6275 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6292(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(t2,lf[115]);
t4=((C_word*)t0)[2];
f_6280(2,t4,(C_truep(t3)?(C_word)C_ftell(((C_word*)t0)[3]):C_fix(-1)));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
t2=((C_word*)t0)[2];
f_6280(2,t2,(C_word)C_lseek(((C_word*)t0)[3],C_fix(0),C_fix((C_word)SEEK_CUR)));}
else{
/* posixunix.scm: 729  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[2],lf[66],lf[121],lf[634],((C_word*)t0)[3]);}}}

/* k6278 in a6275 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6280(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6280,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6283,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 731  posix-error */
t3=lf[3];
f_1429(6,t3,t2,lf[51],lf[121],lf[633],((C_word*)t0)[2]);}
else{
t3=t2;
f_6283(2,t3,C_SCHEME_UNDEFINED);}}

/* k6281 in k6278 in a6275 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2124(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word ab[146],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2124,2,t0,t1);}
t2=C_mutate((C_word*)lf[121]+1,t1);
t3=C_mutate((C_word*)lf[122]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2126,a[2]=lf[124],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[125]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2150,a[2]=lf[127],tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[128]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2174,a[2]=lf[130],tmp=(C_word)a,a+=3,tmp));
t6=*((C_word*)lf[2]+1);
t7=*((C_word*)lf[63]+1);
t8=*((C_word*)lf[131]+1);
t9=C_mutate((C_word*)lf[132]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2198,a[2]=t7,a[3]=lf[140],tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[141]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2355,a[2]=lf[143],tmp=(C_word)a,a+=3,tmp));
t11=*((C_word*)lf[63]+1);
t12=C_mutate((C_word*)lf[138]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2378,a[2]=t11,a[3]=lf[145],tmp=(C_word)a,a+=4,tmp));
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2421,a[2]=lf[147],tmp=(C_word)a,a+=3,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2433,a[2]=lf[149],tmp=(C_word)a,a+=3,tmp);
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2439,a[2]=lf[154],tmp=(C_word)a,a+=3,tmp);
t16=C_mutate((C_word*)lf[155]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2454,a[2]=t14,a[3]=t15,a[4]=t13,a[5]=lf[157],tmp=(C_word)a,a+=6,tmp));
t17=C_mutate((C_word*)lf[158]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2490,a[2]=t14,a[3]=t15,a[4]=t13,a[5]=lf[159],tmp=(C_word)a,a+=6,tmp));
t18=C_mutate((C_word*)lf[160]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2526,a[2]=lf[164],tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[165]+1,*((C_word*)lf[160]+1));
t20=*((C_word*)lf[155]+1);
t21=*((C_word*)lf[158]+1);
t22=*((C_word*)lf[160]+1);
t23=*((C_word*)lf[165]+1);
t24=C_mutate((C_word*)lf[166]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2542,a[2]=t20,a[3]=t22,a[4]=lf[169],tmp=(C_word)a,a+=5,tmp));
t25=C_mutate((C_word*)lf[170]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2566,a[2]=t21,a[3]=t23,a[4]=lf[173],tmp=(C_word)a,a+=5,tmp));
t26=C_mutate((C_word*)lf[174]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2590,a[2]=t20,a[3]=t22,a[4]=lf[177],tmp=(C_word)a,a+=5,tmp));
t27=C_mutate((C_word*)lf[178]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2610,a[2]=t21,a[3]=t23,a[4]=lf[181],tmp=(C_word)a,a+=5,tmp));
t28=C_mutate((C_word*)lf[182]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2630,a[2]=lf[184],tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[185]+1,C_fix((C_word)SIGTERM));
t30=C_mutate((C_word*)lf[186]+1,C_fix((C_word)SIGKILL));
t31=C_mutate((C_word*)lf[187]+1,C_fix((C_word)SIGINT));
t32=C_mutate((C_word*)lf[188]+1,C_fix((C_word)SIGHUP));
t33=C_mutate((C_word*)lf[189]+1,C_fix((C_word)SIGFPE));
t34=C_mutate((C_word*)lf[190]+1,C_fix((C_word)SIGILL));
t35=C_mutate((C_word*)lf[191]+1,C_fix((C_word)SIGSEGV));
t36=C_mutate((C_word*)lf[192]+1,C_fix((C_word)SIGABRT));
t37=C_mutate((C_word*)lf[193]+1,C_fix((C_word)SIGTRAP));
t38=C_mutate((C_word*)lf[194]+1,C_fix((C_word)SIGQUIT));
t39=C_mutate((C_word*)lf[195]+1,C_fix((C_word)SIGALRM));
t40=C_mutate((C_word*)lf[196]+1,C_fix((C_word)SIGVTALRM));
t41=C_mutate((C_word*)lf[197]+1,C_fix((C_word)SIGPROF));
t42=C_mutate((C_word*)lf[198]+1,C_fix((C_word)SIGIO));
t43=C_mutate((C_word*)lf[199]+1,C_fix((C_word)SIGURG));
t44=C_mutate((C_word*)lf[200]+1,C_fix((C_word)SIGCHLD));
t45=C_mutate((C_word*)lf[201]+1,C_fix((C_word)SIGCONT));
t46=C_mutate((C_word*)lf[202]+1,C_fix((C_word)SIGSTOP));
t47=C_mutate((C_word*)lf[203]+1,C_fix((C_word)SIGTSTP));
t48=C_mutate((C_word*)lf[204]+1,C_fix((C_word)SIGPIPE));
t49=C_mutate((C_word*)lf[205]+1,C_fix((C_word)SIGXCPU));
t50=C_mutate((C_word*)lf[206]+1,C_fix((C_word)SIGXFSZ));
t51=C_mutate((C_word*)lf[207]+1,C_fix((C_word)SIGUSR1));
t52=C_mutate((C_word*)lf[208]+1,C_fix((C_word)SIGUSR2));
t53=C_mutate((C_word*)lf[209]+1,C_fix((C_word)SIGWINCH));
t54=(C_word)C_a_i_list(&a,25,*((C_word*)lf[185]+1),*((C_word*)lf[186]+1),*((C_word*)lf[187]+1),*((C_word*)lf[188]+1),*((C_word*)lf[189]+1),*((C_word*)lf[190]+1),*((C_word*)lf[191]+1),*((C_word*)lf[192]+1),*((C_word*)lf[193]+1),*((C_word*)lf[194]+1),*((C_word*)lf[195]+1),*((C_word*)lf[196]+1),*((C_word*)lf[197]+1),*((C_word*)lf[198]+1),*((C_word*)lf[199]+1),*((C_word*)lf[200]+1),*((C_word*)lf[201]+1),*((C_word*)lf[202]+1),*((C_word*)lf[203]+1),*((C_word*)lf[204]+1),*((C_word*)lf[205]+1),*((C_word*)lf[206]+1),*((C_word*)lf[207]+1),*((C_word*)lf[208]+1),*((C_word*)lf[209]+1));
t55=C_mutate((C_word*)lf[210]+1,t54);
t56=*((C_word*)lf[211]+1);
t57=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2675,a[2]=((C_word*)t0)[2],a[3]=t56,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 965  make-vector */
t58=*((C_word*)lf[632]+1);
((C_proc4)(void*)(*((C_word*)t58+1)))(4,t58,t57,C_fix(256),C_SCHEME_FALSE);}

/* k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2675(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[34],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2675,2,t0,t1);}
t2=C_mutate((C_word*)lf[212]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2677,a[2]=t1,a[3]=lf[213],tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[214]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2686,a[2]=t1,a[3]=lf[215],tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[211]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2699,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=lf[216],tmp=(C_word)a,a+=5,tmp));
t5=C_mutate((C_word*)lf[217]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2717,a[2]=lf[221],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[222]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2741,a[2]=lf[224],tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[225]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2773,a[2]=lf[226],tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[227]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2779,a[2]=lf[229],tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[230]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2794,a[2]=lf[232],tmp=(C_word)a,a+=3,tmp));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2810,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6270,a[2]=lf[631],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1021 set-signal-handler! */
t12=*((C_word*)lf[214]+1);
((C_proc4)C_retrieve_proc(t12))(4,t12,t10,*((C_word*)lf[187]+1),t11);}

/* a6269 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6270(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6270,3,t0,t1,t2);}
/* posixunix.scm: 1023 ##sys#user-interrupt-hook */
t3=*((C_word*)lf[630]+1);
((C_proc2)C_retrieve_proc(t3))(2,t3,t1);}

/* k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2810(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word ab[36],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2810,2,t0,t1);}
t2=C_mutate((C_word*)lf[233]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2812,a[2]=lf[236],tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[237]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2850,a[2]=lf[238],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[239]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2903,a[2]=lf[241],tmp=(C_word)a,a+=3,tmp));
t5=C_mutate(&lf[242],(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2964,a[2]=lf[243],tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[244]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2971,a[2]=lf[249],tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[250]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3034,a[2]=lf[254],tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[255]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3108,a[2]=lf[257],tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[258]+1,C_fix((C_word)EPERM));
t10=C_mutate((C_word*)lf[259]+1,C_fix((C_word)ENOENT));
t11=C_mutate((C_word*)lf[260]+1,C_fix((C_word)ESRCH));
t12=C_mutate((C_word*)lf[261]+1,C_fix((C_word)EINTR));
t13=C_mutate((C_word*)lf[262]+1,C_fix((C_word)EIO));
t14=C_mutate((C_word*)lf[263]+1,C_fix((C_word)ENOEXEC));
t15=C_mutate((C_word*)lf[264]+1,C_fix((C_word)EBADF));
t16=C_mutate((C_word*)lf[265]+1,C_fix((C_word)ECHILD));
t17=C_mutate((C_word*)lf[266]+1,C_fix((C_word)ENOMEM));
t18=C_mutate((C_word*)lf[267]+1,C_fix((C_word)EACCES));
t19=C_mutate((C_word*)lf[268]+1,C_fix((C_word)EFAULT));
t20=C_mutate((C_word*)lf[269]+1,C_fix((C_word)EBUSY));
t21=C_mutate((C_word*)lf[270]+1,C_fix((C_word)ENOTDIR));
t22=C_mutate((C_word*)lf[271]+1,C_fix((C_word)EISDIR));
t23=C_mutate((C_word*)lf[272]+1,C_fix((C_word)EINVAL));
t24=C_mutate((C_word*)lf[273]+1,C_fix((C_word)EMFILE));
t25=C_mutate((C_word*)lf[274]+1,C_fix((C_word)ENOSPC));
t26=C_mutate((C_word*)lf[275]+1,C_fix((C_word)ESPIPE));
t27=C_mutate((C_word*)lf[276]+1,C_fix((C_word)EPIPE));
t28=C_mutate((C_word*)lf[277]+1,C_fix((C_word)EAGAIN));
t29=C_mutate((C_word*)lf[278]+1,C_fix((C_word)EROFS));
t30=C_mutate((C_word*)lf[279]+1,C_fix((C_word)EEXIST));
t31=C_mutate((C_word*)lf[280]+1,C_fix((C_word)EWOULDBLOCK));
t32=C_set_block_item(lf[281],0,C_fix(0));
t33=C_set_block_item(lf[282],0,C_fix(0));
t34=C_set_block_item(lf[283],0,C_fix(0));
t35=C_set_block_item(lf[284],0,C_fix(0));
t36=C_set_block_item(lf[285],0,C_fix(0));
t37=C_set_block_item(lf[286],0,C_fix(0));
t38=C_set_block_item(lf[287],0,C_fix(0));
t39=C_set_block_item(lf[288],0,C_fix(0));
t40=C_set_block_item(lf[289],0,C_fix(0));
t41=C_set_block_item(lf[290],0,C_fix(0));
t42=C_set_block_item(lf[291],0,C_fix(0));
t43=C_set_block_item(lf[292],0,C_fix(0));
t44=C_set_block_item(lf[293],0,C_fix(0));
t45=C_set_block_item(lf[294],0,C_fix(0));
t46=C_set_block_item(lf[295],0,C_fix(0));
t47=C_set_block_item(lf[296],0,C_fix(0));
t48=C_mutate((C_word*)lf[297]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3172,a[2]=lf[299],tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[300]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3199,a[2]=lf[302],tmp=(C_word)a,a+=3,tmp));
t50=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3231,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t51=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6252,a[2]=lf[626],tmp=(C_word)a,a+=3,tmp);
t52=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6255,a[2]=lf[629],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1240 getter-with-setter */
t53=*((C_word*)lf[619]+1);
((C_proc4)C_retrieve_proc(t53))(4,t53,t50,t51,t52);}

/* a6254 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6255(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6255,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_seteuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6265,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1244 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k6263 in a6254 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6265(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1245 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[627],lf[628],((C_word*)t0)[2]);}

/* a6251 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6252(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6252,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub408(C_SCHEME_UNDEFINED));}

/* k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3231,2,t0,t1);}
t2=C_mutate((C_word*)lf[303]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3235,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6234,a[2]=lf[622],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6237,a[2]=lf[625],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1249 getter-with-setter */
t6=*((C_word*)lf[619]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t3,t4,t5);}

/* a6236 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6237(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6237,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setegid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6247,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1253 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k6245 in a6236 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1254 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[623],lf[624],((C_word*)t0)[2]);}

/* a6233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6234(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6234,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub412(C_SCHEME_UNDEFINED));}

/* k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3235(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3235,2,t0,t1);}
t2=C_mutate((C_word*)lf[304]+1,t1);
t3=C_mutate((C_word*)lf[305]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3237,a[2]=lf[307],tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3254,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6231,a[2]=lf[621],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1264 getter-with-setter */
t6=*((C_word*)lf[619]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,t5,*((C_word*)lf[305]+1));}

/* a6230 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6231(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6231,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub418(C_SCHEME_UNDEFINED));}

/* k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3254(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3254,2,t0,t1);}
t2=C_mutate((C_word*)lf[308]+1,t1);
t3=C_mutate((C_word*)lf[309]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3256,a[2]=lf[311],tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3273,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6228,a[2]=lf[620],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1275 getter-with-setter */
t6=*((C_word*)lf[619]+1);
((C_proc4)C_retrieve_proc(t6))(4,t6,t4,t5,*((C_word*)lf[309]+1));}

/* a6227 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6228(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6228,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub422(C_SCHEME_UNDEFINED));}

/* k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3273(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[27],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3273,2,t0,t1);}
t2=C_mutate((C_word*)lf[312]+1,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3275,a[2]=lf[313],tmp=(C_word)a,a+=3,tmp);
t4=C_mutate((C_word*)lf[314]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3299,a[2]=t3,a[3]=lf[315],tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[316]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3305,a[2]=t3,a[3]=lf[317],tmp=(C_word)a,a+=4,tmp));
t6=C_mutate((C_word*)lf[318]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3311,a[2]=t3,a[3]=lf[319],tmp=(C_word)a,a+=4,tmp));
t7=C_mutate((C_word*)lf[320]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3317,a[2]=lf[322],tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[323]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3332,a[2]=lf[325],tmp=(C_word)a,a+=3,tmp));
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3355,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6210,a[2]=lf[618],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1308 getter-with-setter */
t11=*((C_word*)lf[619]+1);
((C_proc4)C_retrieve_proc(t11))(4,t11,t9,t10,*((C_word*)lf[323]+1));}

/* a6209 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6210(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6210,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[326]);
t4=(C_word)C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6217,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6223,a[2]=t2,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1313 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t5;
f_6217(2,t6,C_SCHEME_UNDEFINED);}}

/* k6221 in a6209 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1314 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[326],lf[617],((C_word*)t0)[2]);}

/* k6215 in a6209 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3355(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3355,2,t0,t1);}
t2=C_mutate((C_word*)lf[326]+1,t1);
t3=C_mutate((C_word*)lf[327]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3357,a[2]=lf[330],tmp=(C_word)a,a+=3,tmp));
t4=*((C_word*)lf[331]+1);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3394,a[2]=((C_word*)t0)[2],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_word)C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
/* posixunix.scm: 1335 make-string */
t7=*((C_word*)lf[63]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}

/* k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word ab[243],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3394,2,t0,t1);}
t2=C_mutate((C_word*)lf[332]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3395,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=lf[334],tmp=(C_word)a,a+=5,tmp));
t3=C_mutate((C_word*)lf[335]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3445,a[2]=lf[338],tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[339]+1,C_fix((C_word)STDIN_FILENO));
t5=C_mutate((C_word*)lf[340]+1,C_fix((C_word)STDOUT_FILENO));
t6=C_mutate((C_word*)lf[341]+1,C_fix((C_word)STDERR_FILENO));
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3470,a[2]=lf[348],tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3507,a[2]=lf[351],tmp=(C_word)a,a+=3,tmp);
t9=C_mutate((C_word*)lf[352]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3522,a[2]=t7,a[3]=t8,a[4]=lf[353],tmp=(C_word)a,a+=5,tmp));
t10=C_mutate((C_word*)lf[354]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3536,a[2]=t7,a[3]=t8,a[4]=lf[355],tmp=(C_word)a,a+=5,tmp));
t11=C_mutate((C_word*)lf[356]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3550,a[2]=lf[362],tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[363]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3595,a[2]=lf[365],tmp=(C_word)a,a+=3,tmp));
t13=*((C_word*)lf[366]+1);
t14=*((C_word*)lf[367]+1);
t15=C_mutate((C_word*)lf[368]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3622,a[2]=t13,a[3]=t14,a[4]=lf[390],tmp=(C_word)a,a+=5,tmp));
t16=*((C_word*)lf[391]+1);
t17=*((C_word*)lf[367]+1);
t18=C_mutate((C_word*)lf[392]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3894,a[2]=t16,a[3]=t17,a[4]=lf[406],tmp=(C_word)a,a+=5,tmp));
t19=C_mutate((C_word*)lf[407]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4133,a[2]=lf[410],tmp=(C_word)a,a+=3,tmp));
t20=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4172,a[2]=lf[412],tmp=(C_word)a,a+=3,tmp);
t21=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4246,a[2]=lf[413],tmp=(C_word)a,a+=3,tmp);
t22=C_mutate((C_word*)lf[414]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4264,a[2]=t20,a[3]=t21,a[4]=lf[416],tmp=(C_word)a,a+=5,tmp));
t23=C_mutate((C_word*)lf[417]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4279,a[2]=t20,a[3]=t21,a[4]=lf[419],tmp=(C_word)a,a+=5,tmp));
t24=C_mutate((C_word*)lf[420]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4294,a[2]=t20,a[3]=t21,a[4]=lf[422],tmp=(C_word)a,a+=5,tmp));
t25=C_mutate((C_word*)lf[423]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4316,a[2]=lf[425],tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[426]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4344,a[2]=lf[428],tmp=(C_word)a,a+=3,tmp));
t27=C_mutate((C_word*)lf[429]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4387,a[2]=lf[431],tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[432]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4413,a[2]=lf[433],tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[434]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4430,a[2]=lf[435],tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[436]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4450,a[2]=lf[439],tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[440]+1,C_fix((C_word)PROT_READ));
t32=C_mutate((C_word*)lf[441]+1,C_fix((C_word)PROT_WRITE));
t33=C_mutate((C_word*)lf[442]+1,C_fix((C_word)PROT_EXEC));
t34=C_mutate((C_word*)lf[443]+1,C_fix((C_word)PROT_NONE));
t35=C_mutate((C_word*)lf[444]+1,C_fix((C_word)MAP_FIXED));
t36=C_mutate((C_word*)lf[445]+1,C_fix((C_word)MAP_SHARED));
t37=C_mutate((C_word*)lf[446]+1,C_fix((C_word)MAP_PRIVATE));
t38=C_mutate((C_word*)lf[447]+1,C_fix((C_word)MAP_ANON));
t39=C_mutate((C_word*)lf[448]+1,C_fix((C_word)MAP_FILE));
t40=C_mutate((C_word*)lf[449]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4553,a[2]=lf[455],tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[456]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4615,a[2]=lf[458],tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[459]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4650,a[2]=lf[460],tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[461]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4659,a[2]=lf[462],tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[463]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4665,a[2]=lf[465],tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[466]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4674,a[2]=lf[467],tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[468]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4693,a[2]=lf[470],tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[471]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4710,a[2]=lf[474],tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[475]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4738,a[2]=lf[479],tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[480]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4766,a[2]=lf[483],tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[484]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4794,a[2]=lf[485],tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[486]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4806,a[2]=lf[488],tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[489]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4825,a[2]=lf[490],tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[491]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4832,a[2]=lf[497],tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[498]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4891,a[2]=lf[499],tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[500]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4920,a[2]=lf[502],tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[503]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4950,a[2]=lf[506],tmp=(C_word)a,a+=3,tmp));
t57=*((C_word*)lf[507]+1);
t58=*((C_word*)lf[132]+1);
t59=*((C_word*)lf[508]+1);
t60=*((C_word*)lf[509]+1);
t61=C_mutate((C_word*)lf[510]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4962,a[2]=t57,a[3]=t58,a[4]=t59,a[5]=t60,a[6]=lf[518],tmp=(C_word)a,a+=7,tmp));
t62=C_mutate((C_word*)lf[519]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5068,a[2]=lf[522],tmp=(C_word)a,a+=3,tmp));
t63=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5110,a[2]=lf[523],tmp=(C_word)a,a+=3,tmp);
t64=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5129,a[2]=lf[524],tmp=(C_word)a,a+=3,tmp);
t65=*((C_word*)lf[525]+1);
t66=C_mutate((C_word*)lf[526]+1,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5148,a[2]=t65,a[3]=t64,a[4]=t63,a[5]=lf[533],tmp=(C_word)a,a+=6,tmp));
t67=C_mutate((C_word*)lf[534]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5327,a[2]=lf[535],tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[536]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5344,a[2]=lf[540],tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[541]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5422,a[2]=lf[542],tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[543]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5425,a[2]=lf[544],tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[545]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5428,a[2]=lf[546],tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[547]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5435,a[2]=lf[549],tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[550]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5462,a[2]=lf[554],tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[555]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5471,a[2]=lf[557],tmp=(C_word)a,a+=3,tmp));
t75=*((C_word*)lf[519]+1);
t76=*((C_word*)lf[526]+1);
t77=*((C_word*)lf[552]+1);
t78=C_mutate((C_word*)lf[558]+1,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5477,a[2]=t75,a[3]=t76,a[4]=lf[559],tmp=(C_word)a,a+=5,tmp));
t79=*((C_word*)lf[182]+1);
t80=*((C_word*)lf[536]+1);
t81=*((C_word*)lf[519]+1);
t82=*((C_word*)lf[526]+1);
t83=*((C_word*)lf[363]+1);
t84=*((C_word*)lf[60]+1);
t85=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5533,a[2]=t80,a[3]=lf[564],tmp=(C_word)a,a+=4,tmp);
t86=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5570,a[2]=t79,a[3]=lf[567],tmp=(C_word)a,a+=4,tmp);
t87=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5590,a[2]=t84,a[3]=lf[568],tmp=(C_word)a,a+=4,tmp);
t88=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5607,a[2]=t84,a[3]=lf[569],tmp=(C_word)a,a+=4,tmp);
t89=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5624,a[2]=t86,a[3]=t81,a[4]=t88,a[5]=t82,a[6]=lf[572],tmp=(C_word)a,a+=7,tmp);
t90=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5685,a[2]=t87,a[3]=lf[573],tmp=(C_word)a,a+=4,tmp);
t91=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5696,a[2]=t87,a[3]=lf[574],tmp=(C_word)a,a+=4,tmp);
t92=C_mutate((C_word*)lf[575]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5707,a[2]=t91,a[3]=t85,a[4]=t90,a[5]=t89,a[6]=lf[578],tmp=(C_word)a,a+=7,tmp));
t93=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5763,a[2]=lf[583],tmp=(C_word)a,a+=3,tmp);
t94=C_mutate((C_word*)lf[584]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5828,a[2]=t93,a[3]=lf[588],tmp=(C_word)a,a+=4,tmp));
t95=C_mutate((C_word*)lf[589]+1,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5888,a[2]=t93,a[3]=lf[593],tmp=(C_word)a,a+=4,tmp));
t96=*((C_word*)lf[510]+1);
t97=*((C_word*)lf[512]+1);
t98=*((C_word*)lf[508]+1);
t99=*((C_word*)lf[141]+1);
t100=C_mutate((C_word*)lf[594]+1,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5948,a[2]=t99,a[3]=t98,a[4]=t96,a[5]=t97,a[6]=lf[613],tmp=(C_word)a,a+=7,tmp));
t101=C_mutate((C_word*)lf[614]+1,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6187,a[2]=lf[616],tmp=(C_word)a,a+=3,tmp));
t102=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t102+1)))(2,t102,C_SCHEME_UNDEFINED);}

/* set-root-directory! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6187(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6187,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[614]);
t4=t2;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6179,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
t6=(C_word)C_i_foreign_string_argumentp(t4);
/* ##sys#make-c-string */
t7=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t5,t6);}
else{
t6=t5;
f_6179(2,t6,C_SCHEME_FALSE);}}

/* k6177 in set-root-directory! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6179(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub1215(C_SCHEME_UNDEFINED,t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 2126 posix-error */
t3=lf[3];
f_1429(6,t3,((C_word*)t0)[3],lf[51],lf[614],lf[615],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5948(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+21)){
C_save_and_reclaim((void*)tr4r,(void*)f_5948r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_5948r(t0,t1,t2,t3,t4);}}

static void C_ccall f_5948r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(21);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5950,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=t2,a[8]=lf[608],tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6095,a[2]=t5,a[3]=lf[609],tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6100,a[2]=t6,a[3]=lf[610],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6105,a[2]=t7,a[3]=lf[612],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
/* def-action11701204 */
t9=t8;
f_6105(t9,t1);}
else{
t9=(C_word)C_i_car(t4);
t10=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-id11711202 */
t11=t7;
f_6100(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* def-limit11721199 */
t13=t6;
f_6095(t13,t1,t9,t11);}
else{
t13=(C_word)C_i_car(t12);
t14=(C_word)C_i_cdr(t12);
if(C_truep((C_word)C_i_nullp(t14))){
/* body11681174 */
t15=t5;
f_5950(t15,t1,t9,t11,t13);}
else{
/* ##sys#error */
t15=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}}}}

/* def-action1170 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_6105(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6105,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6111,a[2]=lf[611],tmp=(C_word)a,a+=3,tmp);
/* def-id11711202 */
t3=((C_word*)t0)[2];
f_6100(t3,t1,t2);}

/* a6110 in def-action1170 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6111(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_6111,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* def-id1171 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_6100(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6100,NULL,3,t0,t1,t2);}
/* def-limit11721199 */
t3=((C_word*)t0)[2];
f_6095(t3,t1,t2,C_SCHEME_END_OF_LIST);}

/* def-limit1172 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_6095(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_6095,NULL,4,t0,t1,t2,t3);}
/* body11681174 */
t4=((C_word*)t0)[2];
f_5950(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5950(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[22],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5950,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(((C_word*)t0)[7],lf[594]);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5957,a[2]=((C_word*)t0)[7],a[3]=t3,a[4]=t1,a[5]=((C_word*)t0)[2],a[6]=t2,a[7]=((C_word*)t0)[3],a[8]=((C_word*)t0)[4],a[9]=t7,a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],tmp=(C_word)a,a+=12,tmp);
t9=t4;
if(C_truep(t9)){
t10=(C_word)C_fixnump(t4);
t11=t8;
f_5957(t11,(C_truep(t10)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6090,a[2]=t4,a[3]=t7,a[4]=lf[606],tmp=(C_word)a,a+=5,tmp):t4));}
else{
t10=t8;
f_5957(t10,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6082,a[2]=lf[607],tmp=(C_word)a,a+=3,tmp));}}

/* f_6082 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6082(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6082,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_TRUE);}

/* f_6090 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6090(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6090,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[2]));}

/* k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5957(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5957,NULL,2,t0,t1);}
t2=(C_word)C_i_stringp(((C_word*)t0)[11]);
t3=(C_truep(t2)?(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6074,a[2]=((C_word*)t0)[11],a[3]=((C_word*)t0)[10],a[4]=lf[595],tmp=(C_word)a,a+=5,tmp):((C_word*)t0)[11]);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5967,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=t1,a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6070,a[2]=t4,a[3]=((C_word*)t0)[8],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2098 make-pathname */
t6=((C_word*)t0)[7];
((C_proc4)C_retrieve_proc(t6))(4,t6,t5,((C_word*)t0)[2],lf[605]);}

/* k6068 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6070(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2098 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5967(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5967,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5969,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t3,a[10]=lf[604],tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];
f_5969(t5,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5969(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5969,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5988,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t3,a[10]=t5,a[11]=t1,a[12]=((C_word*)t0)[9],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2104 directory? */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t4);}}

/* k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5988(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5988,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6050,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 2105 pathname-file */
t3=*((C_word*)lf[603]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[5]);}
else{
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6056,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[10],a[6]=((C_word*)t0)[11],a[7]=((C_word*)t0)[12],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2111 pproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[5]);}}

/* k6054 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6056(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6056,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6063,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2111 action */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 2112 loop */
t2=((C_word*)((C_word*)t0)[7])[1];
f_5969(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[2]);}}

/* k6061 in k6054 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6063(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2111 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5969(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6050(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6050,2,t0,t1);}
if(C_truep((C_truep((C_word)C_i_equalp(t1,lf[596]))?C_SCHEME_TRUE:(C_truep((C_word)C_i_equalp(t1,lf[597]))?C_SCHEME_TRUE:C_SCHEME_FALSE)))){
/* posixunix.scm: 2105 loop */
t2=((C_word*)((C_word*)t0)[10])[1];
f_5969(t2,((C_word*)t0)[9],((C_word*)t0)[8],((C_word*)t0)[7]);}
else{
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6003,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[6],tmp=(C_word)a,a+=10,tmp);
/* posixunix.scm: 2106 lproc */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}}

/* k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word ab[29],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6003,2,t0,t1);}
if(C_truep(t1)){
t2=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[9])[1],C_fix(1));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_SCHEME_FALSE;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6013,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6015,a[2]=t4,a[3]=((C_word*)t0)[9],a[4]=t6,a[5]=lf[598],tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6023,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[8],a[7]=lf[600],tmp=(C_word)a,a+=8,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6037,a[2]=t6,a[3]=((C_word*)t0)[9],a[4]=t4,a[5]=lf[601],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2108 ##sys#dynamic-wind */
t11=*((C_word*)lf[602]+1);
((C_proc5)(void*)(*((C_word*)t11+1)))(5,t11,t7,t8,t9,t10);}
else{
/* posixunix.scm: 2110 loop */
t2=((C_word*)((C_word*)t0)[8])[1];
f_5969(t2,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5]);}}

/* a6036 in k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6037(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6037,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[386]+1));}

/* a6022 in k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6023(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6023,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6031,a[2]=((C_word*)t0)[5],a[3]=t1,a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6035,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2109 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)t0)[2],lf[599]);}

/* k6033 in a6022 in k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6035(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2109 glob */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k6029 in a6022 in k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2109 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5969(t2,((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

/* a6014 in k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6015(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_6015,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)((C_word*)t0)[2])[1]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,*((C_word*)lf[386]+1));}

/* k6011 in k6001 in k6048 in k5986 in loop in k5965 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6013(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2107 loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_5969(t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* f_6074 in k5955 in body1168 in find-files in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_6074(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_6074,3,t0,t1,t2);}
/* posixunix.scm: 2096 string-match */
t3=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t3))(4,t3,t1,((C_word*)t0)[2],t2);}

/* process* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5888(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_5888r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5888r(t0,t1,t2,t3);}}

static void C_ccall f_5888r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5890,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=lf[590],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5895,a[2]=t4,a[3]=lf[591],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5900,a[2]=t5,a[3]=lf[592],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args11321140 */
t7=t6;
f_5900(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env11331138 */
t9=t5;
f_5895(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body11301135 */
t11=t4;
f_5890(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args1132 in process* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5900(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5900,NULL,2,t0,t1);}
/* def-env11331138 */
t2=((C_word*)t0)[2];
f_5895(t2,t1,C_SCHEME_FALSE);}

/* def-env1133 in process* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5895(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5895,NULL,3,t0,t1,t2);}
/* body11301135 */
t3=((C_word*)t0)[2];
f_5890(t3,t1,t2,C_SCHEME_FALSE);}

/* body1130 in process* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5890(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5890,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2074 %process */
f_5763(t1,lf[589],C_SCHEME_TRUE,((C_word*)t0)[2],t2,t3);}

/* process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5828(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+13)){
C_save_and_reclaim((void*)tr3r,(void*)f_5828r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5828r(t0,t1,t2,t3);}}

static void C_ccall f_5828r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(13);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5830,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=lf[585],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5835,a[2]=t4,a[3]=lf[586],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5840,a[2]=t5,a[3]=lf[587],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-args11121120 */
t7=t6;
f_5840(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-env11131118 */
t9=t5;
f_5835(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body11101115 */
t11=t4;
f_5830(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-args1112 in process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5840(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5840,NULL,2,t0,t1);}
/* def-env11131118 */
t2=((C_word*)t0)[2];
f_5835(t2,t1,C_SCHEME_FALSE);}

/* def-env1113 in process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5835(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5835,NULL,3,t0,t1,t2);}
/* body11101115 */
t3=((C_word*)t0)[2];
f_5830(t3,t1,t2,C_SCHEME_FALSE);}

/* body1110 in process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5830(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5830,NULL,4,t0,t1,t2,t3);}
/* posixunix.scm: 2071 %process */
f_5763(t1,lf[584],C_SCHEME_FALSE,((C_word*)t0)[2],t2,t3);}

/* %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5763(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5763,NULL,6,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t9=(C_word)C_i_check_string_2(((C_word*)t7)[1],t2);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5770,a[2]=t1,a[3]=t3,a[4]=t6,a[5]=t8,a[6]=t7,a[7]=t2,tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t8)[1])){
t11=(C_word)C_i_check_list_2(((C_word*)t8)[1],t2);
t12=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5814,a[2]=t2,a[3]=lf[582],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t13=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t13+1)))(4,t13,t10,t12,((C_word*)t8)[1]);}
else{
t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5822,a[2]=t10,a[3]=t7,a[4]=t8,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2059 ##sys#shell-command-arguments */
t12=*((C_word*)lf[555]+1);
((C_proc3)C_retrieve_proc(t12))(3,t12,t11,((C_word*)t7)[1]);}}

/* k5820 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5822(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5822,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[4])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5826,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2060 ##sys#shell-command */
t4=*((C_word*)lf[550]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k5824 in k5820 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[3])+1,t1);
t3=((C_word*)t0)[2];
f_5770(2,t3,t2);}

/* a5813 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5814(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5814,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* k5768 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5770(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5770,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5773,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[4])){
t3=(C_word)C_i_check_list_2(((C_word*)t0)[4],((C_word*)t0)[7]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5802,a[2]=((C_word*)t0)[7],a[3]=lf[581],tmp=(C_word)a,a+=4,tmp);
/* for-each */
t5=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,t4,((C_word*)t0)[4]);}
else{
t3=t2;
f_5773(2,t3,C_SCHEME_UNDEFINED);}}

/* a5801 in k5768 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5802(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5802,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_check_string_2(t2,((C_word*)t0)[2]));}

/* k5771 in k5768 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5773,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5778,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=lf[579],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5784,a[2]=((C_word*)t0)[3],a[3]=lf[580],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 2064 ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a5783 in k5771 in k5768 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5784(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5784,6,t0,t1,t2,t3,t4,t5);}
if(C_truep(((C_word*)t0)[2])){
/* posixunix.scm: 2067 values */
C_values(6,0,t1,t2,t3,t4,t5);}
else{
/* posixunix.scm: 2068 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a5777 in k5771 in k5768 in %process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5778(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5778,2,t0,t1);}
/* posixunix.scm: 2065 ##sys#process */
t2=*((C_word*)lf[575]+1);
((C_proc9)(void*)(*((C_word*)t2+1)))(9,t2,t1,((C_word*)t0)[6],((C_word*)((C_word*)t0)[5])[1],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[3],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t0)[2]);}

/* ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5707(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8){
C_word tmp;
C_word t9;
C_word t10;
C_word t11;
C_word ab[21],*a=ab;
if(c!=9) C_bad_argc_2(c,9,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr9,(void*)f_5707,9,t0,t1,t2,t3,t4,t5,t6,t7,t8);}
t9=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5713,a[2]=t8,a[3]=t7,a[4]=t6,a[5]=t5,a[6]=t4,a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=lf[576],tmp=(C_word)a,a+=10,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5719,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=t8,a[8]=t6,a[9]=t7,a[10]=lf[577],tmp=(C_word)a,a+=11,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t9,t10);}

/* a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5719(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[26],*a=ab;
if(c!=6) C_bad_argc_2(c,6,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr6,(void*)f_5719,6,t0,t1,t2,t3,t4,t5);}
t6=(C_word)C_i_not(((C_word*)t0)[9]);
t7=(C_word)C_i_not(((C_word*)t0)[8]);
t8=(C_word)C_i_not(((C_word*)t0)[7]);
t9=(C_word)C_a_i_vector(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5730,a[2]=((C_word*)t0)[8],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t9,a[6]=((C_word*)t0)[3],a[7]=((C_word*)t0)[7],a[8]=t4,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word*)t0)[6],a[12]=t5,a[13]=t1,tmp=(C_word)a,a+=14,tmp);
t11=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5750,a[2]=((C_word*)t0)[9],a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t10,a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2040 make-on-close */
t12=((C_word*)t0)[3];
f_5533(t12,t11,((C_word*)t0)[5],t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k5748 in a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5750(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2039 input-port */
t2=((C_word*)t0)[7];
f_5685(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5728 in a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5730(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[20],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5730,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_5734,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[9],a[7]=((C_word*)t0)[10],a[8]=((C_word*)t0)[11],a[9]=((C_word*)t0)[12],a[10]=t1,a[11]=((C_word*)t0)[13],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5746,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[10],a[6]=t2,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2042 make-on-close */
t4=((C_word*)t0)[6];
f_5533(t4,t3,((C_word*)t0)[10],((C_word*)t0)[12],((C_word*)t0)[5],C_fix(1),C_fix(0),C_fix(2));}

/* k5744 in k5728 in a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5746(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2041 output-port */
t2=((C_word*)t0)[7];
f_5696(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5732 in k5728 in a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5734(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5734,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5738,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[11],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5742,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 2045 make-on-close */
t4=((C_word*)t0)[3];
f_5533(t4,t3,((C_word*)t0)[7],((C_word*)t0)[9],((C_word*)t0)[2],C_fix(2),C_fix(0),C_fix(1));}

/* k5740 in k5732 in k5728 in a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2044 input-port */
t2=((C_word*)t0)[7];
f_5685(t2,((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* k5736 in k5732 in k5728 in a5718 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5738(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2038 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* a5712 in ##sys#process in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5713,2,t0,t1);}
/* posixunix.scm: 2033 child */
t2=((C_word*)t0)[8];
f_5624(t2,t1,((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5696(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5696,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5700,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2029 connect-parent */
t8=((C_word*)t0)[2];
f_5590(t8,t7,t4,t5);}

/* k5698 in output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2030 ##sys#custom-output-port */
t2=*((C_word*)lf[392]+1);
((C_proc7)C_retrieve_proc(t2))(7,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_fix(0),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5685(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5685,NULL,7,t0,t1,t2,t3,t4,t5,t6);}
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5689,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 2025 connect-parent */
t8=((C_word*)t0)[2];
f_5590(t8,t7,t4,t5);}

/* k5687 in input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5689(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
/* posixunix.scm: 2026 ##sys#custom-input-port */
t2=*((C_word*)lf[368]+1);
((C_proc7)C_retrieve_proc(t2))(7,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],t1,C_fix(256),((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5624(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5624,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5628,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t6,a[5]=t5,a[6]=t7,a[7]=((C_word*)t0)[4],a[8]=t4,a[9]=t3,a[10]=t2,a[11]=((C_word*)t0)[5],a[12]=t1,tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2009 needed-pipe */
t9=((C_word*)t0)[2];
f_5570(t9,t8,t6);}

/* k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5628(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5628,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5631,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],a[12]=t1,a[13]=((C_word*)t0)[12],tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2010 needed-pipe */
t3=((C_word*)t0)[2];
f_5570(t3,t2,((C_word*)t0)[5]);}

/* k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5631(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5631,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|13,a[1]=(C_word)f_5634,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],a[9]=((C_word*)t0)[10],a[10]=((C_word*)t0)[11],a[11]=((C_word*)t0)[12],a[12]=((C_word*)t0)[13],a[13]=t1,tmp=(C_word)a,a+=14,tmp);
/* posixunix.scm: 2011 needed-pipe */
t3=((C_word*)t0)[2];
f_5570(t3,t2,((C_word*)t0)[6]);}

/* k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[27],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5634,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5635,a[2]=lf[570],tmp=(C_word)a,a+=3,tmp);
t3=f_5635(C_a_i(&a,3),((C_word*)t0)[13]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5661,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[12],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_5663,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[13],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[11],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,a[9]=t2,a[10]=((C_word*)t0)[7],a[11]=((C_word*)t0)[8],a[12]=((C_word*)t0)[9],a[13]=((C_word*)t0)[10],a[14]=lf[571],tmp=(C_word)a,a+=15,tmp);
/* posixunix.scm: 2017 process-fork */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t4,t5);}

/* a5662 in k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5663(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[13],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5663,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_5667,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],a[11]=t1,a[12]=((C_word*)t0)[13],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm: 2019 connect-child */
t3=((C_word*)t0)[7];
f_5607(t3,t2,((C_word*)t0)[3],((C_word*)t0)[2],*((C_word*)lf[339]+1));}

/* k5665 in a5662 in k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5667(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5667,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_5670,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=((C_word*)t0)[11],a[10]=((C_word*)t0)[12],tmp=(C_word)a,a+=11,tmp);
t3=f_5635(C_a_i(&a,3),((C_word*)t0)[3]);
/* posixunix.scm: 2020 connect-child */
t4=((C_word*)t0)[5];
f_5607(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[340]+1));}

/* k5668 in k5665 in a5662 in k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5670(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5670,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5673,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=((C_word*)t0)[9],a[6]=((C_word*)t0)[10],tmp=(C_word)a,a+=7,tmp);
t3=f_5635(C_a_i(&a,3),((C_word*)t0)[4]);
/* posixunix.scm: 2021 connect-child */
t4=((C_word*)t0)[3];
f_5607(t4,t2,t3,((C_word*)t0)[2],*((C_word*)lf[341]+1));}

/* k5671 in k5668 in k5665 in a5662 in k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5673(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2022 process-execute */
t2=((C_word*)t0)[6];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* k5659 in k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5661(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 2015 values */
C_values(6,0,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* swap-ends in k5632 in k5629 in k5626 in child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_5635(C_word *a,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_check;
if(C_truep(t1)){
t2=(C_word)C_i_cdr(t1);
t3=(C_word)C_i_car(t1);
return((C_word)C_a_i_cons(&a,2,t2,t3));}
else{
return(C_SCHEME_FALSE);}}

/* connect-child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5607(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5607,NULL,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=(C_word)C_i_car(t2);
t6=(C_word)C_i_cdr(t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5620,a[2]=t5,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 2004 file-close */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* k5618 in connect-child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5620,2,t0,t1);}
t2=((C_word*)t0)[4];
t3=((C_word*)t0)[3];
t4=(C_word)C_eqp(t3,((C_word*)t0)[2]);
if(C_truep(t4)){
t5=t2;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5529,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1977 duplicate-fileno */
t6=*((C_word*)lf[363]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,((C_word*)t0)[2],t3);}}

/* k5527 in k5618 in connect-child in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5529(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1978 file-close */
t2=*((C_word*)lf[60]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* connect-parent in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5590(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5590,NULL,4,t0,t1,t2,t3);}
if(C_truep(t3)){
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5603,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1997 file-close */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_FALSE);}}

/* k5601 in connect-parent in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5603(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5603,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5606,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1998 ##sys#file-nonblocking! */
t3=*((C_word*)lf[10]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k5604 in k5601 in connect-parent in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5606(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* needed-pipe in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5570(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5570,NULL,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5579,a[2]=((C_word*)t0)[2],a[3]=lf[565],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5585,a[2]=lf[566],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1992 ##sys#call-with-values */
C_call_with_values(4,0,t1,t3,t4);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_FALSE);}}

/* a5584 in needed-pipe in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5585(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word ab[3],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5585,4,t0,t1,t2,t3);}
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_a_i_cons(&a,2,t2,t3));}

/* a5578 in needed-pipe in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5579(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5579,2,t0,t1);}
/* posixunix.scm: 1992 create-pipe */
t2=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t2))(2,t2,t1);}

/* make-on-close in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5533(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5533,NULL,8,t0,t1,t2,t3,t4,t5,t6,t7);}
t8=t1;
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5535,a[2]=t2,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t7,a[6]=t6,a[7]=t5,a[8]=t4,a[9]=lf[563],tmp=(C_word)a,a+=10,tmp));}

/* f_5535 in make-on-close in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5535(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5535,2,t0,t1);}
t2=(C_word)C_i_vector_set(((C_word*)t0)[8],((C_word*)t0)[7],C_SCHEME_TRUE);
t3=(C_word)C_i_vector_ref(((C_word*)t0)[8],((C_word*)t0)[6]);
t4=(C_truep(t3)?(C_word)C_i_vector_ref(((C_word*)t0)[8],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5550,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=lf[560],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5556,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=lf[562],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1985 ##sys#call-with-values */
C_call_with_values(4,0,t1,t5,t6);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* a5555 */
static void C_ccall f_5556(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5556,5,t0,t1,t2,t3,t4);}
if(C_truep(t3)){
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1987 ##sys#signal-hook */
t5=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t5+1)))(7,t5,t1,lf[218],((C_word*)t0)[3],lf[561],((C_word*)t0)[2],t4);}}

/* a5549 */
static void C_ccall f_5550(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5550,2,t0,t1);}
/* posixunix.scm: 1985 process-wait */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* process-run in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5477(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5477r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5477r(t0,t1,t2,t3);}}

static void C_ccall f_5477r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5484,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1941 process-fork */
t7=((C_word*)t0)[2];
((C_proc2)C_retrieve_proc(t7))(2,t7,t6);}

/* k5482 in process-run in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5484(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5484,2,t0,t1);}
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
if(C_truep(((C_word*)t0)[5])){
/* posixunix.scm: 1943 process-execute */
t3=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t3))(4,t3,((C_word*)t0)[3],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5503,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1945 ##sys#shell-command */
t4=*((C_word*)lf[550]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}}

/* k5501 in k5482 in process-run in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5503(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5503,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5507,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1945 ##sys#shell-command-arguments */
t3=*((C_word*)lf[555]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[2]);}

/* k5505 in k5501 in k5482 in process-run in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5507(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1945 process-execute */
t2=((C_word*)t0)[4];
((C_proc4)C_retrieve_proc(t2))(4,t2,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* ##sys#shell-command-arguments in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5471(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5471,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_a_i_list(&a,2,lf[556],t2));}

/* ##sys#shell-command in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5462(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5462,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5466,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1930 getenv */
t3=*((C_word*)lf[552]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,lf[553]);}

/* k5464 in ##sys#shell-command in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5466(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_truep(t1)?t1:lf[551]));}

/* process-signal in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5435(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_5435r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_5435r(t0,t1,t2,t3);}}

static void C_ccall f_5435r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=(C_word)C_notvemptyp(t3);
t5=(C_truep(t4)?(C_word)C_i_vector_ref(t3,C_fix(0)):C_fix((C_word)SIGTERM));
t6=(C_word)C_i_check_exact_2(t2,lf[547]);
t7=(C_word)C_i_check_exact_2(t5,lf[547]);
t8=(C_word)C_kill(t2,t5);
t9=(C_word)C_eqp(t8,C_fix(-1));
if(C_truep(t9)){
/* posixunix.scm: 1925 posix-error */
t10=lf[3];
f_1429(7,t10,t1,lf[218],lf[547],lf[548],t2,t5);}
else{
t10=t1;
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,C_SCHEME_UNDEFINED);}}

/* sleep in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5428(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5428,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub976(C_SCHEME_UNDEFINED,t3));}

/* parent-process-id in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5425(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5425,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub973(C_SCHEME_UNDEFINED));}

/* current-process-id in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5422(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5422,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)stub971(C_SCHEME_UNDEFINED));}

/* process-wait in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5344(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr2r,(void*)f_5344r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_5344r(t0,t1,t2);}}

static void C_ccall f_5344r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a=C_alloc(9);
t3=(C_word)C_i_nullp(t2);
t4=(C_truep(t3)?C_SCHEME_FALSE:(C_word)C_i_car(t2));
t5=(C_word)C_i_nullp(t2);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t2));
t7=(C_word)C_i_nullp(t6);
t8=(C_truep(t7)?C_SCHEME_FALSE:(C_word)C_i_car(t6));
t9=(C_word)C_i_nullp(t6);
t10=(C_truep(t9)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t6));
if(C_truep((C_word)C_i_nullp(t10))){
t11=(C_truep(t4)?t4:C_fix(-1));
t12=(C_word)C_i_check_exact_2(t11,lf[536]);
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5374,a[2]=t8,a[3]=t11,a[4]=lf[537],tmp=(C_word)a,a+=5,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5380,a[2]=t11,a[3]=lf[539],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1909 ##sys#call-with-values */
C_call_with_values(4,0,t1,t13,t14);}
else{
/* ##sys#error */
t11=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}

/* a5379 in process-wait in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5380(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_5380,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm: 1911 posix-error */
t6=lf[3];
f_1429(6,t6,t1,lf[218],lf[536],lf[538],((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1912 values */
C_values(5,0,t1,t2,t3,t4);}}

/* a5373 in process-wait in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5374(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5374,2,t0,t1);}
/* posixunix.scm: 1909 ##sys#process-wait */
t2=*((C_word*)lf[534]+1);
((C_proc4)C_retrieve_proc(t2))(4,t2,t1,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#process-wait in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5327(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_5327,4,t0,t1,t2,t3);}
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=(C_word)C_waitpid(t2,t4);
t6=(C_word)C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=(C_truep(t6)?(C_word)C_WEXITSTATUS(C_fix((C_word)C_wait_status)):(C_truep((C_word)C_WIFSIGNALED(C_fix((C_word)C_wait_status)))?(C_word)C_WTERMSIG(C_fix((C_word)C_wait_status)):(C_word)C_WSTOPSIG(C_fix((C_word)C_wait_status))));
/* posixunix.scm: 1896 values */
C_values(5,0,t1,t5,t6,t7);}

/* process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5148(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+15)){
C_save_and_reclaim((void*)tr3r,(void*)f_5148r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_5148r(t0,t1,t2,t3);}}

static void C_ccall f_5148r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(15);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5150,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=lf[530],tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5274,a[2]=t4,a[3]=lf[531],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5279,a[2]=t5,a[3]=lf[532],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
/* def-arglist912946 */
t7=t6;
f_5279(t7,t1);}
else{
t7=(C_word)C_i_car(t3);
t8=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t8))){
/* def-envlist913944 */
t9=t5;
f_5274(t9,t1,t7);}
else{
t9=(C_word)C_i_car(t8);
t10=(C_word)C_i_cdr(t8);
if(C_truep((C_word)C_i_nullp(t10))){
/* body910915 */
t11=t4;
f_5150(t11,t1,t7,t9);}
else{
/* ##sys#error */
t11=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t11+1)))(4,t11,t1,lf[0],t10);}}}}

/* def-arglist912 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5279(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5279,NULL,2,t0,t1);}
/* def-envlist913944 */
t2=((C_word*)t0)[2];
f_5274(t2,t1,C_SCHEME_END_OF_LIST);}

/* def-envlist913 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5274(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5274,NULL,3,t0,t1,t2);}
/* body910915 */
t3=((C_word*)t0)[2];
f_5150(t3,t1,t2,C_SCHEME_FALSE);}

/* body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5150(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5150,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(((C_word*)t0)[5],lf[526]);
t5=(C_word)C_i_check_list_2(t2,lf[526]);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5160,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t3,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 1865 pathname-strip-directory */
t7=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t7))(3,t7,t6,((C_word*)t0)[5]);}

/* k5158 in body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5160(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5160,2,t0,t1);}
t2=(C_word)C_block_size(t1);
t3=f_5110(C_fix(0),t1,t2);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5168,a[2]=t5,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=lf[529],tmp=(C_word)a,a+=8,tmp));
t7=((C_word*)t5)[1];
f_5168(t7,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(1));}

/* do919 in k5158 in body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5168(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(9);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_5168,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=f_5110(t3,C_SCHEME_FALSE,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5181,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5211,a[2]=((C_word*)t0)[3],a[3]=lf[528],tmp=(C_word)a,a+=4,tmp);
t7=t5;
f_5181(t7,f_5211(t6,((C_word*)t0)[5],C_fix(0)));}
else{
t6=t5;
f_5181(t6,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_check_string_2(t4,lf[526]);
t6=(C_word)C_block_size(t4);
t7=f_5110(t3,t4,t6);
t8=(C_word)C_i_cdr(t2);
t9=(C_word)C_fixnum_plus(t3,C_fix(1));
t14=t1;
t15=t8;
t16=t9;
t1=t14;
t2=t15;
t3=t16;
goto loop;}}

/* do923 in do919 in k5158 in body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_5211(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
loop:
C_stack_check;
if(C_truep((C_word)C_i_nullp(t1))){
return(f_5129(t2,C_SCHEME_FALSE,C_fix(0)));}
else{
t3=(C_word)C_i_car(t1);
t4=(C_word)C_i_check_string_2(t3,lf[526]);
t5=(C_word)C_block_size(t3);
t6=f_5129(t2,t3,t5);
t7=(C_word)C_i_cdr(t1);
t8=(C_word)C_fixnum_plus(t2,C_fix(1));
t10=t7;
t11=t8;
t1=t10;
t2=t11;
goto loop;}}

/* k5179 in do919 in k5158 in body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5181(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5181,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5184,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5206,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1878 ##sys#expand-home-path */
t4=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k5204 in k5179 in do919 in k5158 in body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5206(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1878 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k5182 in k5179 in do919 in k5158 in body910 in process-execute in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5184(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_truep(((C_word*)t0)[4])?(C_word)C_execve(t1):(C_word)C_execvp(t1));
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)stub891(C_SCHEME_UNDEFINED);
t5=(C_word)stub903(C_SCHEME_UNDEFINED);
/* posixunix.scm: 1885 posix-error */
t6=lf[3];
f_1429(6,t6,((C_word*)t0)[3],lf[218],lf[526],lf[527],((C_word*)t0)[2]);}
else{
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* setenv in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_5129(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub896(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* setarg in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_5110(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_check;
t4=(C_word)C_i_foreign_fixnum_argumentp(t1);
t5=(C_truep(t2)?(C_word)C_i_foreign_block_argumentp(t2):C_SCHEME_FALSE);
t6=(C_word)C_i_foreign_fixnum_argumentp(t3);
return((C_word)stub884(C_SCHEME_UNDEFINED,t4,t5,t6));}

/* process-fork in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5068(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+3)){
C_save_and_reclaim((void*)tr2rv,(void*)f_5068r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_5068r(t0,t1,t2);}}

static void C_ccall f_5068r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a=C_alloc(3);
t3=(C_word)stub867(C_SCHEME_UNDEFINED);
t4=(C_word)C_eqp(C_fix(-1),t3);
if(C_truep(t4)){
/* posixunix.scm: 1850 posix-error */
t5=lf[3];
f_1429(5,t5,t1,lf[218],lf[519],lf[520]);}
else{
t5=(C_word)C_notvemptyp(t2);
t6=(C_truep(t5)?(C_word)C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5090,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t8=(C_word)C_i_vector_ref(t2,C_fix(0));
t9=t8;
((C_proc2)C_retrieve_proc(t9))(2,t9,t7);}
else{
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t3);}}}

/* k5088 in process-fork in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5090(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5090,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5094,a[2]=lf[521],tmp=(C_word)a,a+=3,tmp);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],C_fix(0));}

/* f_5094 in k5088 in process-fork in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5094(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_5094,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub872(C_SCHEME_UNDEFINED,t3));}

/* glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4962(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+10)){
C_save_and_reclaim((void*)tr2r,(void*)f_4962r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_4962r(t0,t1,t2);}}

static void C_ccall f_4962r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(10);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4968,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t4,a[6]=((C_word*)t0)[5],a[7]=lf[517],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_4968(t6,t1,t2);}

/* conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4968(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4968,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_i_car(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4983,a[2]=t3,a[3]=((C_word*)t0)[6],a[4]=lf[511],tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4989,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t2,a[7]=lf[516],tmp=(C_word)a,a+=8,tmp);
/* ##sys#call-with-values */
C_call_with_values(4,0,t1,t4,t5);}}

/* a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4989(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_4989,5,t0,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4993,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5060,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_truep(t3)?t3:lf[515]);
/* posixunix.scm: 1834 make-pathname */
t8=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t8))(5,t8,t6,C_SCHEME_FALSE,t7,t4);}

/* k5058 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5060(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1834 glob->regexp */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,((C_word*)t0)[2],t1);}

/* k4991 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4993(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4993,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5000,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
t3=(C_truep(((C_word*)t0)[4])?((C_word*)t0)[4]:lf[514]);
/* posixunix.scm: 1835 directory */
t4=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,t3,C_SCHEME_TRUE);}

/* k4998 in k4991 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5000,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_5002,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=lf[513],tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];
f_5002(t5,((C_word*)t0)[2],t1);}

/* loop in k4998 in k4991 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_5002(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_5002,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_i_nullp(t2))){
t3=(C_word)C_i_cdr(((C_word*)t0)[7]);
/* posixunix.scm: 1836 conc */
t4=((C_word*)((C_word*)t0)[6])[1];
f_4968(t4,t1,t3);}
else{
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_5019,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t2,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
t4=(C_word)C_i_car(t2);
/* posixunix.scm: 1837 string-match */
t5=*((C_word*)lf[512]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,((C_word*)t0)[2],t4);}}

/* k5017 in loop in k4998 in k4991 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5019(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5019,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5029,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t3=(C_word)C_i_car(t1);
/* posixunix.scm: 1838 make-pathname */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t2,((C_word*)t0)[2],t3);}
else{
t2=(C_word)C_i_cdr(((C_word*)t0)[5]);
/* posixunix.scm: 1839 loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_5002(t3,((C_word*)t0)[6],t2);}}

/* k5027 in k5017 in loop in k4998 in k4991 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5029,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5033,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_cdr(((C_word*)t0)[3]);
/* posixunix.scm: 1838 loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_5002(t4,t2,t3);}

/* k5031 in k5027 in k5017 in loop in k4998 in k4991 in a4988 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_5033(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_5033,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* a4982 in conc in glob in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4983(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4983,2,t0,t1);}
/* posixunix.scm: 1833 decompose-pathname */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* get-host-name in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4950(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[8],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4950,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4954,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t4=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,(C_word)stub830(t3),C_fix(0));}

/* k4952 in get-host-name in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4954(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4954,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4957,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_4957(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1817 posix-error */
t3=lf[3];
f_1429(5,t3,t2,lf[504],lf[503],lf[505]);}}

/* k4955 in k4952 in get-host-name in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4957(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* terminal-name in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4920(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4920,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4924,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1803 ##sys#check-port */
t4=*((C_word*)lf[163]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[500]);}

/* k4922 in terminal-name in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4924(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4924,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4927,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_slot(((C_word*)t0)[2],C_fix(7));
t4=(C_word)C_eqp(lf[115],t3);
t5=(C_truep(t4)?(C_word)C_tty_portp(((C_word*)t0)[2]):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t2;
f_4927(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1806 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t2,lf[500],lf[501],((C_word*)t0)[2]);}}

/* k4925 in k4922 in terminal-name in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4927(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4927,2,t0,t1);}
t2=((C_word*)t0)[3];
t3=(C_word)C_C_fileno(((C_word*)t0)[2]);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=(C_word)stub822(t4,t5);
/* ##sys#peek-nonnull-c-string */
t7=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t2,t6,C_fix(0));}

/* terminal-port? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4891(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4891,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4895,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1796 ##sys#check-port */
t4=*((C_word*)lf[163]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[498]);}

/* k4893 in terminal-port? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4895(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4895,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4898,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1797 ##sys#peek-unsigned-integer */
t3=*((C_word*)lf[361]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,((C_word*)t0)[2],C_fix(0));}

/* k4896 in k4893 in terminal-port? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4898(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(t1,C_fix(0));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_truep(t2)?C_SCHEME_FALSE:(C_word)C_tty_portp(((C_word*)t0)[2])));}

/* set-buffering-mode! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4832(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_4832r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_4832r(t0,t1,t2,t3,t4);}}

static void C_ccall f_4832r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4836,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1778 ##sys#check-port */
t6=*((C_word*)lf[163]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t5,t2,lf[491]);}

/* k4834 in set-buffering-mode! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4836(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4836,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):C_fix((C_word)BUFSIZ));
t4=((C_word*)t0)[4];
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4842,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t4,lf[493]);
if(C_truep(t6)){
t7=t5;
f_4842(2,t7,C_fix((C_word)_IOFBF));}
else{
t7=(C_word)C_eqp(t4,lf[494]);
if(C_truep(t7)){
t8=t5;
f_4842(2,t8,C_fix((C_word)_IOLBF));}
else{
t8=(C_word)C_eqp(t4,lf[495]);
if(C_truep(t8)){
t9=t5;
f_4842(2,t9,C_fix((C_word)_IONBF));}
else{
/* posixunix.scm: 1784 ##sys#error */
t9=*((C_word*)lf[53]+1);
((C_proc6)(void*)(*((C_word*)t9+1)))(6,t9,t5,lf[491],lf[496],((C_word*)t0)[4],((C_word*)t0)[3]);}}}}

/* k4840 in k4834 in set-buffering-mode! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4842(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[491]);
t3=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t4=(C_word)C_eqp(lf[115],t3);
t5=(C_truep(t4)?(C_word)C_setvbuf(((C_word*)t0)[3],t1,((C_word*)t0)[4]):C_fix(-1));
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm: 1790 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc7)(void*)(*((C_word*)t6+1)))(7,t6,((C_word*)t0)[2],lf[491],lf[492],((C_word*)t0)[3],t1,((C_word*)t0)[4]);}
else{
t6=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* set-alarm! in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4825(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4825,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub805(C_SCHEME_UNDEFINED,t3));}

/* _exit in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4806(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2rv,(void*)f_4806r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest_vector(a,C_rest_count(0));
f_4806r(t0,t1,t2);}}

static void C_ccall f_4806r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4810,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1766 ##sys#cleanup-before-exit */
t4=*((C_word*)lf[487]+1);
((C_proc2)C_retrieve_proc(t4))(2,t4,t3);}

/* k4808 in _exit in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4810(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
t2=(C_word)C_notvemptyp(((C_word*)t0)[3]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[3],C_fix(0)):C_fix(0));
t4=((C_word*)t0)[2];
t5=(C_word)C_i_foreign_fixnum_argumentp(t3);
t6=t4;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,(C_word)stub799(C_SCHEME_UNDEFINED,t5));}

/* local-timezone-abbreviation in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4794(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4794,2,t0,t1);}
t2=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,(C_word)stub794(t2),C_fix(0));}

/* utc-time->seconds in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4766(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4766,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[480]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4773,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1744 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[480],lf[482],t2);}
else{
t6=t4;
f_4773(2,t6,C_SCHEME_UNDEFINED);}}

/* k4771 in utc-time->seconds in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4773(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_timegm(((C_word*)t0)[3]))){
/* posixunix.scm: 1746 ##sys#cons-flonum */
t2=*((C_word*)lf[476]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1747 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[480],lf[481],((C_word*)t0)[3]);}}

/* local-time->seconds in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4738(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4738,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[475]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4745,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1737 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[475],lf[478],t2);}
else{
t6=t4;
f_4745(2,t6,C_SCHEME_UNDEFINED);}}

/* k4743 in local-time->seconds in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4745(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_mktime(((C_word*)t0)[3]))){
/* posixunix.scm: 1739 ##sys#cons-flonum */
t2=*((C_word*)lf[476]+1);
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}
else{
/* posixunix.scm: 1740 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[2],lf[475],lf[477],((C_word*)t0)[3]);}}

/* time->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4710(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4710,3,t0,t1,t2);}
t3=(C_word)C_i_check_vector_2(t2,lf[471]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4717,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(C_word)C_block_size(t2);
if(C_truep((C_word)C_fixnum_lessp(t5,C_fix(10)))){
/* posixunix.scm: 1730 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t4,lf[471],lf[473],t2);}
else{
t6=t4;
f_4717(2,t6,C_SCHEME_UNDEFINED);}}

/* k4715 in time->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4717(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4717,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4720,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=((C_word*)t0)[2];
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
/* ##sys#peek-c-string */
t5=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t2,(C_word)stub779(t4,t3),C_fix(0));}

/* k4718 in k4715 in time->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4720(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4720,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4723,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_4723(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1732 ##sys#error */
t3=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[471],lf[472],((C_word*)t0)[2]);}}

/* k4721 in k4718 in k4715 in time->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4723(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4693(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4693,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4697,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_integer_argumentp(t4);
t7=(C_word)stub770(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k4695 in seconds->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4697(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4697,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4700,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
t3=t2;
f_4700(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1723 ##sys#error */
t3=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,t2,lf[468],lf[469],((C_word*)t0)[2]);}}

/* k4698 in k4695 in seconds->string in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4700(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* seconds->utc-time in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4674(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4674,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[466]);
/* posixunix.scm: 1717 ##sys#decode-seconds */
t4=*((C_word*)lf[464]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_TRUE);}

/* seconds->local-time in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4665(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4665,3,t0,t1,t2);}
t3=(C_word)C_i_check_number_2(t2,lf[463]);
/* posixunix.scm: 1713 ##sys#decode-seconds */
t4=*((C_word*)lf[464]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t1,t2,C_SCHEME_FALSE);}

/* memory-mapped-file? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4659(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4659,3,t0,t1,t2);}
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_i_structurep(t2,lf[450]));}

/* memory-mapped-file-pointer in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4650(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4650,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[450],lf[459]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(t2,C_fix(1)));}

/* unmap-file-from-memory in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4615(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+0)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4615r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4615r(t0,t1,t2,t3);}}

static void C_ccall f_4615r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
t4=(C_word)C_i_check_structure_2(t2,lf[450],lf[456]);
t5=(C_word)C_notvemptyp(t3);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t3,C_fix(0)):(C_word)C_slot(t2,C_fix(2)));
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_truep(t7)?(C_word)C_i_foreign_pointer_argumentp(t7):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t6);
t10=(C_word)stub739(C_SCHEME_UNDEFINED,t8,t9);
t11=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t11)){
t12=t1;
((C_proc2)(void*)(*((C_word*)t12+1)))(2,t12,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1700 posix-error */
t12=lf[3];
f_1429(7,t12,t1,lf[51],lf[456],lf[457],t2,t6);}}

/* map-file-to-memory in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4553(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,...){
C_word tmp;
C_word t7;
va_list v;
C_word *a,c2=c;
C_save_rest(t6,c2,7);
if(c<7) C_bad_min_argc_2(c,7,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr7rv,(void*)f_4553r,7,t0,t1,t2,t3,t4,t5,t6);}
else{
a=C_alloc((c-7)*3);
t7=C_restore_rest_vector(a,C_rest_count(0));
f_4553r(t0,t1,t2,t3,t4,t5,t6,t7);}}

static void C_ccall f_4553r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(8);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4557,a[2]=t1,a[3]=t6,a[4]=t5,a[5]=t4,a[6]=t3,a[7]=t7,tmp=(C_word)a,a+=8,tmp);
t9=t2;
if(C_truep(t9)){
t10=t8;
f_4557(2,t10,t2);}
else{
/* posixunix.scm: 1685 ##sys#null-pointer */
t10=*((C_word*)lf[454]+1);
((C_proc2)(void*)(*((C_word*)t10+1)))(2,t10,t8);}}

/* k4555 in map-file-to-memory in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4557(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4557,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[7]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[7],C_fix(0)):C_fix(0));
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4563,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t5=(C_truep((C_word)C_blockp(t1))?(C_word)C_specialp(t1):C_SCHEME_FALSE);
if(C_truep(t5)){
t6=t4;
f_4563(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1688 ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t6+1)))(6,t6,t4,lf[66],lf[449],lf[453],t1);}}

/* k4561 in k4555 in map-file-to-memory in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4563(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word ab[19],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4563,2,t0,t1);}
t2=((C_word*)t0)[8];
t3=((C_word*)t0)[7];
t4=((C_word*)t0)[6];
t5=((C_word*)t0)[5];
t6=((C_word*)t0)[4];
t7=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t8=(C_truep(t2)?(C_word)C_i_foreign_pointer_argumentp(t2):C_SCHEME_FALSE);
t9=(C_word)C_i_foreign_integer_argumentp(t3);
t10=(C_word)C_i_foreign_fixnum_argumentp(t4);
t11=(C_word)C_i_foreign_fixnum_argumentp(t5);
t12=(C_word)C_i_foreign_fixnum_argumentp(t6);
t13=(C_word)C_i_foreign_integer_argumentp(((C_word*)t0)[3]);
t14=(C_word)stub714(t7,t8,t9,t10,t11,t12,t13);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4569,a[2]=((C_word*)t0)[7],a[3]=t14,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t16=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4582,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=t15,tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm: 1690 ##sys#pointer->address */
t17=*((C_word*)lf[452]+1);
((C_proc3)(void*)(*((C_word*)t17+1)))(3,t17,t16,t14);}

/* k4580 in k4561 in k4555 in map-file-to-memory in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4582(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1691 posix-error */
t3=lf[3];
f_1429(11,t3,((C_word*)t0)[8],lf[51],lf[449],lf[451],((C_word*)t0)[7],((C_word*)t0)[6],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[8];
f_4569(2,t3,C_SCHEME_UNDEFINED);}}

/* k4567 in k4561 in k4555 in map-file-to-memory in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4569(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4569,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_record(&a,3,lf[450],((C_word*)t0)[3],((C_word*)t0)[2]));}

/* current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4450(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4450,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4456,a[2]=t3,a[3]=lf[438],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_4456(t5,t1,C_fix(0));}

/* loop in current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4456(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4456,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4460,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub692(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k4458 in loop in current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4460(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4460,2,t0,t1);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4468,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=lf[437],tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_4468(t5,((C_word*)t0)[2],C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* scan in k4458 in loop in current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4468(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4468,NULL,3,t0,t1,t2);}
t3=(C_word)C_eqp(C_make_character(61),(C_word)C_subchar(((C_word*)t0)[5],t2));
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4494,a[2]=((C_word*)t0)[5],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1649 ##sys#substring */
t5=*((C_word*)lf[74]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[5],C_fix(0),t2);}
else{
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1652 scan */
t7=t1;
t8=t4;
t1=t7;
t2=t8;
goto loop;}}

/* k4492 in scan in k4458 in loop in current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4494(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4494,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4498,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
t4=(C_word)C_block_size(((C_word*)t0)[2]);
/* posixunix.scm: 1650 ##sys#substring */
t5=*((C_word*)lf[74]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t2,((C_word*)t0)[2],t3,t4);}

/* k4496 in k4492 in scan in k4458 in loop in current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4498(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4498,2,t0,t1);}
t2=(C_word)C_a_i_cons(&a,2,((C_word*)t0)[5],t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4486,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1651 loop */
t5=((C_word*)((C_word*)t0)[2])[1];
f_4456(t5,t3,t4);}

/* k4484 in k4496 in k4492 in scan in k4458 in loop in current-environment in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4486(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4486,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* unsetenv in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4430(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4430,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[434]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4438,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1638 ##sys#make-c-string */
t5=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k4436 in unsetenv in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4438(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_putenv(t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* setenv in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4413(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4413,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[432]);
t5=(C_word)C_i_check_string_2(t3,lf[432]);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4424,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1633 ##sys#make-c-string */
t7=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t7+1)))(3,t7,t6,t2);}

/* k4422 in setenv in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4424(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4424,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4428,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1633 ##sys#make-c-string */
t3=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t3+1)))(3,t3,t2,((C_word*)t0)[2]);}

/* k4426 in k4422 in setenv in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4428(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_setenv(((C_word*)t0)[3],t1);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}

/* fifo? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4387(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4387,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[429]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4394,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4411,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1622 ##sys#expand-home-path */
t6=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k4409 in fifo? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4411(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1622 ##sys#file-info */
t2=*((C_word*)lf[142]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4392 in fifo? in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4394(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(3),t2));}
else{
/* posixunix.scm: 1625 posix-error */
t2=lf[3];
f_1429(6,t2,((C_word*)t0)[3],lf[51],lf[429],lf[430],((C_word*)t0)[2]);}}

/* create-fifo in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4344(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_4344r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_4344r(t0,t1,t2,t3);}}

static void C_ccall f_4344r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_string_2(t2,lf[426]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4351,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_notvemptyp(t3))){
t6=t5;
f_4351(t6,(C_word)C_i_vector_ref(t3,C_fix(0)));}
else{
t6=(C_word)C_fixnum_or(C_fix((C_word)S_IRWXG),C_fix((C_word)S_IRWXO));
t7=t5;
f_4351(t7,(C_word)C_fixnum_or(C_fix((C_word)S_IRWXU),t6));}}

/* k4349 in create-fifo in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4351(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4351,NULL,2,t0,t1);}
t2=(C_word)C_i_check_exact_2(t1,lf[426]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4368,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4372,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1616 ##sys#expand-home-path */
t5=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,((C_word*)t0)[2]);}

/* k4370 in k4349 in create-fifo in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4372(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1616 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4366 in k4349 in create-fifo in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4368(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkfifo(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1617 posix-error */
t3=lf[3];
f_1429(7,t3,((C_word*)t0)[3],lf[51],lf[426],lf[427],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* file-unlock in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4316(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4316,3,t0,t1,t2);}
t3=(C_word)C_i_check_structure_2(t2,lf[411],lf[423]);
t4=(C_word)C_slot(t2,C_fix(2));
t5=(C_word)C_slot(t2,C_fix(3));
t6=(C_word)C_flock_setup(C_fix((C_word)F_UNLCK),t4,t5);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_flock_lock(t7);
if(C_truep((C_word)C_fixnum_lessp(t8,C_fix(0)))){
/* posixunix.scm: 1602 posix-error */
t9=lf[3];
f_1429(6,t9,t1,lf[51],lf[423],lf[424],t2);}
else{
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,C_SCHEME_UNDEFINED);}}

/* file-test-lock in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4294(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4294r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4294r(t0,t1,t2,t3);}}

static void C_ccall f_4294r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4298,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1593 setup */
f_4172(t4,t2,t3,lf[420]);}

/* k4296 in file-test-lock in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4298(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=(C_word)C_flock_test(((C_word*)t0)[4]);
if(C_truep(t2)){
t3=(C_word)C_eqp(t2,C_fix(0));
t4=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_truep(t3)?C_SCHEME_FALSE:t2));}
else{
/* posixunix.scm: 1595 err */
f_4246(((C_word*)t0)[3],lf[421],t1,lf[420]);}}

/* file-lock/blocking in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4279(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4279r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4279r(t0,t1,t2,t3);}}

static void C_ccall f_4279r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4283,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1587 setup */
f_4172(t4,t2,t3,lf[417]);}

/* k4281 in file-lock/blocking in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4283(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lockw(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1589 err */
f_4246(((C_word*)t0)[2],lf[418],t1,lf[417]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* file-lock in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4264(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_4264r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_4264r(t0,t1,t2,t3);}}

static void C_ccall f_4264r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4268,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1581 setup */
f_4172(t4,t2,t3,lf[414]);}

/* k4266 in file-lock in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4268(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_flock_lock(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1583 err */
f_4246(((C_word*)t0)[2],lf[415],t1,lf[414]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,t1);}}

/* err in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4246(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4246,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_slot(t3,C_fix(1));
t6=(C_word)C_slot(t3,C_fix(2));
t7=(C_word)C_slot(t3,C_fix(3));
/* posixunix.scm: 1578 posix-error */
t8=lf[3];
f_1429(8,t8,t1,lf[51],t4,t2,t5,t6,t7);}

/* setup in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4172(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4172,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_nullp(t3);
t6=(C_truep(t5)?C_fix(0):(C_word)C_i_car(t3));
t7=(C_word)C_i_nullp(t3);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t3));
t9=(C_word)C_i_nullp(t8);
t10=(C_truep(t9)?C_SCHEME_TRUE:(C_word)C_i_car(t8));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=(C_word)C_i_nullp(t8);
t14=(C_truep(t13)?C_SCHEME_END_OF_LIST:(C_word)C_i_cdr(t8));
if(C_truep((C_word)C_i_nullp(t14))){
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4194,a[2]=t1,a[3]=t12,a[4]=t2,a[5]=t4,a[6]=t6,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1570 ##sys#check-port */
t16=*((C_word*)lf[163]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t15,t2,t4);}
else{
/* ##sys#error */
t15=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t1,lf[0],t14);}}

/* k4192 in setup in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4194(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4194,2,t0,t1);}
t2=(C_word)C_i_check_number_2(((C_word*)t0)[6],((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4200,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t4=(C_word)C_eqp(C_SCHEME_TRUE,((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t4)){
t5=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t6=t3;
f_4200(t6,t5);}
else{
t5=t3;
f_4200(t5,(C_word)C_i_check_number_2(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[5]));}}

/* k4198 in k4192 in setup in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4200(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4200,NULL,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(1));
t3=(C_truep(t2)?C_fix((C_word)F_RDLCK):C_fix((C_word)F_WRLCK));
t4=(C_word)C_flock_setup(t3,((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,(C_word)C_a_i_record(&a,4,lf[411],((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]));}

/* file-truncate in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4133(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_4133,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_number_2(t3,lf[407]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4150,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4157,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4161,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1553 ##sys#expand-home-path */
t8=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_4150(2,t6,(C_word)C_ftruncate(t2,t3));}
else{
/* posixunix.scm: 1555 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[407],lf[409],t2);}}}

/* k4159 in file-truncate in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4161(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1553 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k4155 in file-truncate in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4157(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_4150(2,t2,(C_word)C_truncate(t1,((C_word*)t0)[2]));}

/* k4148 in file-truncate in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4150(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1557 posix-error */
t2=lf[3];
f_1429(7,t2,((C_word*)t0)[4],lf[51],lf[407],lf[408],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3894(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr5r,(void*)f_3894r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_3894r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_3894r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a=C_alloc(16);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3896,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t2,a[6]=t4,a[7]=lf[402],tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4074,a[2]=t6,a[3]=lf[404],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4085,a[2]=t7,a[3]=lf[405],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-bufi592627 */
t9=t8;
f_4085(t9,t1);}
else{
t9=(C_word)C_i_car(t5);
t10=(C_word)C_i_cdr(t5);
if(C_truep((C_word)C_i_nullp(t10))){
/* def-on-close593625 */
t11=t7;
f_4074(t11,t1,t9);}
else{
t11=(C_word)C_i_car(t10);
t12=(C_word)C_i_cdr(t10);
if(C_truep((C_word)C_i_nullp(t12))){
/* body590595 */
t13=t6;
f_3896(t13,t1,t9,t11);}
else{
/* ##sys#error */
t13=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t13+1)))(4,t13,t1,lf[0],t12);}}}}

/* def-bufi592 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4085(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4085,NULL,2,t0,t1);}
/* def-on-close593625 */
t2=((C_word*)t0)[2];
f_4074(t2,t1,C_fix(0));}

/* def-on-close593 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_4074(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_4074,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4080,a[2]=lf[403],tmp=(C_word)a,a+=3,tmp);
/* body590595 */
t4=((C_word*)t0)[2];
f_3896(t4,t1,t2,t3);}

/* a4079 in def-on-close593 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4080(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4080,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,*((C_word*)lf[386]+1));}

/* body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3896(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word ab[30],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3896,NULL,4,t0,t1,t2,t3);}
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3899,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=t5,a[5]=((C_word*)t0)[6],a[6]=lf[394],tmp=(C_word)a,a+=7,tmp));
t9=(C_word)C_fixnump(t2);
t10=(C_truep(t9)?t2:(C_word)C_block_size(t2));
t11=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_3945,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[3],a[8]=t1,a[9]=t7,tmp=(C_word)a,a+=10,tmp);
t12=(C_word)C_eqp(C_fix(0),t10);
if(C_truep(t12)){
t13=t11;
f_3945(t13,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3989,a[2]=t5,a[3]=lf[399],tmp=(C_word)a,a+=4,tmp));}
else{
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4003,a[2]=t5,a[3]=t10,a[4]=t11,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
/* posixunix.scm: 1511 ##sys#make-string */
t14=*((C_word*)lf[383]+1);
((C_proc3)(void*)(*((C_word*)t14+1)))(3,t14,t13,t2);}
else{
t14=t13;
f_4003(2,t14,t2);}}}

/* k4001 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4003(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_4003,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[4];
f_3945(t4,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4004,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=lf[401],tmp=(C_word)a,a+=7,tmp));}

/* f_4004 in k4001 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_4004(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[11],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_4004,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1]);
t4=(C_word)C_block_size(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4021,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[5],a[6]=t6,a[7]=((C_word*)t0)[4],a[8]=lf[400],tmp=(C_word)a,a+=9,tmp));
t8=((C_word*)t6)[1];
f_4021(t8,t1,t3,C_fix(0),t4);}
else{
if(C_truep((C_word)C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm: 1528 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_3899(t3,t1,((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1]);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}}

/* loop */
static void C_fcall f_4021(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
a=C_alloc(7);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_4021,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4031,a[2]=t4,a[3]=((C_word*)t0)[5],a[4]=t1,a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 1518 poke */
t7=((C_word*)((C_word*)t0)[4])[1];
f_3899(t7,t6,((C_word*)t0)[3],((C_word*)t0)[5]);}
else{
if(C_truep((C_word)C_fixnum_lessp(t2,t4))){
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t2,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_difference(t4,t2);
/* posixunix.scm: 1523 loop */
t13=t1;
t14=C_fix(0);
t15=t2;
t16=t7;
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(C_word)C_substring_copy(((C_word*)t0)[2],((C_word*)t0)[3],t3,t4,((C_word*)((C_word*)t0)[7])[1]);
t7=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[7])[1],t4);
t8=C_mutate(((C_word *)((C_word*)t0)[7])+1,t7);
t9=t1;
((C_proc2)(void*)(*((C_word*)t9+1)))(2,t9,t8);}}}

/* k4029 in loop */
static void C_ccall f_4031(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_set_block_item(((C_word*)t0)[6],0,C_fix(0));
/* posixunix.scm: 1520 loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_4021(t3,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* f_3989 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3989(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3989,3,t0,t1,t2);}
if(C_truep(t2)){
t3=(C_word)C_block_size(t2);
/* posixunix.scm: 1510 poke */
t4=((C_word*)((C_word*)t0)[2])[1];
f_3899(t4,t1,t2,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3945(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[24],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3945,NULL,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[9])+1,t1);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3949,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[7],a[4]=((C_word*)t0)[8],a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3954,a[2]=((C_word*)t0)[9],a[3]=lf[395],tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3960,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t4,a[7]=lf[397],tmp=(C_word)a,a+=8,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3981,a[2]=((C_word*)t0)[9],a[3]=lf[398],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1531 make-output-port */
t9=((C_word*)t0)[2];
((C_proc5)C_retrieve_proc(t9))(5,t9,t5,t6,t7,t8);}

/* a3980 in k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3981,2,t0,t1);}
/* posixunix.scm: 1540 store */
t2=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,C_SCHEME_FALSE);}

/* a3959 in k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3960(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3960,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3970,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1537 posix-error */
t3=lf[3];
f_1429(7,t3,t2,lf[51],((C_word*)t0)[3],lf[396],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_3970(2,t3,C_SCHEME_UNDEFINED);}}}

/* k3968 in a3959 in k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3970(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1538 on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a3953 in k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3954(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3954,3,t0,t1,t2);}
/* posixunix.scm: 1533 store */
t3=((C_word*)((C_word*)t0)[2])[1];
((C_proc3)C_retrieve_proc(t3))(3,t3,t1,t2);}

/* k3947 in k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3949(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3949,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3952,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1541 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k3950 in k3947 in k3943 in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3952(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* poke in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3899(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3899,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_write(((C_word*)t0)[5],t2,t3);
t5=(C_word)C_eqp(C_fix(-1),t4);
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3915,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1500 ##sys#thread-yield! */
t8=*((C_word*)lf[371]+1);
((C_proc2)(void*)(*((C_word*)t8+1)))(2,t8,t7);}
else{
/* posixunix.scm: 1502 posix-error */
t7=lf[3];
f_1429(7,t7,t1,((C_word*)t0)[3],lf[51],lf[393],((C_word*)t0)[5],((C_word*)t0)[2]);}}
else{
if(C_truep((C_word)C_fixnum_lessp(t4,t3))){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3934,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1504 ##sys#substring */
t7=*((C_word*)lf[74]+1);
((C_proc5)(void*)(*((C_word*)t7+1)))(5,t7,t6,t2,t4,t3);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}}

/* k3932 in poke in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3934(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[4]);
/* posixunix.scm: 1504 poke */
t3=((C_word*)((C_word*)t0)[3])[1];
f_3899(t3,((C_word*)t0)[2],t1,t2);}

/* k3913 in poke in body590 in ##sys#custom-output-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3915(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1501 poke */
t2=((C_word*)((C_word*)t0)[5])[1];
f_3899(t2,((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3622(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+20)){
C_save_and_reclaim((void*)tr5r,(void*)f_3622r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_3622r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_3622r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(20);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3624,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t4,a[6]=t2,a[7]=lf[384],tmp=(C_word)a,a+=8,tmp);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3815,a[2]=t6,a[3]=lf[385],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3820,a[2]=t7,a[3]=lf[388],tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3831,a[2]=t8,a[3]=lf[389],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t5))){
/* def-bufi534574 */
t10=t9;
f_3831(t10,t1);}
else{
t10=(C_word)C_i_car(t5);
t11=(C_word)C_i_cdr(t5);
if(C_truep((C_word)C_i_nullp(t11))){
/* def-on-close535572 */
t12=t8;
f_3820(t12,t1,t10);}
else{
t12=(C_word)C_i_car(t11);
t13=(C_word)C_i_cdr(t11);
if(C_truep((C_word)C_i_nullp(t13))){
/* def-more?536569 */
t14=t7;
f_3815(t14,t1,t10,t12);}
else{
t14=(C_word)C_i_car(t13);
t15=(C_word)C_i_cdr(t13);
if(C_truep((C_word)C_i_nullp(t15))){
/* body532538 */
t16=t6;
f_3624(t16,t1,t10,t12,t14);}
else{
/* ##sys#error */
t16=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t16+1)))(4,t16,t1,lf[0],t15);}}}}}

/* def-bufi534 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3831(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3831,NULL,2,t0,t1);}
/* def-on-close535572 */
t2=((C_word*)t0)[2];
f_3820(t2,t1,C_fix(0));}

/* def-on-close535 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3820(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3820,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3826,a[2]=lf[387],tmp=(C_word)a,a+=3,tmp);
/* def-more?536569 */
t4=((C_word*)t0)[2];
f_3815(t4,t1,t2,t3);}

/* a3825 in def-on-close535 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3826(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3826,2,t0,t1);}
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,*((C_word*)lf[386]+1));}

/* def-more?536 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3815(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3815,NULL,4,t0,t1,t2,t3);}
/* body532538 */
t4=((C_word*)t0)[2];
f_3624(t4,t1,t2,t3,C_SCHEME_FALSE);}

/* body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3624(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3624,NULL,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_fixnump(t2);
t6=(C_truep(t5)?(C_word)C_i_fixnum_max(t2,C_fix(1)):(C_word)C_block_size(t2));
t7=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3631,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t4,a[7]=t6,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word*)t0)[6],tmp=(C_word)a,a+=11,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t8=(C_word)C_i_fixnum_max(t2,C_fix(1));
/* posixunix.scm: 1418 ##sys#make-string */
t9=*((C_word*)lf[383]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t7,t8);}
else{
t8=t7;
f_3631(2,t8,t2);}}

/* k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3631(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word ab[59],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3631,2,t0,t1);}
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3632,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[9],a[4]=((C_word*)t0)[10],a[5]=lf[370],tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3647,a[2]=t1,a[3]=t3,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3655,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[10],a[5]=((C_word*)t0)[7],a[6]=t1,a[7]=((C_word*)t0)[9],a[8]=t3,a[9]=t5,a[10]=lf[377],tmp=(C_word)a,a+=11,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3737,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t10,tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3742,a[2]=t8,a[3]=t5,a[4]=t7,a[5]=lf[378],tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3755,a[2]=t6,a[3]=t3,a[4]=t5,a[5]=lf[379],tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_3767,a[2]=((C_word*)t0)[8],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[9],a[5]=((C_word*)t0)[3],a[6]=t10,a[7]=lf[381],tmp=(C_word)a,a+=8,tmp);
t15=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3788,a[2]=t8,a[3]=t7,a[4]=lf[382],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1463 make-input-port */
t16=((C_word*)t0)[2];
((C_proc6)C_retrieve_proc(t16))(6,t16,t11,t12,t13,t14,t15);}

/* a3787 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3788(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3788,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3792,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1478 fetch */
t3=((C_word*)t0)[2];
f_3655(t3,t2);}

/* k3790 in a3787 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3792(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1479 peek */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,f_3647(((C_word*)t0)[2]));}

/* a3766 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3767(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3767,2,t0,t1);}
if(C_truep((C_word)C_slot(((C_word*)((C_word*)t0)[6])[1],C_fix(8)))){
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3777,a[2]=t1,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(((C_word*)t0)[4]),C_fix(0)))){
/* posixunix.scm: 1475 posix-error */
t3=lf[3];
f_1429(7,t3,t2,lf[51],((C_word*)t0)[3],lf[380],((C_word*)t0)[4],((C_word*)t0)[2]);}
else{
t3=t2;
f_3777(2,t3,C_SCHEME_UNDEFINED);}}}

/* k3775 in a3766 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3777(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1476 on-close */
t2=((C_word*)t0)[3];
((C_proc2)C_retrieve_proc(t2))(2,t2,((C_word*)t0)[2]);}

/* a3754 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3755(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3755,2,t0,t1);}
t2=(C_word)C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
/* posixunix.scm: 1471 ready? */
t3=((C_word*)t0)[2];
f_3632(t3,t1);}}

/* a3741 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3742(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[5],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3742,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3746,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1465 fetch */
t3=((C_word*)t0)[2];
f_3655(t3,t2);}

/* k3744 in a3741 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3746(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
t2=f_3647(((C_word*)t0)[4]);
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[3])[1],C_fix(1));
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t5=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t2);}

/* k3735 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3737(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3737,2,t0,t1);}
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3740,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1484 set-port-name! */
t4=((C_word*)t0)[3];
((C_proc4)C_retrieve_proc(t4))(4,t4,t3,((C_word*)((C_word*)t0)[5])[1],((C_word*)t0)[2]);}

/* k3738 in k3735 in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3740(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)((C_word*)t0)[2])[1]);}

/* fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3655(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[14],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3655,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[9])[1],((C_word*)((C_word*)t0)[8])[1]))){
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_3667,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[8],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word*)t0)[5],a[9]=((C_word*)t0)[6],a[10]=((C_word*)t0)[7],a[11]=lf[376],tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];
f_3667(t5,t1);}
else{
t2=t1;
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* loop in fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3667(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3667,NULL,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[10],((C_word*)t0)[9],((C_word*)t0)[8]);
t3=(C_word)C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3683,a[2]=t1,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1440 ##sys#thread-block-for-i/o! */
t6=*((C_word*)lf[372]+1);
((C_proc5)C_retrieve_proc(t6))(5,t6,t5,*((C_word*)lf[373]+1),((C_word*)t0)[10],C_SCHEME_TRUE);}
else{
/* posixunix.scm: 1443 posix-error */
t5=lf[3];
f_1429(7,t5,t1,lf[51],((C_word*)t0)[6],lf[374],((C_word*)t0)[10],((C_word*)t0)[5]);}}
else{
t4=(C_truep(((C_word*)t0)[4])?(C_word)C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_3704,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[8],a[7]=((C_word*)t0)[9],a[8]=((C_word*)t0)[10],a[9]=t1,a[10]=((C_word*)t0)[7],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm: 1447 more? */
t6=((C_word*)t0)[4];
((C_proc2)C_retrieve_proc(t6))(2,t6,t5);}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t6=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}}}

/* k3702 in loop in fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3704,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3707,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1449 ##sys#thread-yield! */
t3=*((C_word*)lf[371]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}
else{
t2=(C_word)C_read(((C_word*)t0)[8],((C_word*)t0)[7],((C_word*)t0)[6]);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3713,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[4],a[4]=t3,a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(((C_word*)t3)[1],C_fix(-1));
if(C_truep(t5)){
t6=(C_word)C_eqp(C_fix((C_word)errno),C_fix((C_word)EWOULDBLOCK));
if(C_truep(t6)){
t7=C_set_block_item(t3,0,C_fix(0));
t8=t4;
f_3713(2,t8,t7);}
else{
/* posixunix.scm: 1455 posix-error */
t7=lf[3];
f_1429(7,t7,t4,lf[51],((C_word*)t0)[3],lf[375],((C_word*)t0)[8],((C_word*)t0)[2]);}}
else{
t6=t4;
f_3713(2,t6,C_SCHEME_UNDEFINED);}}}

/* k3711 in k3702 in loop in fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3713(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
t2=C_mutate(((C_word *)((C_word*)t0)[5])+1,((C_word*)((C_word*)t0)[4])[1]);
t3=C_set_block_item(((C_word*)t0)[3],0,C_fix(0));
t4=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}

/* k3705 in k3702 in loop in fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3707(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1450 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_3667(t2,((C_word*)t0)[2]);}

/* k3681 in loop in fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3683(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3683,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3686,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1441 ##sys#thread-yield! */
t3=*((C_word*)lf[371]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k3684 in k3681 in loop in fetch in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3686(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1442 loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_3667(t2,((C_word*)t0)[2]);}

/* peek in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_3647(C_word t0){
C_word tmp;
C_word t1;
C_word t2;
C_stack_check;
t1=(C_word)C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[3])[1]);
return((C_truep(t1)?C_SCHEME_END_OF_FILE:(C_word)C_subchar(((C_word*)t0)[2],((C_word*)((C_word*)t0)[4])[1])));}

/* ready? in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3632(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3632,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3646,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 1424 ##sys#file-select-one */
t3=*((C_word*)lf[12]+1);
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,((C_word*)t0)[3]);}

/* k3644 in ready? in k3629 in body532 in ##sys#custom-input-port in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3646(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_eqp(C_fix(-1),t1);
if(C_truep(t2)){
/* posixunix.scm: 1425 posix-error */
t3=lf[3];
f_1429(7,t3,((C_word*)t0)[5],lf[51],((C_word*)t0)[4],lf[369],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[5];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* duplicate-fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3595(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr3rv,(void*)f_3595r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest_vector(a,C_rest_count(0));
f_3595r(t0,t1,t2,t3);}}

static void C_ccall f_3595r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(4);
t4=(C_word)C_i_check_exact_2(t2,*((C_word*)lf[363]+1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3602,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_vemptyp(t3))){
t6=t5;
f_3602(t6,(C_word)C_dup(t2));}
else{
t6=(C_word)C_i_vector_ref(t3,C_fix(0));
t7=(C_word)C_i_check_exact_2(t6,lf[363]);
t8=t5;
f_3602(t8,(C_word)C_dup2(t2,t6));}}

/* k3600 in duplicate-fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3602(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3602,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3605,a[2]=t1,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 1407 posix-error */
t3=lf[3];
f_1429(6,t3,t2,lf[51],lf[363],lf[364],((C_word*)t0)[2]);}
else{
t3=t2;
f_3605(2,t3,C_SCHEME_UNDEFINED);}}

/* k3603 in k3600 in duplicate-fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3605(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* port->fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3550(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3550,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3554,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1389 ##sys#check-port */
t4=*((C_word*)lf[163]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[356]);}

/* k3552 in port->fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3554(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3554,2,t0,t1);}
t2=(C_word)C_slot(((C_word*)t0)[3],C_fix(7));
t3=(C_word)C_eqp(lf[357],t2);
if(C_truep(t3)){
/* posixunix.scm: 1390 ##sys#tcp-port->fileno */
t4=*((C_word*)lf[358]+1);
((C_proc3)C_retrieve_proc(t4))(3,t4,((C_word*)t0)[2],((C_word*)t0)[3]);}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3589,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1391 ##sys#peek-unsigned-integer */
t5=*((C_word*)lf[361]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t4,((C_word*)t0)[3],C_fix(0));}}

/* k3587 in k3552 in port->fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3589(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3589,2,t0,t1);}
if(C_truep((C_word)C_i_zerop(t1))){
/* posixunix.scm: 1396 posix-error */
t2=lf[3];
f_1429(6,t2,((C_word*)t0)[3],lf[66],lf[356],lf[359],((C_word*)t0)[2]);}
else{
t2=(C_word)C_C_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3572,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1394 posix-error */
t4=lf[3];
f_1429(6,t4,t3,lf[51],lf[356],lf[360],((C_word*)t0)[2]);}
else{
t4=t3;
f_3572(2,t4,C_SCHEME_UNDEFINED);}}}

/* k3570 in k3587 in k3552 in port->fileno in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3572(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-file* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3536(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3536r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3536r(t0,t1,t2,t3);}}

static void C_ccall f_3536r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[354]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3548,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1385 mode */
f_3470(t5,C_SCHEME_FALSE,t3);}

/* k3546 in open-output-file* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3548(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3548,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1385 check */
f_3507(((C_word*)t0)[2],lf[354],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* open-input-file* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3522(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr3r,(void*)f_3522r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_3522r(t0,t1,t2,t3);}}

static void C_ccall f_3522r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t4=(C_word)C_i_check_exact_2(t2,lf[352]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3534,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1381 mode */
f_3470(t5,C_SCHEME_TRUE,t3);}

/* k3532 in open-input-file* in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3534(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3534,2,t0,t1);}
t2=(C_word)C_fdopen(&a,2,((C_word*)t0)[4],t1);
/* posixunix.scm: 1381 check */
f_3507(((C_word*)t0)[2],lf[352],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* check in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3507(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3507,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 1374 posix-error */
t6=lf[3];
f_1429(6,t6,t1,lf[51],t2,lf[349],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3520,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1375 ##sys#make-port */
t7=*((C_word*)lf[151]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[152]+1),lf[350],lf[115]);}}

/* k3518 in check in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3520(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* mode in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3470(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3470,NULL,3,t1,t2,t3);}
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3478,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_i_pairp(t3))){
t5=(C_word)C_i_car(t3);
t6=(C_word)C_eqp(t5,lf[342]);
if(C_truep(t6)){
t7=t2;
if(C_truep(t7)){
/* posixunix.scm: 1368 ##sys#error */
t8=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t4,lf[343],t5);}
else{
t8=t4;
f_3478(2,t8,lf[344]);}}
else{
/* posixunix.scm: 1369 ##sys#error */
t7=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t4,lf[345],t5);}}
else{
t5=t4;
f_3478(2,t5,(C_truep(t2)?lf[346]:lf[347]));}}

/* k3476 in mode in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3478(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1364 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* file-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3445(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3445,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[335]);
t5=(C_word)C_i_check_string_2(t3,lf[335]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3426,a[2]=t7,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_3426(2,t9,C_SCHEME_FALSE);}}

/* k3424 in file-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3426(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3426,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3430,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[2])){
t3=(C_word)C_i_foreign_string_argumentp(((C_word*)t0)[2]);
/* ##sys#make-c-string */
t4=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t2,t3);}
else{
t3=t2;
f_3430(2,t3,C_SCHEME_FALSE);}}

/* k3428 in k3424 in file-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3430(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)stub463(C_SCHEME_UNDEFINED,((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1349 posix-error */
t3=lf[3];
f_1429(7,t3,((C_word*)t0)[4],lf[51],lf[336],lf[337],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* read-symbolic-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3395(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[9],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3395,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[332]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3403,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3419,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1338 ##sys#expand-home-path */
t6=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k3417 in read-symbolic-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3419(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1338 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3401 in read-symbolic-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3403(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3403,2,t0,t1);}
t2=(C_word)C_readlink(t1,((C_word*)t0)[5]);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3406,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1340 posix-error */
t4=lf[3];
f_1429(6,t4,t3,lf[51],lf[332],lf[333],((C_word*)t0)[2]);}
else{
t4=t3;
f_3406(2,t4,C_SCHEME_UNDEFINED);}}

/* k3404 in k3401 in read-symbolic-link in k3392 in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3406(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1341 substring */
t2=((C_word*)t0)[5];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[2]);}

/* create-symbolic-link in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3357(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3357,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[327]);
t5=(C_word)C_i_check_string_2(t3,lf[327]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3378,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3390,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1326 ##sys#expand-home-path */
t8=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k3388 in create-symbolic-link in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3390(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1326 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3376 in create-symbolic-link in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3378(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3378,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3382,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3386,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1327 ##sys#expand-home-path */
t4=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[2]);}

/* k3384 in k3376 in create-symbolic-link in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3386(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1327 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3380 in k3376 in create-symbolic-link in k3353 in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3382(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_symlink(((C_word*)t0)[5],t1);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1329 posix-error */
t3=lf[3];
f_1429(7,t3,((C_word*)t0)[4],lf[51],lf[328],lf[329],((C_word*)t0)[3],((C_word*)t0)[2]);}
else{
t3=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* set-process-group-id! in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3332(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[5],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3332,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[323]);
t5=(C_word)C_i_check_exact_2(t3,lf[323]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3348,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1304 ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}
else{
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,C_SCHEME_UNDEFINED);}}

/* k3346 in set-process-group-id! in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3348(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1305 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[323],lf[324],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* create-session in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3317(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3317,2,t0,t1);}
t2=(C_word)C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3321,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3327,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1296 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_3321(2,t4,C_SCHEME_UNDEFINED);}}

/* k3325 in create-session in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3327(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1297 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[320],lf[321]);}

/* k3319 in create-session in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3321(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-execute-access? in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3311(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3311,3,t0,t1,t2);}
/* posixunix.scm: 1291 check */
f_3275(t1,t2,C_fix((C_word)X_OK),lf[318]);}

/* file-write-access? in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3305(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3305,3,t0,t1,t2);}
/* posixunix.scm: 1290 check */
f_3275(t1,t2,C_fix((C_word)W_OK),lf[316]);}

/* file-read-access? in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3299(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3299,3,t0,t1,t2);}
/* posixunix.scm: 1289 check */
f_3275(t1,t2,C_fix((C_word)R_OK),lf[314]);}

/* check in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3275(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_3275,NULL,4,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,t4);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3293,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3297,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1286 ##sys#expand-home-path */
t8=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k3295 in check in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1286 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3291 in check in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3293(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3293,2,t0,t1);}
t2=(C_word)C_access(t1,((C_word*)t0)[3]);
t3=(C_word)C_eqp(C_fix(0),t2);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3285,a[2]=t3,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t5=t4;
f_3285(2,t5,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1287 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}}

/* k3283 in k3291 in check in k3271 in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3285(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* set-group-id! in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3256(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3256,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setgid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3266,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1271 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3264 in set-group-id! in k3252 in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3266(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1272 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[305],lf[310],((C_word*)t0)[2]);}

/* set-user-id! in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3237(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3237,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_lessp((C_word)C_setuid(t2),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3247,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1260 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* k3245 in set-user-id! in k3233 in k3229 in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3247(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1261 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[305],lf[306],((C_word*)t0)[2]);}

/* change-file-owner in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3199(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[9],*a=ab;
if(c!=5) C_bad_argc_2(c,5,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr5,(void*)f_3199,5,t0,t1,t2,t3,t4);}
t5=(C_word)C_i_check_string_2(t2,lf[300]);
t6=(C_word)C_i_check_exact_2(t3,lf[300]);
t7=(C_word)C_i_check_exact_2(t4,lf[300]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3223,a[2]=t2,a[3]=t1,a[4]=t4,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3227,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1236 ##sys#expand-home-path */
t10=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}

/* k3225 in change-file-owner in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3227(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1236 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3221 in change-file-owner in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3223(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chown(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1237 posix-error */
t3=lf[3];
f_1429(8,t3,((C_word*)t0)[3],lf[51],lf[300],lf[301],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* change-file-mode in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3172(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[8],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3172,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[297]);
t5=(C_word)C_i_check_exact_2(t3,lf[297]);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3193,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3197,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1228 ##sys#expand-home-path */
t8=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}

/* k3195 in change-file-mode in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3197(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1228 ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k3191 in change-file-mode in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3193(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chmod(t1,((C_word*)t0)[4]);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm: 1229 posix-error */
t3=lf[3];
f_1429(7,t3,((C_word*)t0)[3],lf[51],lf[297],lf[298],((C_word*)t0)[2],((C_word*)t0)[4]);}
else{
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}}

/* initialize-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3108(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[6],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_3108,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[255]);
t5=(C_word)C_i_check_exact_2(t3,lf[255]);
t6=t2;
t7=t3;
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3096,a[2]=t3,a[3]=t2,a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
if(C_truep(t6)){
t9=(C_word)C_i_foreign_string_argumentp(t6);
/* ##sys#make-c-string */
t10=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t8,t9);}
else{
t9=t8;
f_3096(2,t9,C_SCHEME_FALSE);}}

/* k3094 in initialize-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3096(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3096,2,t0,t1);}
t2=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[5]);
t3=(C_word)stub379(C_SCHEME_UNDEFINED,t1,t2);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3124,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 1142 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k3122 in k3094 in initialize-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3124(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1143 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[255],lf[256],((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-groups! in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3034(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_3034,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3038,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_i_length(t2);
t5=f_2964(t4);
if(C_truep(t5)){
t6=t3;
f_3038(2,t6,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1125 ##sys#error */
t6=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,lf[250],lf[253]);}}

/* k3036 in set-groups! in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3038,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3043,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=lf[252],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_3043(t5,((C_word*)t0)[2],((C_word*)t0)[3],C_fix(0));}

/* do366 in k3036 in set-groups! in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_3043(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_3043,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
if(C_truep((C_word)C_fixnum_lessp((C_word)C_set_groups(t3),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3059,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 1130 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}
else{
t4=(C_word)C_slot(t2,C_fix(0));
t5=(C_word)C_i_check_exact_2(t4,lf[250]);
t6=(C_word)C_set_gid(t3,t4);
t7=(C_word)C_slot(t2,C_fix(1));
t8=(C_word)C_fixnum_plus(t3,C_fix(1));
t11=t1;
t12=t7;
t13=t8;
t1=t11;
t2=t12;
t3=t13;
goto loop;}}

/* k3057 in do366 in k3036 in set-groups! in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3059(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1131 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc5)(void*)(*((C_word*)t2+1)))(5,t2,((C_word*)t0)[3],lf[250],lf[251],((C_word*)t0)[2]);}

/* get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2971(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2971,2,t0,t1);}
t2=C_fix((C_word)getgroups(0, C_groups));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2975,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3029,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1111 ##sys#update-errno */
t5=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,t4);}
else{
t4=t3;
f_2975(2,t4,C_SCHEME_UNDEFINED);}}

/* k3027 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3029(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1112 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[244],lf[248]);}

/* k2973 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2975(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2975,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2978,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=f_2964(((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t2;
f_2978(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 1114 ##sys#error */
t4=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t2,lf[244],lf[247]);}}

/* k2976 in k2973 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2978(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2978,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2981,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=(C_word)stub348(C_SCHEME_UNDEFINED,t3);
if(C_truep((C_word)C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3010,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1116 ##sys#update-errno */
t6=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t5=t2;
f_2981(2,t5,C_SCHEME_UNDEFINED);}}

/* k3008 in k2976 in k2973 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3010(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1117 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[244],lf[246]);}

/* k2979 in k2976 in k2973 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2981(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2981,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2986,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=lf[245],tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_2986(t5,((C_word*)t0)[2],C_fix(0));}

/* loop in k2979 in k2976 in k2973 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2986(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
a=C_alloc(4);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2986,NULL,3,t0,t1,t2);}
if(C_truep((C_word)C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[3]))){
t3=t1;
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_END_OF_LIST);}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3000,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_fixnum_plus(t2,C_fix(1));
/* posixunix.scm: 1121 loop */
t6=t3;
t7=t4;
t1=t6;
t2=t7;
goto loop;}}

/* k2998 in loop in k2979 in k2976 in k2973 in get-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_3000(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_3000,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,(C_word)C_get_gid(((C_word*)t0)[2]),t1));}

/* _ensure-groups in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_2964(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub352(C_SCHEME_UNDEFINED,t2));}

/* group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2903(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2903,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2907,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2907(t4,(C_word)C_getgrgid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[239]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2955,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1086 ##sys#make-c-string */
t6=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2953 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2955(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2907(t2,(C_word)C_getgrnam(t1));}

/* k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2907(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2907,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2917,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2915 in k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2917(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2917,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2921,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_group->gr_passwd),C_fix(0));}

/* k2919 in k2915 in k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2921(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2921,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2925,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2927,a[2]=t4,a[3]=lf[240],tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_2927(t6,t2,C_fix(0));}

/* rec in k2919 in k2915 in k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2927(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2927,NULL,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2931,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t4=t2;
t5=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)stub336(t5,t6);
/* ##sys#peek-c-string */
t8=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t3,t7,C_fix(0));}

/* k2929 in rec in k2919 in k2915 in k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2931(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2931,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2941,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_plus(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 1094 rec */
t4=((C_word*)((C_word*)t0)[2])[1];
f_2927(t4,t2,t3);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_END_OF_LIST);}}

/* k2939 in k2929 in rec in k2919 in k2915 in k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2941(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2941,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* k2923 in k2919 in k2915 in k2905 in group-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2925(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2925,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,4,((C_word*)t0)[3],((C_word*)t0)[2],C_fix((C_word)C_group->gr_gid),t1));}

/* user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2850(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2850,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2854,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t4=t3;
f_2854(t4,(C_word)C_getpwuid(t2));}
else{
t4=(C_word)C_i_check_string_2(t2,lf[237]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2890,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1063 ##sys#make-c-string */
t6=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}}

/* k2888 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2890(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
f_2854(t2,(C_word)C_getpwnam(t1));}

/* k2852 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2854(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2854,NULL,2,t0,t1);}
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2864,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_name),C_fix(0));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* k2862 in k2852 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2864(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2864,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2868,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_passwd),C_fix(0));}

/* k2866 in k2862 in k2852 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2868(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2868,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2872,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_gecos),C_fix(0));}

/* k2870 in k2866 in k2862 in k2852 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2872(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2872,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2876,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_dir),C_fix(0));}

/* k2874 in k2870 in k2866 in k2862 in k2852 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2876(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2876,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2880,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-c-string */
t3=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_user->pw_shell),C_fix(0));}

/* k2878 in k2874 in k2870 in k2866 in k2862 in k2852 in user-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2880(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[21],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2880,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,7,((C_word*)t0)[5],((C_word*)t0)[4],C_fix((C_word)C_user->pw_uid),C_fix((C_word)C_user->pw_gid),((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2812(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2812,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2816,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp(C_fix((C_word)C_uname),C_fix(0)))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2845,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 1042 ##sys#update-errno */
t4=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t3=t2;
f_2816(2,t3,C_SCHEME_UNDEFINED);}}

/* k2843 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2845(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 1043 ##sys#error */
t2=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t2+1)))(4,t2,((C_word*)t0)[2],lf[233],lf[235]);}

/* k2814 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2816(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2816,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2823,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.sysname),C_fix(0));}

/* k2821 in k2814 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2823(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2823,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2827,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.nodename),C_fix(0));}

/* k2825 in k2821 in k2814 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2827(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[8],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2827,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2831,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.release),C_fix(0));}

/* k2829 in k2825 in k2821 in k2814 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2831(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[9],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2831,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2835,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.version),C_fix(0));}

/* k2833 in k2829 in k2825 in k2821 in k2814 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2835(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2835,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2839,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* ##sys#peek-nonnull-c-string */
t3=*((C_word*)lf[234]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t2,C_mpointer(&a,(void*)C_utsname.machine),C_fix(0));}

/* k2837 in k2833 in k2829 in k2825 in k2821 in k2814 in system-information in k2808 in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2839(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2839,2,t0,t1);}
t2=((C_word*)t0)[6];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,5,((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3],((C_word*)t0)[2],t1));}

/* signal-unmask! in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2794(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2794,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[230]);
t4=(C_word)C_sigdelset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1017 posix-error */
t5=lf[3];
f_1429(5,t5,t1,lf[218],lf[230],lf[231]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-mask! in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2779(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2779,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[227]);
t4=(C_word)C_sigaddset(t2);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 1011 posix-error */
t5=lf[3];
f_1429(5,t5,t1,lf[218],lf[227],lf[228]);}
else{
t5=t1;
((C_proc2)(void*)(*((C_word*)t5+1)))(2,t5,C_SCHEME_UNDEFINED);}}

/* signal-masked? in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2773(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2773,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[225]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigismember(t2));}

/* signal-mask in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2741(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[6],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2741,2,t0,t1);}
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2747,a[2]=t3,a[3]=lf[223],tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_2747(t5,t1,*((C_word*)lf[210]+1),C_SCHEME_END_OF_LIST);}

/* loop in signal-mask in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2747(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
a=C_alloc(3);
if(!C_stack_probe(a)){
C_save_and_reclaim((void*)trf_2747,NULL,4,t0,t1,t2,t3);}
if(C_truep((C_word)C_i_nullp(t2))){
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,t3);}
else{
t4=(C_word)C_i_car(t2);
t5=(C_word)C_i_cdr(t2);
t6=(C_truep((C_word)C_sigismember(t4))?(C_word)C_a_i_cons(&a,2,t4,t3):t3);
/* posixunix.scm: 1001 loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* set-signal-mask! in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2717(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2717,3,t0,t1,t2);}
t3=(C_word)C_i_check_list_2(t2,lf[217]);
t4=(C_word)C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2724,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2735,a[2]=lf[220],tmp=(C_word)a,a+=3,tmp);
/* for-each */
t7=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,t2);}

/* a2734 in set-signal-mask! in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2735(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2735,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[217]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_sigaddset(t2));}

/* k2722 in set-signal-mask! in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2724(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp((C_word)C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm: 994  posix-error */
t2=lf[3];
f_1429(5,t2,((C_word*)t0)[2],lf[218],lf[217],lf[219]);}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* ##sys#interrupt-hook in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2699(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[4],*a=ab;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2699,4,t0,t1,t2,t3);}
t4=(C_word)C_slot(((C_word*)t0)[3],t2);
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2709,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 980  h */
t6=t4;
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,t2);}
else{
/* posixunix.scm: 982  oldhook */
t5=((C_word*)t0)[2];
((C_proc4)C_retrieve_proc(t5))(4,t5,t1,t2,t3);}}

/* k2707 in ##sys#interrupt-hook in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2709(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 981  ##sys#context-switch */
C_context_switch(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* set-signal-handler! in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2686(C_word c,C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr4,(void*)f_2686,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_exact_2(t2,lf[214]);
t5=(C_truep(t3)?t2:C_SCHEME_FALSE);
t6=(C_word)C_establish_signal_handler(t2,t5);
t7=t1;
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,(C_word)C_i_vector_set(((C_word*)t0)[2],t2,t3));}

/* signal-handler in k2673 in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2677(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2677,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[212]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)C_slot(((C_word*)t0)[2],t2));}

/* create-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2630(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2630,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2634,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm: 894  posix-error */
t3=lf[3];
f_1429(5,t3,t2,lf[51],lf[182],lf[183]);}
else{
t3=t2;
f_2634(2,t3,C_SCHEME_UNDEFINED);}}

/* k2632 in create-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2634(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 895  values */
C_values(4,0,((C_word*)t0)[2],C_fix((C_word)C_pipefds[ 0 ]),C_fix((C_word)C_pipefds[ 1 ]));}

/* with-output-to-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2610(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2610r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2610r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2610r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[179]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2614,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2612 in with-output-to-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2614(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2614,2,t0,t1);}
t2=C_mutate((C_word*)lf[179]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2620,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[180],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 882  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2619 in k2612 in with-output-to-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2620(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2620r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2620r(t0,t1,t2);}}

static void C_ccall f_2620r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2624,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 884  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2622 in a2619 in k2612 in with-output-to-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2624(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[179]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* with-input-from-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2590(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4r,(void*)f_2590r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2590r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2590r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(6);
t5=*((C_word*)lf[175]+1);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2594,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t5,tmp=(C_word)a,a+=6,tmp);
C_apply(5,0,t6,((C_word*)t0)[2],t2,t4);}

/* k2592 in with-input-from-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2594(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2594,2,t0,t1);}
t2=C_mutate((C_word*)lf[175]+1,t1);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2600,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=lf[176],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 872  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t3);}

/* a2599 in k2592 in with-input-from-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2600(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr2r,(void*)f_2600r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2600r(t0,t1,t2);}}

static void C_ccall f_2600r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2604,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 874  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2602 in a2599 in k2592 in with-input-from-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2604(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=C_mutate((C_word*)lf[175]+1,((C_word*)t0)[4]);
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* call-with-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2566(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2566r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2566r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2566r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2570,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2568 in call-with-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2570(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2570,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2575,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[171],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2581,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[172],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 862  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2580 in k2568 in call-with-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2581(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2581r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2581r(t0,t1,t2);}}

static void C_ccall f_2581r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2585,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 865  close-output-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2583 in a2580 in k2568 in call-with-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2585(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2574 in k2568 in call-with-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2575(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2575,2,t0,t1);}
/* posixunix.scm: 863  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* call-with-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2542(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_2542r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_2542r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2542r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2546,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
C_apply(5,0,t5,((C_word*)t0)[2],t2,t4);}

/* k2544 in call-with-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2546(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2546,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2551,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=lf[167],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2557,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=lf[168],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 854  ##sys#call-with-values */
C_call_with_values(4,0,((C_word*)t0)[2],t2,t3);}

/* a2556 in k2544 in call-with-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2557(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2557r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2557r(t0,t1,t2);}}

static void C_ccall f_2557r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2561,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 857  close-input-pipe */
t4=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t4))(3,t4,t3,((C_word*)t0)[2]);}

/* k2559 in a2556 in k2544 in call-with-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2561(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply_values(3,0,((C_word*)t0)[3],((C_word*)t0)[2]);}

/* a2550 in k2544 in call-with-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2551(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2551,2,t0,t1);}
/* posixunix.scm: 855  proc */
t2=((C_word*)t0)[3];
((C_proc3)C_retrieve_proc(t2))(3,t2,t1,((C_word*)t0)[2]);}

/* close-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2526(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2526,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2530,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 841  ##sys#check-port */
t4=*((C_word*)lf[163]+1);
((C_proc4)(void*)(*((C_word*)t4+1)))(4,t4,t3,t2,lf[160]);}

/* k2528 in close-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2530(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2530,2,t0,t1);}
t2=(C_word)close_pipe(((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2533,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 843  posix-error */
t5=lf[3];
f_1429(6,t5,t3,lf[51],lf[161],lf[162],((C_word*)t0)[3]);}
else{
t5=t3;
f_2533(2,t5,C_SCHEME_UNDEFINED);}}

/* k2531 in k2528 in close-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2533(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* open-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2490(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2490r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2490r(t0,t1,t2,t3);}}

static void C_ccall f_2490r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[158]);
t5=f_2421(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2504,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[146]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2511,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 836  ##sys#make-c-string */
t9=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[156]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2521,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 837  ##sys#make-c-string */
t10=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 838  badmode */
f_2433(t6,t5);}}}

/* k2519 in open-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2521(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2521,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2504(2,t2,(C_word)open_binary_output_pipe(&a,1,t1));}

/* k2509 in open-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2511(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2511,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2504(2,t2,(C_word)open_text_output_pipe(&a,1,t1));}

/* k2502 in open-output-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2504(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 832  check */
f_2439(((C_word*)t0)[3],lf[158],((C_word*)t0)[2],C_SCHEME_FALSE,t1);}

/* open-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2454(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+11)){
C_save_and_reclaim((void*)tr3r,(void*)f_2454r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_2454r(t0,t1,t2,t3);}}

static void C_ccall f_2454r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a=C_alloc(11);
t4=(C_word)C_i_check_string_2(t2,lf[155]);
t5=f_2421(t3);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2468,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t7=(C_word)C_eqp(t5,lf[146]);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2475,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 825  ##sys#make-c-string */
t9=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t9+1)))(3,t9,t8,t2);}
else{
t8=(C_word)C_eqp(t5,lf[156]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2485,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 826  ##sys#make-c-string */
t10=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t10+1)))(3,t10,t9,t2);}
else{
/* posixunix.scm: 827  badmode */
f_2433(t6,t5);}}}

/* k2483 in open-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2485(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2485,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2468(2,t2,(C_word)open_binary_input_pipe(&a,1,t1));}

/* k2473 in open-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2475(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[2],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2475,2,t0,t1);}
t2=((C_word*)t0)[2];
f_2468(2,t2,(C_word)open_text_input_pipe(&a,1,t1));}

/* k2466 in open-input-pipe in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2468(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 821  check */
f_2439(((C_word*)t0)[3],lf[155],((C_word*)t0)[2],C_SCHEME_TRUE,t1);}

/* check in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2439(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2439,NULL,5,t1,t2,t3,t4,t5);}
if(C_truep((C_word)C_null_pointerp(t5))){
/* posixunix.scm: 813  posix-error */
t6=lf[3];
f_1429(6,t6,t1,lf[51],t2,lf[150],t3);}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2452,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 814  ##sys#make-port */
t7=*((C_word*)lf[151]+1);
((C_proc6)(void*)(*((C_word*)t7+1)))(6,t7,t6,t4,*((C_word*)lf[152]+1),lf[153],lf[115]);}}

/* k2450 in check in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2452(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_set_file_ptr(t1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t1);}

/* badmode in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2433(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2433,NULL,2,t1,t2);}
/* posixunix.scm: 810  ##sys#error */
t3=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t3+1)))(4,t3,t1,lf[148],t2);}

/* mode in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_2421(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_pairp(t1);
return((C_truep(t2)?(C_word)C_slot(t1,C_fix(0)):lf[146]));}

/* current-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2378(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+4)){
C_save_and_reclaim((void*)tr2r,(void*)f_2378r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2378r(t0,t1,t2);}}

static void C_ccall f_2378r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2382,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
t4=t3;
f_2382(2,t4,C_SCHEME_FALSE);}
else{
t4=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t4))){
t5=t3;
f_2382(2,t5,(C_word)C_i_car(t2));}
else{
/* ##sys#error */
t5=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t5+1)))(4,t5,t3,lf[0],t2);}}}

/* k2380 in current-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2382(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2382,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 794  change-directory */
t2=*((C_word*)lf[125]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[3],t1);}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2391,a[2]=((C_word*)t0)[3],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 795  make-string */
t3=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t3))(3,t3,t2,C_fix(256));}}

/* k2389 in k2380 in current-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2391(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_curdir(t1);
if(C_truep(t2)){
/* posixunix.scm: 798  ##sys#substring */
t3=*((C_word*)lf[74]+1);
((C_proc5)(void*)(*((C_word*)t3+1)))(5,t3,((C_word*)t0)[2],t1,C_fix(0),t2);}
else{
/* posixunix.scm: 799  posix-error */
t3=lf[3];
f_1429(5,t3,((C_word*)t0)[2],lf[51],lf[138],lf[144]);}}

/* directory? in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2355(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2355,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[141]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2362,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2376,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 787  ##sys#expand-home-path */
t6=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2374 in directory? in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2376(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 787  ##sys#file-info */
t2=*((C_word*)lf[142]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2360 in directory? in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2362(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(t1,C_fix(4));
t3=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,(C_word)C_eqp(C_fix(1),t2));}
else{
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_FALSE);}}

/* directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2198(C_word c,C_word t0,C_word t1,...){
C_word tmp;
C_word t2;
va_list v;
C_word *a,c2=c;
C_save_rest(t1,c2,2);
if(!C_demand(c*C_SIZEOF_PAIR+12)){
C_save_and_reclaim((void*)tr2r,(void*)f_2198r,2,t0,t1);}
else{
a=C_alloc((c-2)*3);
t2=C_restore_rest(a,C_rest_count(0));
f_2198r(t0,t1,t2);}}

static void C_ccall f_2198r(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(12);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2200,a[2]=((C_word*)t0)[2],a[3]=lf[136],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2298,a[2]=t3,a[3]=lf[137],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2303,a[2]=t4,a[3]=lf[139],tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t2))){
/* def-spec182207 */
t6=t5;
f_2303(t6,t1);}
else{
t6=(C_word)C_i_car(t2);
t7=(C_word)C_i_cdr(t2);
if(C_truep((C_word)C_i_nullp(t7))){
/* def-show-dotfiles?183205 */
t8=t4;
f_2298(t8,t1,t6);}
else{
t8=(C_word)C_i_car(t7);
t9=(C_word)C_i_cdr(t7);
if(C_truep((C_word)C_i_nullp(t9))){
/* body180185 */
t10=t3;
f_2200(t10,t1,t6,t8);}
else{
/* ##sys#error */
t10=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t10+1)))(4,t10,t1,lf[0],t9);}}}}

/* def-spec182 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2303(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2303,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2311,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 760  current-directory */
t3=*((C_word*)lf[138]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2309 in def-spec182 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2311(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* def-show-dotfiles?183205 */
t2=((C_word*)t0)[3];
f_2298(t2,((C_word*)t0)[2],t1);}

/* def-show-dotfiles?183 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2298(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2298,NULL,3,t0,t1,t2);}
/* body180185 */
t3=((C_word*)t0)[2];
f_2200(t3,t1,t2,C_SCHEME_FALSE);}

/* body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2200(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2200,NULL,4,t0,t1,t2,t3);}
t4=(C_word)C_i_check_string_2(t2,lf[132]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2207,a[2]=t3,a[3]=t2,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm: 762  make-string */
t6=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t6))(3,t6,t5,C_fix(256));}

/* k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2207(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2207,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2210,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 763  ##sys#make-pointer */
t3=*((C_word*)lf[135]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2210(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[7],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2210,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2213,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm: 764  ##sys#make-pointer */
t3=*((C_word*)lf[135]+1);
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,t2);}

/* k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2213(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2213,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2217,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2297,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 765  ##sys#expand-home-path */
t4=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k2295 in k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2297(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 765  ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2215 in k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2217(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[10],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2217,2,t0,t1);}
t2=(C_word)C_opendir(t1,((C_word*)t0)[7]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[7]))){
/* posixunix.scm: 767  posix-error */
t3=lf[3];
f_1429(6,t3,((C_word*)t0)[6],lf[51],lf[132],lf[133],((C_word*)t0)[5]);}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2231,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[7],a[7]=lf[134],tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_2231(t6,((C_word*)t0)[6]);}}

/* loop in k2215 in k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2231(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2231,NULL,2,t0,t1);}
t2=(C_word)C_readdir(((C_word*)t0)[6],((C_word*)t0)[5]);
if(C_truep((C_word)C_null_pointerp(((C_word*)t0)[5]))){
t3=(C_word)C_closedir(((C_word*)t0)[6]);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_END_OF_LIST);}
else{
t3=(C_word)C_foundfile(((C_word*)t0)[5],((C_word*)t0)[4]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2241,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 775  ##sys#substring */
t5=*((C_word*)lf[74]+1);
((C_proc5)(void*)(*((C_word*)t5+1)))(5,t5,t4,((C_word*)t0)[4],C_fix(0),t3);}}

/* k2239 in loop in k2215 in k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2241(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2241,2,t0,t1);}
t2=(C_word)C_i_string_ref(t1,C_fix(0));
t3=(C_word)C_fixnum_greaterp(((C_word*)t0)[5],C_fix(1));
t4=(C_truep(t3)?(C_word)C_i_string_ref(t1,C_fix(1)):C_SCHEME_FALSE);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2253,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t6=(C_word)C_eqp(t2,C_make_character(46));
if(C_truep(t6)){
t7=(C_word)C_i_not(t4);
if(C_truep(t7)){
t8=t5;
f_2253(t8,t7);}
else{
t8=(C_word)C_eqp(t4,C_make_character(46));
t9=(C_truep(t8)?(C_word)C_eqp(((C_word*)t0)[5],C_fix(2)):C_SCHEME_FALSE);
t10=t5;
f_2253(t10,(C_truep(t9)?t9:(C_word)C_i_not(((C_word*)t0)[2])));}}
else{
t7=t5;
f_2253(t7,C_SCHEME_FALSE);}}

/* k2251 in k2239 in loop in k2215 in k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_2253(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_2253,NULL,2,t0,t1);}
if(C_truep(t1)){
/* posixunix.scm: 782  loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_2231(t2,((C_word*)t0)[3]);}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2263,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 783  loop */
t3=((C_word*)((C_word*)t0)[4])[1];
f_2231(t3,t2);}}

/* k2261 in k2251 in k2239 in loop in k2215 in k2211 in k2208 in k2205 in body180 in directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2263(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[3],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2263,2,t0,t1);}
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_cons(&a,2,((C_word*)t0)[2],t1));}

/* delete-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2174(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2174,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[128]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2192,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2196,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 753  ##sys#expand-home-path */
t6=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2194 in delete-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2196(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 753  ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2190 in delete-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2192(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_rmdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 754  posix-error */
t3=lf[3];
f_1429(6,t3,((C_word*)t0)[3],lf[51],lf[128],lf[129],((C_word*)t0)[2]);}}

/* change-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2150(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2150,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[125]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2168,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2172,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 747  ##sys#expand-home-path */
t6=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2170 in change-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2172(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 747  ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2166 in change-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2168(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_chdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 748  posix-error */
t3=lf[3];
f_1429(6,t3,((C_word*)t0)[3],lf[51],lf[125],lf[126],((C_word*)t0)[2]);}}

/* create-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2126(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[7],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2126,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[122]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2144,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2148,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 741  ##sys#expand-home-path */
t6=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t6+1)))(3,t6,t5,t2);}

/* k2146 in create-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2148(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 741  ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k2142 in create-directory in k2122 in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2144(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
t2=(C_word)C_mkdir(t1);
if(C_truep((C_word)C_i_zerop(t2))){
t3=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t3+1)))(2,t3,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 742  posix-error */
t3=lf[3];
f_1429(6,t3,((C_word*)t0)[3],lf[51],lf[122],lf[123],((C_word*)t0)[2]);}}

/* set-file-position! in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2064(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_2064r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_2064r(t0,t1,t2,t3,t4);}}

static void C_ccall f_2064r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a=C_alloc(6);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_fix((C_word)SEEK_SET));
t7=(C_word)C_i_check_exact_2(t3,lf[113]);
t8=(C_word)C_i_check_exact_2(t6,lf[113]);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2077,a[2]=t6,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep((C_word)C_fixnum_lessp(t3,C_fix(0)))){
/* posixunix.scm: 713  ##sys#signal-hook */
t10=*((C_word*)lf[4]+1);
((C_proc7)(void*)(*((C_word*)t10+1)))(7,t10,t9,lf[118],lf[113],lf[119],t3,t2);}
else{
t10=t9;
f_2077(2,t10,C_SCHEME_UNDEFINED);}}

/* k2075 in set-file-position! in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2077(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[11],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2077,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2083,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2089,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm: 714  port? */
t4=*((C_word*)lf[117]+1);
((C_proc3)(void*)(*((C_word*)t4+1)))(3,t4,t3,((C_word*)t0)[4]);}

/* k2087 in k2075 in set-file-position! in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2089(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_truep(t1)){
t2=(C_word)C_slot(((C_word*)t0)[5],C_fix(7));
t3=(C_word)C_eqp(t2,lf[115]);
t4=((C_word*)t0)[4];
f_2083(2,t4,(C_truep(t3)?(C_word)C_fseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]):C_SCHEME_FALSE));}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[4];
f_2083(2,t2,(C_word)C_lseek(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[2]));}
else{
/* posixunix.scm: 718  ##sys#signal-hook */
t2=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t2+1)))(6,t2,((C_word*)t0)[4],lf[66],lf[113],lf[116],((C_word*)t0)[5]);}}}

/* k2081 in k2075 in set-file-position! in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2083(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep(t1)){
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 719  posix-error */
t2=lf[3];
f_1429(7,t2,((C_word*)t0)[4],lf[51],lf[113],lf[114],((C_word*)t0)[3],((C_word*)t0)[2]);}}

/* symbolic-link? in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2055(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2055,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[111]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2062,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 705  ##sys#stat */
f_1941(t4,t2,C_SCHEME_TRUE,lf[111]);}

/* k2060 in symbolic-link? in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2062(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_islink));}

/* regular-file? in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2046(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2046,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[109]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2053,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 700  ##sys#stat */
f_1941(t4,t2,C_SCHEME_TRUE,lf[109]);}

/* k2051 in regular-file? in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2053(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_mk_bool(C_isreg));}

/* file-permissions in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2040(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2040,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2044,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 696  ##sys#stat */
f_1941(t3,t2,C_SCHEME_FALSE,lf[107]);}

/* k2042 in file-permissions in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2044(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode));}

/* file-owner in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2034(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2034,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2038,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 695  ##sys#stat */
f_1941(t3,t2,C_SCHEME_FALSE,lf[105]);}

/* k2036 in file-owner in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2038(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid));}

/* file-change-time in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2028(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2028,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2032,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 694  ##sys#stat */
f_1941(t3,t2,C_SCHEME_FALSE,lf[103]);}

/* k2030 in file-change-time in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2032(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2032,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_ctime));}

/* file-access-time in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2022(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2022,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2026,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 693  ##sys#stat */
f_1941(t3,t2,C_SCHEME_FALSE,lf[101]);}

/* k2024 in file-access-time in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2026(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2026,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_atime));}

/* file-modification-time in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2016(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2016,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2020,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 692  ##sys#stat */
f_1941(t3,t2,C_SCHEME_FALSE,lf[99]);}

/* k2018 in file-modification-time in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2020(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_2020,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_flonum(&a,C_statbuf.st_mtime));}

/* file-size in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2010(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_2010,3,t0,t1,t2);}
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2014,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 691  ##sys#stat */
f_1941(t3,t2,C_SCHEME_FALSE,lf[97]);}

/* k2012 in file-size in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_2014(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size));}

/* file-stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1978(C_word c,C_word t0,C_word t1,C_word t2,...){
C_word tmp;
C_word t3;
va_list v;
C_word *a,c2=c;
C_save_rest(t2,c2,3);
if(c<3) C_bad_min_argc_2(c,3,t0);
if(!C_demand(c*C_SIZEOF_PAIR+7)){
C_save_and_reclaim((void*)tr3r,(void*)f_1978r,3,t0,t1,t2);}
else{
a=C_alloc((c-3)*3);
t3=C_restore_rest(a,C_rest_count(0));
f_1978r(t0,t1,t2,t3);}}

static void C_ccall f_1978r(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1982,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1989,a[2]=t2,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep((C_word)C_i_nullp(t3))){
t6=t5;
f_1989(2,t6,C_SCHEME_FALSE);}
else{
t6=(C_word)C_i_cdr(t3);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_1989(2,t7,(C_word)C_i_car(t3));}
else{
/* posixunix.scm: 684  ##sys#error */
t7=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t3);}}}

/* k1987 in file-stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1989(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 684  ##sys#stat */
f_1941(((C_word*)t0)[3],((C_word*)t0)[2],t1,lf[95]);}

/* k1980 in file-stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1982(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[26],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1982,2,t0,t1);}
t2=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_size),C_flonum(&a,C_statbuf.st_atime),C_flonum(&a,C_statbuf.st_ctime),C_flonum(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev)));}

/* ##sys#stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_1941(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[12],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1941,NULL,4,t1,t2,t3,t4);}
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1945,a[2]=t2,a[3]=t4,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_fixnump(t2))){
t6=t5;
f_1945(2,t6,(C_word)C_fstat(t2));}
else{
if(C_truep((C_word)C_i_stringp(t2))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1966,a[2]=t3,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1973,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 671  ##sys#expand-home-path */
t8=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t8+1)))(3,t8,t7,t2);}
else{
/* posixunix.scm: 679  ##sys#signal-hook */
t6=*((C_word*)lf[4]+1);
((C_proc5)(void*)(*((C_word*)t6+1)))(5,t6,t5,lf[66],lf[93],t2);}}}

/* k1971 in ##sys#stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1973(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 671  ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1964 in ##sys#stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1966(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1945(2,t2,(C_truep(((C_word*)t0)[2])?(C_word)C_lstat(t1):(C_word)C_stat(t1)));}

/* k1943 in ##sys#stat in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1945(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 681  posix-error */
t2=lf[3];
f_1429(6,t2,((C_word*)t0)[4],lf[51],((C_word*)t0)[3],lf[92],((C_word*)t0)[2]);}
else{
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,C_SCHEME_UNDEFINED);}}

/* file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1749(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+16)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1749r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1749r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1749r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a=C_alloc(16);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(C_word)C_notvemptyp(t4);
t8=(C_truep(t7)?(C_word)C_i_vector_ref(t4,C_fix(0)):C_SCHEME_FALSE);
t9=f_1723(C_fix(0));
t10=f_1723(C_fix(1));
t11=(C_word)C_i_not(t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1765,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t1,a[8]=t3,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t11)){
t13=t12;
f_1765(2,t13,t11);}
else{
if(C_truep((C_word)C_fixnump(t2))){
t13=C_set_block_item(t6,0,t2);
/* posixunix.scm: 600  fd_set */
t14=t12;
f_1765(2,t14,f_1729(C_fix(0),t2));}
else{
t13=(C_word)C_i_check_list_2(t2,lf[80]);
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1922,a[2]=((C_word*)t0)[2],a[3]=t6,a[4]=lf[86],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t15=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t15+1)))(4,t15,t12,t14,t2);}}}

/* a1921 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1922(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1922,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[80]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 607  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1729(C_fix(0),t2));}

/* k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1765(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[13],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1765,2,t0,t1);}
t2=(C_word)C_i_not(((C_word*)t0)[8]);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1771,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t2)){
t4=t3;
f_1771(2,t4,t2);}
else{
if(C_truep((C_word)C_fixnump(((C_word*)t0)[8]))){
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[8]);
/* posixunix.scm: 612  fd_set */
t5=t3;
f_1771(2,t5,f_1729(C_fix(1),((C_word*)t0)[8]));}
else{
t4=(C_word)C_i_check_list_2(((C_word*)t0)[8],lf[80]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1896,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=lf[85],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t6=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t6+1)))(4,t6,t3,t5,((C_word*)t0)[8]);}}}

/* a1895 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1896(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1896,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[80]);
t4=C_mutate(((C_word *)((C_word*)t0)[3])+1,(C_word)C_i_fixnum_max(((C_word*)((C_word*)t0)[3])[1],t2));
/* posixunix.scm: 619  fd_set */
t5=t1;
((C_proc2)C_retrieve_proc(t5))(2,t5,f_1729(C_fix(1),t2));}

/* k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1771(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1771,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1774,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[3])){
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[80]);
t4=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t5=t2;
f_1774(t5,(C_word)C_C_select_t(t4,((C_word*)t0)[3]));}
else{
t3=(C_word)C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t4=t2;
f_1774(t4,(C_word)C_C_select(t3));}}

/* k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_1774(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1774,NULL,2,t0,t1);}
if(C_truep((C_word)C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm: 626  posix-error */
t2=lf[3];
f_1429(7,t2,((C_word*)t0)[5],lf[51],lf[80],lf[81],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t2=(C_word)C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=(C_word)C_i_pairp(((C_word*)t0)[4]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
t5=(C_word)C_i_pairp(((C_word*)t0)[3]);
t6=(C_truep(t5)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
/* posixunix.scm: 627  values */
C_values(4,0,((C_word*)t0)[5],t4,t6);}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1813,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[4]))){
/* posixunix.scm: 632  fd_test */
t4=t3;
f_1813(t4,f_1739(C_fix(0),((C_word*)t0)[4]));}
else{
t4=C_SCHEME_END_OF_LIST;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1854,a[2]=t5,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1856,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=lf[84],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t8=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t8+1)))(4,t8,t6,t7,((C_word*)t0)[4]);}}
else{
t4=t3;
f_1813(t4,C_SCHEME_FALSE);}}}}

/* a1855 in k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1856(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1856,3,t0,t1,t2);}
t3=f_1739(C_fix(0),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1852 in k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1854(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1813(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1811 in k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_1813(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[15],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)trf_1813,NULL,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1817,a[2]=t1,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
if(C_truep((C_word)C_fixnump(((C_word*)t0)[3]))){
/* posixunix.scm: 638  fd_test */
t3=t2;
f_1817(t3,f_1739(C_fix(1),((C_word*)t0)[3]));}
else{
t3=C_SCHEME_END_OF_LIST;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1829,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1831,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=lf[82],tmp=(C_word)a,a+=5,tmp);
/* for-each */
t7=*((C_word*)lf[83]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,t6,((C_word*)t0)[3]);}}
else{
t3=t2;
f_1817(t3,C_SCHEME_FALSE);}}

/* a1830 in k1811 in k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1831(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[3],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1831,3,t0,t1,t2);}
t3=f_1739(C_fix(1),t2);
if(C_truep(t3)){
t4=(C_word)C_a_i_cons(&a,2,t2,((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,t4);
t6=t1;
((C_proc2)(void*)(*((C_word*)t6+1)))(2,t6,t5);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* k1827 in k1811 in k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1829(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
f_1817(t2,((C_word*)((C_word*)t0)[2])[1]);}

/* k1815 in k1811 in k1772 in k1769 in k1763 in file-select in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_fcall f_1817(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 629  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* fd_test in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_1739(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub92(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_set in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_1729(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_check;
t3=(C_word)C_i_foreign_fixnum_argumentp(t1);
t4=(C_word)C_i_foreign_fixnum_argumentp(t2);
return((C_word)stub86(C_SCHEME_UNDEFINED,t3,t4));}

/* fd_zero in k1415 in k1412 in k1409 in k1406 in k1403 */
static C_word C_fcall f_1723(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_stack_check;
t2=(C_word)C_i_foreign_fixnum_argumentp(t1);
return((C_word)stub81(C_SCHEME_UNDEFINED,t2));}

/* file-mkstemp in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1691(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1691,3,t0,t1,t2);}
t3=(C_word)C_i_check_string_2(t2,lf[73]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1698,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm: 578  ##sys#make-c-string */
t5=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t5+1)))(3,t5,t4,t2);}

/* k1696 in file-mkstemp in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1698(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1698,2,t0,t1);}
t2=(C_word)C_mkstemp(t1);
t3=(C_word)C_block_size(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1704,a[2]=t1,a[3]=t3,a[4]=t2,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t5=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm: 582  posix-error */
t6=lf[3];
f_1429(6,t6,t4,lf[51],lf[73],lf[75],((C_word*)t0)[2]);}
else{
t6=t4;
f_1704(2,t6,C_SCHEME_UNDEFINED);}}

/* k1702 in k1696 in file-mkstemp in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1704(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1704,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1711,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t3=(C_word)C_fixnum_difference(((C_word*)t0)[3],C_fix(1));
/* posixunix.scm: 583  ##sys#substring */
t4=*((C_word*)lf[74]+1);
((C_proc5)(void*)(*((C_word*)t4+1)))(5,t4,t2,((C_word*)t0)[2],C_fix(0),t3);}

/* k1709 in k1702 in k1696 in file-mkstemp in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1711(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 583  values */
C_values(4,0,((C_word*)t0)[3],((C_word*)t0)[2],t1);}

/* file-write in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1652(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+6)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1652r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1652r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1652r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(6);
t5=(C_word)C_i_check_exact_2(t2,lf[69]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1659,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t7=(C_truep((C_word)C_blockp(t3))?(C_word)C_byteblockp(t3):C_SCHEME_FALSE);
if(C_truep(t7)){
t8=t6;
f_1659(2,t8,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 564  ##sys#signal-hook */
t8=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t8+1)))(6,t8,t6,lf[66],lf[69],lf[71],t3);}}

/* k1657 in file-write in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1659(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1659,2,t0,t1);}
t2=(C_word)C_notvemptyp(((C_word*)t0)[5]);
t3=(C_truep(t2)?(C_word)C_i_vector_ref(((C_word*)t0)[5],C_fix(0)):(C_word)C_block_size(((C_word*)t0)[4]));
t4=(C_word)C_i_check_exact_2(t3,lf[69]);
t5=(C_word)C_write(((C_word*)t0)[3],((C_word*)t0)[4],t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1668,a[2]=t5,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t7=(C_word)C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm: 569  posix-error */
t8=lf[3];
f_1429(7,t8,t6,lf[51],lf[69],lf[70],((C_word*)t0)[3],t3);}
else{
t8=t6;
f_1668(2,t8,C_SCHEME_UNDEFINED);}}

/* k1666 in k1657 in file-write in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1668(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-read in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1610(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1610r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1610r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1610r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a=C_alloc(5);
t5=(C_word)C_i_check_exact_2(t2,lf[64]);
t6=(C_word)C_i_check_exact_2(t3,lf[64]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1620,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_notvemptyp(t4))){
t8=t7;
f_1620(2,t8,(C_word)C_i_vector_ref(t4,C_fix(0)));}
else{
/* posixunix.scm: 552  make-string */
t8=((C_word*)t0)[2];
((C_proc3)C_retrieve_proc(t8))(3,t8,t7,t3);}}

/* k1618 in file-read in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1620(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1620,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1623,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t3=(C_truep((C_word)C_blockp(t1))?(C_word)C_byteblockp(t1):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=t2;
f_1623(2,t4,C_SCHEME_UNDEFINED);}
else{
/* posixunix.scm: 554  ##sys#signal-hook */
t4=*((C_word*)lf[4]+1);
((C_proc6)(void*)(*((C_word*)t4+1)))(6,t4,t2,lf[66],lf[64],lf[67],t1);}}

/* k1621 in k1618 in file-read in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1623(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[5],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1623,2,t0,t1);}
t2=(C_word)C_read(((C_word*)t0)[5],((C_word*)t0)[4],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1626,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 557  posix-error */
t5=lf[3];
f_1429(7,t5,t3,lf[51],lf[64],lf[65],((C_word*)t0)[5],((C_word*)t0)[3]);}
else{
t5=t3;
f_1626(2,t5,C_SCHEME_UNDEFINED);}}

/* k1624 in k1621 in k1618 in file-read in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1626(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word ab[6],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1626,2,t0,t1);}
t2=((C_word*)t0)[4];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,(C_word)C_a_i_list(&a,2,((C_word*)t0)[3],((C_word*)t0)[2]));}

/* file-close in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1595(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1595,3,t0,t1,t2);}
t3=(C_word)C_i_check_exact_2(t2,lf[60]);
if(C_truep((C_word)C_fixnum_lessp((C_word)C_close(t2),C_fix(0)))){
/* posixunix.scm: 545  posix-error */
t4=lf[3];
f_1429(6,t4,t1,lf[51],lf[60],lf[61],t2);}
else{
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,C_SCHEME_UNDEFINED);}}

/* file-open in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1557(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+9)){
C_save_and_reclaim((void*)tr4rv,(void*)f_1557r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest_vector(a,C_rest_count(0));
f_1557r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1557r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a=C_alloc(9);
t5=(C_word)C_notvemptyp(t4);
t6=(C_truep(t5)?(C_word)C_i_vector_ref(t4,C_fix(0)):((C_word*)t0)[2]);
t7=(C_word)C_i_check_string_2(t2,lf[55]);
t8=(C_word)C_i_check_exact_2(t3,lf[55]);
t9=(C_word)C_i_check_exact_2(t6,lf[55]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1574,a[2]=t2,a[3]=t1,a[4]=t6,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1587,a[2]=t10,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm: 536  ##sys#expand-home-path */
t12=*((C_word*)lf[58]+1);
((C_proc3)(void*)(*((C_word*)t12+1)))(3,t12,t11,t2);}

/* k1585 in file-open in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1587(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 536  ##sys#make-c-string */
t2=*((C_word*)lf[57]+1);
((C_proc3)(void*)(*((C_word*)t2+1)))(3,t2,((C_word*)t0)[2],t1);}

/* k1572 in file-open in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1574(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word ab[4],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1574,2,t0,t1);}
t2=(C_word)C_open(t1,((C_word*)t0)[5],((C_word*)t0)[4]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1577,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(C_word)C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm: 538  posix-error */
t5=lf[3];
f_1429(8,t5,t3,lf[51],lf[55],lf[56],((C_word*)t0)[2],((C_word*)t0)[5],((C_word*)t0)[4]);}
else{
t5=t3;
f_1577(2,t5,C_SCHEME_UNDEFINED);}}

/* k1575 in k1572 in file-open in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1577(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
t2=((C_word*)t0)[3];
((C_proc2)(void*)(*((C_word*)t2+1)))(2,t2,((C_word*)t0)[2]);}

/* file-control in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1511(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,...){
C_word tmp;
C_word t4;
va_list v;
C_word *a,c2=c;
C_save_rest(t3,c2,4);
if(c<4) C_bad_min_argc_2(c,4,t0);
if(!C_demand(c*C_SIZEOF_PAIR+5)){
C_save_and_reclaim((void*)tr4r,(void*)f_1511r,4,t0,t1,t2,t3);}
else{
a=C_alloc((c-4)*3);
t4=C_restore_rest(a,C_rest_count(0));
f_1511r(t0,t1,t2,t3,t4);}}

static void C_ccall f_1511r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1515,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep((C_word)C_i_nullp(t4))){
t6=t5;
f_1515(2,t6,C_fix(0));}
else{
t6=(C_word)C_i_cdr(t4);
if(C_truep((C_word)C_i_nullp(t6))){
t7=t5;
f_1515(2,t7,(C_word)C_i_car(t4));}
else{
/* ##sys#error */
t7=*((C_word*)lf[53]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t5,lf[0],t4);}}}

/* k1513 in file-control in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1515(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
t2=(C_word)C_i_check_exact_2(((C_word*)t0)[4],lf[50]);
t3=(C_word)C_i_check_exact_2(((C_word*)t0)[3],lf[50]);
t4=((C_word*)t0)[4];
t5=((C_word*)t0)[3];
t6=(C_word)C_i_foreign_fixnum_argumentp(t4);
t7=(C_word)C_i_foreign_fixnum_argumentp(t5);
t8=(C_word)C_i_foreign_integer_argumentp(t1);
t9=(C_word)stub24(C_SCHEME_UNDEFINED,t6,t7,t8);
t10=(C_word)C_eqp(t9,C_fix(-1));
if(C_truep(t10)){
/* posixunix.scm: 526  posix-error */
t11=lf[3];
f_1429(7,t11,((C_word*)t0)[2],lf[51],lf[50],lf[52],((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t11=((C_word*)t0)[2];
((C_proc2)(void*)(*((C_word*)t11+1)))(2,t11,t9);}}

/* ##sys#file-select-one in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1454(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1454,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub17(C_SCHEME_UNDEFINED,t3));}

/* ##sys#file-nonblocking! in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1447(C_word c,C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr3,(void*)f_1447,3,t0,t1,t2);}
t3=(C_word)C_i_foreign_fixnum_argumentp(t2);
t4=t1;
((C_proc2)(void*)(*((C_word*)t4+1)))(2,t4,(C_word)stub13(C_SCHEME_UNDEFINED,t3));}

/* posix-error in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1429(C_word c,C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,...){
C_word tmp;
C_word t5;
va_list v;
C_word *a,c2=c;
C_save_rest(t4,c2,5);
if(c<5) C_bad_min_argc_2(c,5,t0);
if(!C_demand(c*C_SIZEOF_PAIR+8)){
C_save_and_reclaim((void*)tr5r,(void*)f_1429r,5,t0,t1,t2,t3,t4);}
else{
a=C_alloc((c-5)*3);
t5=C_restore_rest(a,C_rest_count(0));
f_1429r(t0,t1,t2,t3,t4,t5);}}

static void C_ccall f_1429r(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a=C_alloc(8);
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1433,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=t3,a[6]=t2,a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm: 413  ##sys#update-errno */
t7=*((C_word*)lf[7]+1);
((C_proc2)(void*)(*((C_word*)t7+1)))(2,t7,t6);}

/* k1431 in posix-error in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1433(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word ab[16],*a=ab;
if(!C_stack_probe(&a)){
C_save_and_reclaim((void*)tr2,(void*)f_1433,2,t0,t1);}
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1440,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1444,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t4=(C_word)C_a_i_bytevector(&a,1,C_fix(3));
t5=(C_word)C_i_foreign_fixnum_argumentp(t1);
t6=(C_word)stub3(t4,t5);
/* ##sys#peek-c-string */
t7=*((C_word*)lf[6]+1);
((C_proc4)(void*)(*((C_word*)t7+1)))(4,t7,t3,t6,C_fix(0));}

/* k1442 in k1431 in posix-error in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1444(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
/* posixunix.scm: 414  string-append */
t2=((C_word*)t0)[4];
((C_proc5)C_retrieve_proc(t2))(5,t2,((C_word*)t0)[3],((C_word*)t0)[2],lf[5],t1);}

/* k1438 in k1431 in posix-error in k1415 in k1412 in k1409 in k1406 in k1403 */
static void C_ccall f_1440(C_word c,C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
C_apply(7,0,((C_word*)t0)[5],*((C_word*)lf[4]+1),((C_word*)t0)[4],((C_word*)t0)[3],t1,((C_word*)t0)[2]);}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[501] = {
{"toplevelposixunix.scm",(void*)C_posix_toplevel},
{"f_1405posixunix.scm",(void*)f_1405},
{"f_1408posixunix.scm",(void*)f_1408},
{"f_1411posixunix.scm",(void*)f_1411},
{"f_1414posixunix.scm",(void*)f_1414},
{"f_1417posixunix.scm",(void*)f_1417},
{"f_6276posixunix.scm",(void*)f_6276},
{"f_6292posixunix.scm",(void*)f_6292},
{"f_6280posixunix.scm",(void*)f_6280},
{"f_6283posixunix.scm",(void*)f_6283},
{"f_2124posixunix.scm",(void*)f_2124},
{"f_2675posixunix.scm",(void*)f_2675},
{"f_6270posixunix.scm",(void*)f_6270},
{"f_2810posixunix.scm",(void*)f_2810},
{"f_6255posixunix.scm",(void*)f_6255},
{"f_6265posixunix.scm",(void*)f_6265},
{"f_6252posixunix.scm",(void*)f_6252},
{"f_3231posixunix.scm",(void*)f_3231},
{"f_6237posixunix.scm",(void*)f_6237},
{"f_6247posixunix.scm",(void*)f_6247},
{"f_6234posixunix.scm",(void*)f_6234},
{"f_3235posixunix.scm",(void*)f_3235},
{"f_6231posixunix.scm",(void*)f_6231},
{"f_3254posixunix.scm",(void*)f_3254},
{"f_6228posixunix.scm",(void*)f_6228},
{"f_3273posixunix.scm",(void*)f_3273},
{"f_6210posixunix.scm",(void*)f_6210},
{"f_6223posixunix.scm",(void*)f_6223},
{"f_6217posixunix.scm",(void*)f_6217},
{"f_3355posixunix.scm",(void*)f_3355},
{"f_3394posixunix.scm",(void*)f_3394},
{"f_6187posixunix.scm",(void*)f_6187},
{"f_6179posixunix.scm",(void*)f_6179},
{"f_5948posixunix.scm",(void*)f_5948},
{"f_6105posixunix.scm",(void*)f_6105},
{"f_6111posixunix.scm",(void*)f_6111},
{"f_6100posixunix.scm",(void*)f_6100},
{"f_6095posixunix.scm",(void*)f_6095},
{"f_5950posixunix.scm",(void*)f_5950},
{"f_6082posixunix.scm",(void*)f_6082},
{"f_6090posixunix.scm",(void*)f_6090},
{"f_5957posixunix.scm",(void*)f_5957},
{"f_6070posixunix.scm",(void*)f_6070},
{"f_5967posixunix.scm",(void*)f_5967},
{"f_5969posixunix.scm",(void*)f_5969},
{"f_5988posixunix.scm",(void*)f_5988},
{"f_6056posixunix.scm",(void*)f_6056},
{"f_6063posixunix.scm",(void*)f_6063},
{"f_6050posixunix.scm",(void*)f_6050},
{"f_6003posixunix.scm",(void*)f_6003},
{"f_6037posixunix.scm",(void*)f_6037},
{"f_6023posixunix.scm",(void*)f_6023},
{"f_6035posixunix.scm",(void*)f_6035},
{"f_6031posixunix.scm",(void*)f_6031},
{"f_6015posixunix.scm",(void*)f_6015},
{"f_6013posixunix.scm",(void*)f_6013},
{"f_6074posixunix.scm",(void*)f_6074},
{"f_5888posixunix.scm",(void*)f_5888},
{"f_5900posixunix.scm",(void*)f_5900},
{"f_5895posixunix.scm",(void*)f_5895},
{"f_5890posixunix.scm",(void*)f_5890},
{"f_5828posixunix.scm",(void*)f_5828},
{"f_5840posixunix.scm",(void*)f_5840},
{"f_5835posixunix.scm",(void*)f_5835},
{"f_5830posixunix.scm",(void*)f_5830},
{"f_5763posixunix.scm",(void*)f_5763},
{"f_5822posixunix.scm",(void*)f_5822},
{"f_5826posixunix.scm",(void*)f_5826},
{"f_5814posixunix.scm",(void*)f_5814},
{"f_5770posixunix.scm",(void*)f_5770},
{"f_5802posixunix.scm",(void*)f_5802},
{"f_5773posixunix.scm",(void*)f_5773},
{"f_5784posixunix.scm",(void*)f_5784},
{"f_5778posixunix.scm",(void*)f_5778},
{"f_5707posixunix.scm",(void*)f_5707},
{"f_5719posixunix.scm",(void*)f_5719},
{"f_5750posixunix.scm",(void*)f_5750},
{"f_5730posixunix.scm",(void*)f_5730},
{"f_5746posixunix.scm",(void*)f_5746},
{"f_5734posixunix.scm",(void*)f_5734},
{"f_5742posixunix.scm",(void*)f_5742},
{"f_5738posixunix.scm",(void*)f_5738},
{"f_5713posixunix.scm",(void*)f_5713},
{"f_5696posixunix.scm",(void*)f_5696},
{"f_5700posixunix.scm",(void*)f_5700},
{"f_5685posixunix.scm",(void*)f_5685},
{"f_5689posixunix.scm",(void*)f_5689},
{"f_5624posixunix.scm",(void*)f_5624},
{"f_5628posixunix.scm",(void*)f_5628},
{"f_5631posixunix.scm",(void*)f_5631},
{"f_5634posixunix.scm",(void*)f_5634},
{"f_5663posixunix.scm",(void*)f_5663},
{"f_5667posixunix.scm",(void*)f_5667},
{"f_5670posixunix.scm",(void*)f_5670},
{"f_5673posixunix.scm",(void*)f_5673},
{"f_5661posixunix.scm",(void*)f_5661},
{"f_5635posixunix.scm",(void*)f_5635},
{"f_5607posixunix.scm",(void*)f_5607},
{"f_5620posixunix.scm",(void*)f_5620},
{"f_5529posixunix.scm",(void*)f_5529},
{"f_5590posixunix.scm",(void*)f_5590},
{"f_5603posixunix.scm",(void*)f_5603},
{"f_5606posixunix.scm",(void*)f_5606},
{"f_5570posixunix.scm",(void*)f_5570},
{"f_5585posixunix.scm",(void*)f_5585},
{"f_5579posixunix.scm",(void*)f_5579},
{"f_5533posixunix.scm",(void*)f_5533},
{"f_5535posixunix.scm",(void*)f_5535},
{"f_5556posixunix.scm",(void*)f_5556},
{"f_5550posixunix.scm",(void*)f_5550},
{"f_5477posixunix.scm",(void*)f_5477},
{"f_5484posixunix.scm",(void*)f_5484},
{"f_5503posixunix.scm",(void*)f_5503},
{"f_5507posixunix.scm",(void*)f_5507},
{"f_5471posixunix.scm",(void*)f_5471},
{"f_5462posixunix.scm",(void*)f_5462},
{"f_5466posixunix.scm",(void*)f_5466},
{"f_5435posixunix.scm",(void*)f_5435},
{"f_5428posixunix.scm",(void*)f_5428},
{"f_5425posixunix.scm",(void*)f_5425},
{"f_5422posixunix.scm",(void*)f_5422},
{"f_5344posixunix.scm",(void*)f_5344},
{"f_5380posixunix.scm",(void*)f_5380},
{"f_5374posixunix.scm",(void*)f_5374},
{"f_5327posixunix.scm",(void*)f_5327},
{"f_5148posixunix.scm",(void*)f_5148},
{"f_5279posixunix.scm",(void*)f_5279},
{"f_5274posixunix.scm",(void*)f_5274},
{"f_5150posixunix.scm",(void*)f_5150},
{"f_5160posixunix.scm",(void*)f_5160},
{"f_5168posixunix.scm",(void*)f_5168},
{"f_5211posixunix.scm",(void*)f_5211},
{"f_5181posixunix.scm",(void*)f_5181},
{"f_5206posixunix.scm",(void*)f_5206},
{"f_5184posixunix.scm",(void*)f_5184},
{"f_5129posixunix.scm",(void*)f_5129},
{"f_5110posixunix.scm",(void*)f_5110},
{"f_5068posixunix.scm",(void*)f_5068},
{"f_5090posixunix.scm",(void*)f_5090},
{"f_5094posixunix.scm",(void*)f_5094},
{"f_4962posixunix.scm",(void*)f_4962},
{"f_4968posixunix.scm",(void*)f_4968},
{"f_4989posixunix.scm",(void*)f_4989},
{"f_5060posixunix.scm",(void*)f_5060},
{"f_4993posixunix.scm",(void*)f_4993},
{"f_5000posixunix.scm",(void*)f_5000},
{"f_5002posixunix.scm",(void*)f_5002},
{"f_5019posixunix.scm",(void*)f_5019},
{"f_5029posixunix.scm",(void*)f_5029},
{"f_5033posixunix.scm",(void*)f_5033},
{"f_4983posixunix.scm",(void*)f_4983},
{"f_4950posixunix.scm",(void*)f_4950},
{"f_4954posixunix.scm",(void*)f_4954},
{"f_4957posixunix.scm",(void*)f_4957},
{"f_4920posixunix.scm",(void*)f_4920},
{"f_4924posixunix.scm",(void*)f_4924},
{"f_4927posixunix.scm",(void*)f_4927},
{"f_4891posixunix.scm",(void*)f_4891},
{"f_4895posixunix.scm",(void*)f_4895},
{"f_4898posixunix.scm",(void*)f_4898},
{"f_4832posixunix.scm",(void*)f_4832},
{"f_4836posixunix.scm",(void*)f_4836},
{"f_4842posixunix.scm",(void*)f_4842},
{"f_4825posixunix.scm",(void*)f_4825},
{"f_4806posixunix.scm",(void*)f_4806},
{"f_4810posixunix.scm",(void*)f_4810},
{"f_4794posixunix.scm",(void*)f_4794},
{"f_4766posixunix.scm",(void*)f_4766},
{"f_4773posixunix.scm",(void*)f_4773},
{"f_4738posixunix.scm",(void*)f_4738},
{"f_4745posixunix.scm",(void*)f_4745},
{"f_4710posixunix.scm",(void*)f_4710},
{"f_4717posixunix.scm",(void*)f_4717},
{"f_4720posixunix.scm",(void*)f_4720},
{"f_4723posixunix.scm",(void*)f_4723},
{"f_4693posixunix.scm",(void*)f_4693},
{"f_4697posixunix.scm",(void*)f_4697},
{"f_4700posixunix.scm",(void*)f_4700},
{"f_4674posixunix.scm",(void*)f_4674},
{"f_4665posixunix.scm",(void*)f_4665},
{"f_4659posixunix.scm",(void*)f_4659},
{"f_4650posixunix.scm",(void*)f_4650},
{"f_4615posixunix.scm",(void*)f_4615},
{"f_4553posixunix.scm",(void*)f_4553},
{"f_4557posixunix.scm",(void*)f_4557},
{"f_4563posixunix.scm",(void*)f_4563},
{"f_4582posixunix.scm",(void*)f_4582},
{"f_4569posixunix.scm",(void*)f_4569},
{"f_4450posixunix.scm",(void*)f_4450},
{"f_4456posixunix.scm",(void*)f_4456},
{"f_4460posixunix.scm",(void*)f_4460},
{"f_4468posixunix.scm",(void*)f_4468},
{"f_4494posixunix.scm",(void*)f_4494},
{"f_4498posixunix.scm",(void*)f_4498},
{"f_4486posixunix.scm",(void*)f_4486},
{"f_4430posixunix.scm",(void*)f_4430},
{"f_4438posixunix.scm",(void*)f_4438},
{"f_4413posixunix.scm",(void*)f_4413},
{"f_4424posixunix.scm",(void*)f_4424},
{"f_4428posixunix.scm",(void*)f_4428},
{"f_4387posixunix.scm",(void*)f_4387},
{"f_4411posixunix.scm",(void*)f_4411},
{"f_4394posixunix.scm",(void*)f_4394},
{"f_4344posixunix.scm",(void*)f_4344},
{"f_4351posixunix.scm",(void*)f_4351},
{"f_4372posixunix.scm",(void*)f_4372},
{"f_4368posixunix.scm",(void*)f_4368},
{"f_4316posixunix.scm",(void*)f_4316},
{"f_4294posixunix.scm",(void*)f_4294},
{"f_4298posixunix.scm",(void*)f_4298},
{"f_4279posixunix.scm",(void*)f_4279},
{"f_4283posixunix.scm",(void*)f_4283},
{"f_4264posixunix.scm",(void*)f_4264},
{"f_4268posixunix.scm",(void*)f_4268},
{"f_4246posixunix.scm",(void*)f_4246},
{"f_4172posixunix.scm",(void*)f_4172},
{"f_4194posixunix.scm",(void*)f_4194},
{"f_4200posixunix.scm",(void*)f_4200},
{"f_4133posixunix.scm",(void*)f_4133},
{"f_4161posixunix.scm",(void*)f_4161},
{"f_4157posixunix.scm",(void*)f_4157},
{"f_4150posixunix.scm",(void*)f_4150},
{"f_3894posixunix.scm",(void*)f_3894},
{"f_4085posixunix.scm",(void*)f_4085},
{"f_4074posixunix.scm",(void*)f_4074},
{"f_4080posixunix.scm",(void*)f_4080},
{"f_3896posixunix.scm",(void*)f_3896},
{"f_4003posixunix.scm",(void*)f_4003},
{"f_4004posixunix.scm",(void*)f_4004},
{"f_4021posixunix.scm",(void*)f_4021},
{"f_4031posixunix.scm",(void*)f_4031},
{"f_3989posixunix.scm",(void*)f_3989},
{"f_3945posixunix.scm",(void*)f_3945},
{"f_3981posixunix.scm",(void*)f_3981},
{"f_3960posixunix.scm",(void*)f_3960},
{"f_3970posixunix.scm",(void*)f_3970},
{"f_3954posixunix.scm",(void*)f_3954},
{"f_3949posixunix.scm",(void*)f_3949},
{"f_3952posixunix.scm",(void*)f_3952},
{"f_3899posixunix.scm",(void*)f_3899},
{"f_3934posixunix.scm",(void*)f_3934},
{"f_3915posixunix.scm",(void*)f_3915},
{"f_3622posixunix.scm",(void*)f_3622},
{"f_3831posixunix.scm",(void*)f_3831},
{"f_3820posixunix.scm",(void*)f_3820},
{"f_3826posixunix.scm",(void*)f_3826},
{"f_3815posixunix.scm",(void*)f_3815},
{"f_3624posixunix.scm",(void*)f_3624},
{"f_3631posixunix.scm",(void*)f_3631},
{"f_3788posixunix.scm",(void*)f_3788},
{"f_3792posixunix.scm",(void*)f_3792},
{"f_3767posixunix.scm",(void*)f_3767},
{"f_3777posixunix.scm",(void*)f_3777},
{"f_3755posixunix.scm",(void*)f_3755},
{"f_3742posixunix.scm",(void*)f_3742},
{"f_3746posixunix.scm",(void*)f_3746},
{"f_3737posixunix.scm",(void*)f_3737},
{"f_3740posixunix.scm",(void*)f_3740},
{"f_3655posixunix.scm",(void*)f_3655},
{"f_3667posixunix.scm",(void*)f_3667},
{"f_3704posixunix.scm",(void*)f_3704},
{"f_3713posixunix.scm",(void*)f_3713},
{"f_3707posixunix.scm",(void*)f_3707},
{"f_3683posixunix.scm",(void*)f_3683},
{"f_3686posixunix.scm",(void*)f_3686},
{"f_3647posixunix.scm",(void*)f_3647},
{"f_3632posixunix.scm",(void*)f_3632},
{"f_3646posixunix.scm",(void*)f_3646},
{"f_3595posixunix.scm",(void*)f_3595},
{"f_3602posixunix.scm",(void*)f_3602},
{"f_3605posixunix.scm",(void*)f_3605},
{"f_3550posixunix.scm",(void*)f_3550},
{"f_3554posixunix.scm",(void*)f_3554},
{"f_3589posixunix.scm",(void*)f_3589},
{"f_3572posixunix.scm",(void*)f_3572},
{"f_3536posixunix.scm",(void*)f_3536},
{"f_3548posixunix.scm",(void*)f_3548},
{"f_3522posixunix.scm",(void*)f_3522},
{"f_3534posixunix.scm",(void*)f_3534},
{"f_3507posixunix.scm",(void*)f_3507},
{"f_3520posixunix.scm",(void*)f_3520},
{"f_3470posixunix.scm",(void*)f_3470},
{"f_3478posixunix.scm",(void*)f_3478},
{"f_3445posixunix.scm",(void*)f_3445},
{"f_3426posixunix.scm",(void*)f_3426},
{"f_3430posixunix.scm",(void*)f_3430},
{"f_3395posixunix.scm",(void*)f_3395},
{"f_3419posixunix.scm",(void*)f_3419},
{"f_3403posixunix.scm",(void*)f_3403},
{"f_3406posixunix.scm",(void*)f_3406},
{"f_3357posixunix.scm",(void*)f_3357},
{"f_3390posixunix.scm",(void*)f_3390},
{"f_3378posixunix.scm",(void*)f_3378},
{"f_3386posixunix.scm",(void*)f_3386},
{"f_3382posixunix.scm",(void*)f_3382},
{"f_3332posixunix.scm",(void*)f_3332},
{"f_3348posixunix.scm",(void*)f_3348},
{"f_3317posixunix.scm",(void*)f_3317},
{"f_3327posixunix.scm",(void*)f_3327},
{"f_3321posixunix.scm",(void*)f_3321},
{"f_3311posixunix.scm",(void*)f_3311},
{"f_3305posixunix.scm",(void*)f_3305},
{"f_3299posixunix.scm",(void*)f_3299},
{"f_3275posixunix.scm",(void*)f_3275},
{"f_3297posixunix.scm",(void*)f_3297},
{"f_3293posixunix.scm",(void*)f_3293},
{"f_3285posixunix.scm",(void*)f_3285},
{"f_3256posixunix.scm",(void*)f_3256},
{"f_3266posixunix.scm",(void*)f_3266},
{"f_3237posixunix.scm",(void*)f_3237},
{"f_3247posixunix.scm",(void*)f_3247},
{"f_3199posixunix.scm",(void*)f_3199},
{"f_3227posixunix.scm",(void*)f_3227},
{"f_3223posixunix.scm",(void*)f_3223},
{"f_3172posixunix.scm",(void*)f_3172},
{"f_3197posixunix.scm",(void*)f_3197},
{"f_3193posixunix.scm",(void*)f_3193},
{"f_3108posixunix.scm",(void*)f_3108},
{"f_3096posixunix.scm",(void*)f_3096},
{"f_3124posixunix.scm",(void*)f_3124},
{"f_3034posixunix.scm",(void*)f_3034},
{"f_3038posixunix.scm",(void*)f_3038},
{"f_3043posixunix.scm",(void*)f_3043},
{"f_3059posixunix.scm",(void*)f_3059},
{"f_2971posixunix.scm",(void*)f_2971},
{"f_3029posixunix.scm",(void*)f_3029},
{"f_2975posixunix.scm",(void*)f_2975},
{"f_2978posixunix.scm",(void*)f_2978},
{"f_3010posixunix.scm",(void*)f_3010},
{"f_2981posixunix.scm",(void*)f_2981},
{"f_2986posixunix.scm",(void*)f_2986},
{"f_3000posixunix.scm",(void*)f_3000},
{"f_2964posixunix.scm",(void*)f_2964},
{"f_2903posixunix.scm",(void*)f_2903},
{"f_2955posixunix.scm",(void*)f_2955},
{"f_2907posixunix.scm",(void*)f_2907},
{"f_2917posixunix.scm",(void*)f_2917},
{"f_2921posixunix.scm",(void*)f_2921},
{"f_2927posixunix.scm",(void*)f_2927},
{"f_2931posixunix.scm",(void*)f_2931},
{"f_2941posixunix.scm",(void*)f_2941},
{"f_2925posixunix.scm",(void*)f_2925},
{"f_2850posixunix.scm",(void*)f_2850},
{"f_2890posixunix.scm",(void*)f_2890},
{"f_2854posixunix.scm",(void*)f_2854},
{"f_2864posixunix.scm",(void*)f_2864},
{"f_2868posixunix.scm",(void*)f_2868},
{"f_2872posixunix.scm",(void*)f_2872},
{"f_2876posixunix.scm",(void*)f_2876},
{"f_2880posixunix.scm",(void*)f_2880},
{"f_2812posixunix.scm",(void*)f_2812},
{"f_2845posixunix.scm",(void*)f_2845},
{"f_2816posixunix.scm",(void*)f_2816},
{"f_2823posixunix.scm",(void*)f_2823},
{"f_2827posixunix.scm",(void*)f_2827},
{"f_2831posixunix.scm",(void*)f_2831},
{"f_2835posixunix.scm",(void*)f_2835},
{"f_2839posixunix.scm",(void*)f_2839},
{"f_2794posixunix.scm",(void*)f_2794},
{"f_2779posixunix.scm",(void*)f_2779},
{"f_2773posixunix.scm",(void*)f_2773},
{"f_2741posixunix.scm",(void*)f_2741},
{"f_2747posixunix.scm",(void*)f_2747},
{"f_2717posixunix.scm",(void*)f_2717},
{"f_2735posixunix.scm",(void*)f_2735},
{"f_2724posixunix.scm",(void*)f_2724},
{"f_2699posixunix.scm",(void*)f_2699},
{"f_2709posixunix.scm",(void*)f_2709},
{"f_2686posixunix.scm",(void*)f_2686},
{"f_2677posixunix.scm",(void*)f_2677},
{"f_2630posixunix.scm",(void*)f_2630},
{"f_2634posixunix.scm",(void*)f_2634},
{"f_2610posixunix.scm",(void*)f_2610},
{"f_2614posixunix.scm",(void*)f_2614},
{"f_2620posixunix.scm",(void*)f_2620},
{"f_2624posixunix.scm",(void*)f_2624},
{"f_2590posixunix.scm",(void*)f_2590},
{"f_2594posixunix.scm",(void*)f_2594},
{"f_2600posixunix.scm",(void*)f_2600},
{"f_2604posixunix.scm",(void*)f_2604},
{"f_2566posixunix.scm",(void*)f_2566},
{"f_2570posixunix.scm",(void*)f_2570},
{"f_2581posixunix.scm",(void*)f_2581},
{"f_2585posixunix.scm",(void*)f_2585},
{"f_2575posixunix.scm",(void*)f_2575},
{"f_2542posixunix.scm",(void*)f_2542},
{"f_2546posixunix.scm",(void*)f_2546},
{"f_2557posixunix.scm",(void*)f_2557},
{"f_2561posixunix.scm",(void*)f_2561},
{"f_2551posixunix.scm",(void*)f_2551},
{"f_2526posixunix.scm",(void*)f_2526},
{"f_2530posixunix.scm",(void*)f_2530},
{"f_2533posixunix.scm",(void*)f_2533},
{"f_2490posixunix.scm",(void*)f_2490},
{"f_2521posixunix.scm",(void*)f_2521},
{"f_2511posixunix.scm",(void*)f_2511},
{"f_2504posixunix.scm",(void*)f_2504},
{"f_2454posixunix.scm",(void*)f_2454},
{"f_2485posixunix.scm",(void*)f_2485},
{"f_2475posixunix.scm",(void*)f_2475},
{"f_2468posixunix.scm",(void*)f_2468},
{"f_2439posixunix.scm",(void*)f_2439},
{"f_2452posixunix.scm",(void*)f_2452},
{"f_2433posixunix.scm",(void*)f_2433},
{"f_2421posixunix.scm",(void*)f_2421},
{"f_2378posixunix.scm",(void*)f_2378},
{"f_2382posixunix.scm",(void*)f_2382},
{"f_2391posixunix.scm",(void*)f_2391},
{"f_2355posixunix.scm",(void*)f_2355},
{"f_2376posixunix.scm",(void*)f_2376},
{"f_2362posixunix.scm",(void*)f_2362},
{"f_2198posixunix.scm",(void*)f_2198},
{"f_2303posixunix.scm",(void*)f_2303},
{"f_2311posixunix.scm",(void*)f_2311},
{"f_2298posixunix.scm",(void*)f_2298},
{"f_2200posixunix.scm",(void*)f_2200},
{"f_2207posixunix.scm",(void*)f_2207},
{"f_2210posixunix.scm",(void*)f_2210},
{"f_2213posixunix.scm",(void*)f_2213},
{"f_2297posixunix.scm",(void*)f_2297},
{"f_2217posixunix.scm",(void*)f_2217},
{"f_2231posixunix.scm",(void*)f_2231},
{"f_2241posixunix.scm",(void*)f_2241},
{"f_2253posixunix.scm",(void*)f_2253},
{"f_2263posixunix.scm",(void*)f_2263},
{"f_2174posixunix.scm",(void*)f_2174},
{"f_2196posixunix.scm",(void*)f_2196},
{"f_2192posixunix.scm",(void*)f_2192},
{"f_2150posixunix.scm",(void*)f_2150},
{"f_2172posixunix.scm",(void*)f_2172},
{"f_2168posixunix.scm",(void*)f_2168},
{"f_2126posixunix.scm",(void*)f_2126},
{"f_2148posixunix.scm",(void*)f_2148},
{"f_2144posixunix.scm",(void*)f_2144},
{"f_2064posixunix.scm",(void*)f_2064},
{"f_2077posixunix.scm",(void*)f_2077},
{"f_2089posixunix.scm",(void*)f_2089},
{"f_2083posixunix.scm",(void*)f_2083},
{"f_2055posixunix.scm",(void*)f_2055},
{"f_2062posixunix.scm",(void*)f_2062},
{"f_2046posixunix.scm",(void*)f_2046},
{"f_2053posixunix.scm",(void*)f_2053},
{"f_2040posixunix.scm",(void*)f_2040},
{"f_2044posixunix.scm",(void*)f_2044},
{"f_2034posixunix.scm",(void*)f_2034},
{"f_2038posixunix.scm",(void*)f_2038},
{"f_2028posixunix.scm",(void*)f_2028},
{"f_2032posixunix.scm",(void*)f_2032},
{"f_2022posixunix.scm",(void*)f_2022},
{"f_2026posixunix.scm",(void*)f_2026},
{"f_2016posixunix.scm",(void*)f_2016},
{"f_2020posixunix.scm",(void*)f_2020},
{"f_2010posixunix.scm",(void*)f_2010},
{"f_2014posixunix.scm",(void*)f_2014},
{"f_1978posixunix.scm",(void*)f_1978},
{"f_1989posixunix.scm",(void*)f_1989},
{"f_1982posixunix.scm",(void*)f_1982},
{"f_1941posixunix.scm",(void*)f_1941},
{"f_1973posixunix.scm",(void*)f_1973},
{"f_1966posixunix.scm",(void*)f_1966},
{"f_1945posixunix.scm",(void*)f_1945},
{"f_1749posixunix.scm",(void*)f_1749},
{"f_1922posixunix.scm",(void*)f_1922},
{"f_1765posixunix.scm",(void*)f_1765},
{"f_1896posixunix.scm",(void*)f_1896},
{"f_1771posixunix.scm",(void*)f_1771},
{"f_1774posixunix.scm",(void*)f_1774},
{"f_1856posixunix.scm",(void*)f_1856},
{"f_1854posixunix.scm",(void*)f_1854},
{"f_1813posixunix.scm",(void*)f_1813},
{"f_1831posixunix.scm",(void*)f_1831},
{"f_1829posixunix.scm",(void*)f_1829},
{"f_1817posixunix.scm",(void*)f_1817},
{"f_1739posixunix.scm",(void*)f_1739},
{"f_1729posixunix.scm",(void*)f_1729},
{"f_1723posixunix.scm",(void*)f_1723},
{"f_1691posixunix.scm",(void*)f_1691},
{"f_1698posixunix.scm",(void*)f_1698},
{"f_1704posixunix.scm",(void*)f_1704},
{"f_1711posixunix.scm",(void*)f_1711},
{"f_1652posixunix.scm",(void*)f_1652},
{"f_1659posixunix.scm",(void*)f_1659},
{"f_1668posixunix.scm",(void*)f_1668},
{"f_1610posixunix.scm",(void*)f_1610},
{"f_1620posixunix.scm",(void*)f_1620},
{"f_1623posixunix.scm",(void*)f_1623},
{"f_1626posixunix.scm",(void*)f_1626},
{"f_1595posixunix.scm",(void*)f_1595},
{"f_1557posixunix.scm",(void*)f_1557},
{"f_1587posixunix.scm",(void*)f_1587},
{"f_1574posixunix.scm",(void*)f_1574},
{"f_1577posixunix.scm",(void*)f_1577},
{"f_1511posixunix.scm",(void*)f_1511},
{"f_1515posixunix.scm",(void*)f_1515},
{"f_1454posixunix.scm",(void*)f_1454},
{"f_1447posixunix.scm",(void*)f_1447},
{"f_1429posixunix.scm",(void*)f_1429},
{"f_1433posixunix.scm",(void*)f_1433},
{"f_1444posixunix.scm",(void*)f_1444},
{"f_1440posixunix.scm",(void*)f_1440},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}
/* end of file */
